/*
 * Decompiled with CFR 0.152.
 */
package dev.wuffs.bcc;

import com.google.gson.Gson;
import dev.wuffs.bcc.Config;
import dev.wuffs.bcc.Metadata;
import dev.wuffs.bcc.ModConfig;
import dev.wuffs.bcc.PingData;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BCC
implements ModInitializer {
    public static final String MODID = "bcc";
    public static ModConfig config;
    private static final Logger LOGGER;
    public static PingData localPingData;

    public static Logger getLogger() {
        return LOGGER;
    }

    public static boolean comparePingData(PingData pingData) {
        return pingData.projectID == BCC.localPingData.projectID && pingData.name.equals(BCC.localPingData.name) && pingData.version.equals(BCC.localPingData.version);
    }

    public void onInitialize() {
        config = Config.load();
        if (config != null) {
            BCC.getLogger().info("Config file loaded");
            if (BCC.config.useMetadata) {
                Path metaFile = FabricLoader.getInstance().getConfigDir().resolve("metadata.json");
                if (!Files.exists(metaFile, new LinkOption[0])) {
                    LOGGER.error("No metadata.json found, falling back to config values");
                } else {
                    try {
                        LOGGER.info("Loading metadata.json");
                        Metadata metadata = (Metadata)new Gson().fromJson((Reader)Files.newBufferedReader(metaFile), Metadata.class);
                        BCC.localPingData.projectID = metadata.id;
                        BCC.localPingData.name = metadata.name;
                        BCC.localPingData.version = metadata.version.name;
                        BCC.localPingData.versionID = metadata.version.id;
                        BCC.localPingData.releaseType = metadata.version.type;
                        BCC.localPingData.isMetadata = true;
                        return;
                    }
                    catch (IOException e) {
                        LOGGER.error("Failed to read metadata.json", (Throwable)e);
                    }
                }
            }
            BCC.localPingData.projectID = BCC.config.projectID;
            BCC.localPingData.name = BCC.config.modpackName;
            BCC.localPingData.version = BCC.config.modpackVersion;
        } else {
            BCC.getLogger().error("Failed to load config, disabling mod");
        }
    }

    static {
        LOGGER = LogManager.getLogger((String)MODID);
        localPingData = new PingData();
    }
}

