/*
 * Decompiled with CFR 0.152.
 */
package terrablender.worldgen.noise;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_6008;
import net.minecraft.class_6011;
import terrablender.api.BiomeProvider;
import terrablender.api.BiomeProviders;
import terrablender.worldgen.noise.AreaContext;
import terrablender.worldgen.noise.AreaTransformer0;

public class InitialLayer
implements AreaTransformer0 {
    private final WeightedRandomList<class_6008.class_6010<BiomeProvider>> weightedEntries = WeightedRandomList.create((List)BiomeProviders.get().stream().filter(provider -> (Integer)getWeight.apply((BiomeProvider)provider) > 0).map(provider -> class_6008.method_34980((Object)provider, (int)((Integer)getWeight.apply((BiomeProvider)provider)))).collect(ImmutableList.toImmutableList()));

    public InitialLayer(Function<BiomeProvider, Integer> getWeight) {
    }

    @Override
    public int apply(AreaContext context, int x, int y) {
        Optional<class_6008.class_6010<BiomeProvider>> entry = this.weightedEntries.getRandom(context);
        return entry.isPresent() ? ((BiomeProvider)entry.get().method_34983()).getIndex() : 0;
    }

    private static class WeightedRandomList<E extends class_6008> {
        private final int totalWeight;
        private final ImmutableList<E> items;

        WeightedRandomList(List<? extends E> items) {
            this.items = ImmutableList.copyOf(items);
            this.totalWeight = class_6011.method_34984(items);
        }

        public static <E extends class_6008> WeightedRandomList<E> create() {
            return new WeightedRandomList<E>(ImmutableList.of());
        }

        @SafeVarargs
        public static <E extends class_6008> WeightedRandomList<E> create(E ... entries) {
            return new WeightedRandomList<E>(ImmutableList.copyOf((Object[])entries));
        }

        public static <E extends class_6008> WeightedRandomList<E> create(List<E> entries) {
            return new WeightedRandomList<E>(entries);
        }

        public Optional<E> getRandom(AreaContext context) {
            if (this.totalWeight == 0) {
                return Optional.empty();
            }
            int i = context.nextRandom(this.totalWeight);
            return class_6011.method_34985(this.items, (int)i);
        }
    }
}

