/*
 * Decompiled with CFR 0.152.
 */
package terrablender.worldgen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5504;
import net.minecraft.class_5505;
import net.minecraft.class_5699;
import net.minecraft.class_5996;
import net.minecraft.class_6544;
import terrablender.worldgen.BiomeProviderUtils;
import terrablender.worldgen.TBClimate;

public class TBMultiNoiseBiomeSource
extends class_1966 {
    public static final MapCodec<TBMultiNoiseBiomeSource> DIRECT_CODEC = RecordCodecBuilder.mapCodec(p_187070_ -> p_187070_.group((App)class_5699.method_36973((Codec)RecordCodecBuilder.create(biomeMapping -> biomeMapping.group((App)TBClimate.ParameterPoint.CODEC.fieldOf("parameters").forGetter(Pair::getFirst), (App)class_1959.field_24677.fieldOf("biome").forGetter(Pair::getSecond)).apply((Applicative)biomeMapping, Pair::of)).listOf()).xmap(TBClimate.ParameterList::new, TBClimate.ParameterList::values).fieldOf("biomes").forGetter(p_187080_ -> p_187080_.parameters)).apply((Applicative)p_187070_, TBMultiNoiseBiomeSource::new));
    public static final Codec<TBMultiNoiseBiomeSource> CODEC = Codec.mapEither(PresetInstance.CODEC, DIRECT_CODEC).xmap(p_187068_ -> (TBMultiNoiseBiomeSource)((Object)((Object)p_187068_.map(PresetInstance::biomeSource, Function.identity()))), p_187066_ -> p_187066_.preset().map(Either::left).orElseGet(() -> Either.right((Object)p_187066_))).codec();
    private TBClimate.ParameterList<Supplier<class_1959>> parameters;
    private final Optional<PresetInstance> preset;

    private TBMultiNoiseBiomeSource(TBClimate.ParameterList<Supplier<class_1959>> p_187057_) {
        this(p_187057_, Optional.empty());
    }

    TBMultiNoiseBiomeSource(TBClimate.ParameterList<Supplier<class_1959>> parameters, Optional<PresetInstance> p_187060_) {
        super(parameters.values().stream().map(Pair::getSecond));
        this.preset = p_187060_;
        this.parameters = parameters;
    }

    protected Codec<? extends class_1966> method_28442() {
        return CODEC;
    }

    public class_1966 method_27985(long p_48466_) {
        return this;
    }

    public class_1959 method_38109(int p_186735_, int p_186736_, int p_186737_, class_6544.class_6552 sampler) {
        return this.getNoiseBiome(((TBClimate.Sampler)sampler).sampleTB(p_186735_, p_186736_, p_186737_));
    }

    private Optional<PresetInstance> preset() {
        return this.preset;
    }

    public boolean stable(Preset p_187064_) {
        return this.preset.isPresent() && Objects.equals(this.preset.get().preset(), p_187064_);
    }

    @class_5996
    public class_1959 getNoiseBiome(TBClimate.TargetPoint p_187062_) {
        return this.parameters.findValue(p_187062_, () -> class_5504.field_26735).get();
    }

    public TBClimate.ParameterList<Supplier<class_1959>> parameters() {
        return this.parameters;
    }

    record PresetInstance(Preset preset, class_2378<class_1959> biomes) {
        public static final MapCodec<PresetInstance> CODEC = RecordCodecBuilder.mapCodec(p_48558_ -> p_48558_.group((App)class_2960.field_25139.flatXmap(p_151869_ -> Optional.ofNullable(Preset.BY_NAME.get(p_151869_)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown preset: " + p_151869_))), p_151867_ -> DataResult.success((Object)p_151867_.name)).fieldOf("preset").stable().forGetter(PresetInstance::preset), (App)class_5505.method_31148((class_5321)class_2378.field_25114).forGetter(PresetInstance::biomes)).apply((Applicative)p_48558_, p_48558_.stable(PresetInstance::new)));

        public TBMultiNoiseBiomeSource biomeSource() {
            return this.preset.biomeSource(this, true);
        }
    }

    public static class Preset {
        static final Map<class_2960, Preset> BY_NAME = Maps.newHashMap();
        public static final Preset OVERWORLD = new Preset(new class_2960("terrablender", "overworld"), biomeRegistry -> Preset.createParameterSource((class_2378<class_1959>)biomeRegistry, BiomeProviderUtils::addAllOverworldBiomes));
        public static final Preset NETHER = new Preset(new class_2960("terrablender", "nether"), biomeRegistry -> Preset.createParameterSource((class_2378<class_1959>)biomeRegistry, BiomeProviderUtils::addAllNetherBiomes));
        final class_2960 name;
        private final Function<class_2378<class_1959>, TBClimate.ParameterList<Supplier<class_1959>>> parameterSource;

        public Preset(class_2960 name, Function<class_2378<class_1959>, TBClimate.ParameterList<Supplier<class_1959>>> parameterSource) {
            this.name = name;
            this.parameterSource = parameterSource;
            BY_NAME.put(name, this);
        }

        public TBMultiNoiseBiomeSource biomeSource(PresetInstance preset, boolean isPreset) {
            return new TBMultiNoiseBiomeSource(this.buildParameters(preset), isPreset ? Optional.of(preset) : Optional.empty());
        }

        public TBMultiNoiseBiomeSource biomeSource(class_2378<class_1959> biomeRegistry, boolean isPreset) {
            return this.biomeSource(new PresetInstance(this, biomeRegistry), isPreset);
        }

        public TBMultiNoiseBiomeSource biomeSource(class_2378<class_1959> biomeRegistry) {
            return this.biomeSource(biomeRegistry, true);
        }

        private TBClimate.ParameterList<Supplier<class_1959>> buildParameters(PresetInstance preset) {
            ImmutableList.Builder parameterListBuilder = ImmutableList.builder();
            parameterListBuilder.addAll(this.parameterSource.apply(preset.biomes()).values());
            return new TBClimate.ParameterList<Supplier<class_1959>>((List<Pair<TBClimate.ParameterPoint, Supplier<class_1959>>>)parameterListBuilder.build());
        }

        private static TBClimate.ParameterList<Supplier<class_1959>> createParameterSource(class_2378<class_1959> biomeRegistry, BiConsumer<class_2378<class_1959>, Consumer<Pair<TBClimate.ParameterPoint, class_5321<class_1959>>>> addBiomes) {
            ImmutableList.Builder builder = ImmutableList.builder();
            Consumer<Pair> mapper = parameterPair -> builder.add((Object)parameterPair.mapSecond(key -> () -> (class_1959)biomeRegistry.method_31140(key)));
            addBiomes.accept(biomeRegistry, mapper);
            return new TBClimate.ParameterList<Supplier<class_1959>>((List<Pair<TBClimate.ParameterPoint, Supplier<class_1959>>>)builder.build());
        }
    }
}

