/*
 * Decompiled with CFR 0.152.
 */
package terrablender.worldgen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_2338;
import net.minecraft.class_3532;
import net.minecraft.class_5742;
import net.minecraft.class_6544;
import terrablender.core.TerraBlender;
import terrablender.worldgen.BiomeProviderUtils;
import terrablender.worldgen.TBNoiseSampler;

public class TBClimate {
    private static final boolean DEBUG_SLOW_BIOME_SEARCH = false;
    private static final float QUANTIZATION_FACTOR = 10000.0f;
    @VisibleForTesting
    protected static final int PARAMETER_COUNT = 7;

    public static TargetPoint target(float temperature, float humidity, float continentalness, float erosion, float depth, float weirdness, float uniqueness) {
        return new TargetPoint(class_6544.method_38665((float)temperature), class_6544.method_38665((float)humidity), class_6544.method_38665((float)continentalness), class_6544.method_38665((float)erosion), class_6544.method_38665((float)depth), class_6544.method_38665((float)weirdness), class_6544.method_38665((float)uniqueness));
    }

    public static ParameterPoint parameters(float temperature, float humidity, float continentalness, float erosion, float depth, float weirdness, float uniqueness, float offset) {
        return new ParameterPoint(class_6544.class_6546.method_38120((float)temperature), class_6544.class_6546.method_38120((float)humidity), class_6544.class_6546.method_38120((float)continentalness), class_6544.class_6546.method_38120((float)erosion), class_6544.class_6546.method_38120((float)depth), class_6544.class_6546.method_38120((float)weirdness), class_6544.class_6546.method_38120((float)uniqueness), class_6544.method_38665((float)offset));
    }

    public static ParameterPoint parameters(class_6544.class_6546 temperature, class_6544.class_6546 humidity, class_6544.class_6546 continentalness, class_6544.class_6546 erosion, class_6544.class_6546 depth, class_6544.class_6546 weirdness, class_6544.class_6546 uniqueness, float offset) {
        return new ParameterPoint(temperature, humidity, continentalness, erosion, depth, weirdness, uniqueness, class_6544.method_38665((float)offset));
    }

    public static class_2338 findSpawnPosition(List<ParameterPoint> p_186807_, TBNoiseSampler p_186808_) {
        return new SpawnFinder(p_186807_, (TBNoiseSampler)p_186808_).result.location();
    }

    public record TargetPoint(long temperature, long humidity, long continentalness, long erosion, long depth, long weirdness, long uniqueness) {
        @VisibleForTesting
        protected long[] toParameterArray() {
            return new long[]{this.temperature, this.humidity, this.continentalness, this.erosion, this.depth, this.weirdness, 0L};
        }
    }

    public record ParameterPoint(class_6544.class_6546 temperature, class_6544.class_6546 humidity, class_6544.class_6546 continentalness, class_6544.class_6546 erosion, class_6544.class_6546 depth, class_6544.class_6546 weirdness, class_6544.class_6546 uniqueness, long offset) {
        public static final Codec<ParameterPoint> CODEC = RecordCodecBuilder.create(p_186885_ -> p_186885_.group((App)class_6544.class_6546.field_34478.fieldOf("temperature").forGetter(p_186905_ -> p_186905_.temperature), (App)class_6544.class_6546.field_34478.fieldOf("humidity").forGetter(p_186902_ -> p_186902_.humidity), (App)class_6544.class_6546.field_34478.fieldOf("continentalness").forGetter(p_186897_ -> p_186897_.continentalness), (App)class_6544.class_6546.field_34478.fieldOf("erosion").forGetter(p_186894_ -> p_186894_.erosion), (App)class_6544.class_6546.field_34478.fieldOf("depth").forGetter(p_186891_ -> p_186891_.depth), (App)class_6544.class_6546.field_34478.fieldOf("weirdness").forGetter(p_186888_ -> p_186888_.weirdness), (App)class_6544.class_6546.field_34478.fieldOf("uniqueness").forGetter(p_186888_ -> p_186888_.uniqueness), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("offset").xmap(class_6544::method_38665, class_6544::method_38666).forGetter(p_186881_ -> p_186881_.offset)).apply((Applicative)p_186885_, ParameterPoint::new));

        long fitness(TargetPoint target) {
            return class_3532.method_38652((long)this.temperature.method_38126(target.temperature)) + class_3532.method_38652((long)this.humidity.method_38126(target.humidity)) + class_3532.method_38652((long)this.continentalness.method_38126(target.continentalness)) + class_3532.method_38652((long)this.erosion.method_38126(target.erosion)) + class_3532.method_38652((long)this.depth.method_38126(target.depth)) + class_3532.method_38652((long)this.weirdness.method_38126(target.weirdness)) + class_3532.method_38652((long)this.offset);
        }

        protected List<class_6544.class_6546> parameterSpace() {
            return ImmutableList.of((Object)this.temperature, (Object)this.humidity, (Object)this.continentalness, (Object)this.erosion, (Object)this.depth, (Object)this.weirdness, (Object)new class_6544.class_6546(this.offset, this.offset));
        }
    }

    static class SpawnFinder {
        Result result;

        SpawnFinder(List<ParameterPoint> p_186980_, TBNoiseSampler p_186981_) {
            this.result = SpawnFinder.getSpawnPositionAndFitness(p_186980_, p_186981_, 0, 0);
            this.radialSearch(p_186980_, p_186981_, 2048.0f, 512.0f);
            this.radialSearch(p_186980_, p_186981_, 512.0f, 32.0f);
        }

        private void radialSearch(List<ParameterPoint> p_186983_, TBNoiseSampler p_186984_, float p_186985_, float p_186986_) {
            float f = 0.0f;
            float f1 = p_186986_;
            class_2338 blockpos = this.result.location();
            while (f1 <= p_186985_) {
                int j;
                int i = blockpos.method_10263() + (int)(Math.sin(f) * (double)f1);
                Result climate$spawnfinder$result = SpawnFinder.getSpawnPositionAndFitness(p_186983_, p_186984_, i, j = blockpos.method_10260() + (int)(Math.cos(f) * (double)f1));
                if (climate$spawnfinder$result.fitness() < this.result.fitness()) {
                    this.result = climate$spawnfinder$result;
                }
                if (!((double)(f += p_186986_ / f1) > Math.PI * 2)) continue;
                f = 0.0f;
                f1 += p_186986_;
            }
        }

        private static Result getSpawnPositionAndFitness(List<ParameterPoint> p_186988_, TBNoiseSampler p_186989_, int p_186990_, int p_186991_) {
            double d0 = class_3532.method_33723((double)2500.0);
            int i = 2;
            long j = (long)((double)class_3532.method_27285((float)10000.0f) * Math.pow((double)(class_3532.method_38652((long)p_186990_) + class_3532.method_38652((long)p_186991_)) / d0, 2.0));
            TargetPoint climate$targetpoint = p_186989_.sampleTB(class_5742.method_33100((int)p_186990_), 0, class_5742.method_33100((int)p_186991_));
            TargetPoint climate$targetpoint1 = new TargetPoint(climate$targetpoint.temperature(), climate$targetpoint.humidity(), climate$targetpoint.continentalness(), climate$targetpoint.erosion(), 0L, climate$targetpoint.weirdness(), climate$targetpoint.uniqueness());
            long k = Long.MAX_VALUE;
            for (ParameterPoint climate$parameterpoint : p_186988_) {
                k = Math.min(k, climate$parameterpoint.fitness(climate$targetpoint1));
            }
            return new Result(new class_2338(p_186990_, 0, p_186991_), j + k);
        }

        record Result(class_2338 location, long fitness) {
        }
    }

    public static interface Sampler
    extends class_6544.class_6552 {
        public TargetPoint sampleTB(int var1, int var2, int var3);

        default public class_6544.class_6553 sample(int x, int y, int z) {
            throw new RuntimeException("Vanilla sample called on TB sampler!");
        }

        default public class_2338 method_39165() {
            return class_2338.field_10980;
        }
    }

    protected static class RTree<T> {
        private static final int CHILDREN_PER_NODE = 10;
        private final Node<T> root;
        private final ThreadLocal<Leaf<T>> lastResult = new ThreadLocal();

        private RTree(Node<T> p_186913_) {
            this.root = p_186913_;
        }

        public static <T> RTree<T> create(List<Pair<ParameterPoint, T>> values) {
            if (values.isEmpty()) {
                throw new IllegalArgumentException("Need at least one value to build the search tree.");
            }
            int parameterCount = ((ParameterPoint)values.get(0).getFirst()).parameterSpace().size();
            if (parameterCount != 7) {
                throw new IllegalStateException("Expecting parameter space to be 7, got " + parameterCount);
            }
            List leaves = values.stream().map(value -> new Leaf<Object>((ParameterPoint)value.getFirst(), value.getSecond())).collect(Collectors.toCollection(ArrayList::new));
            return new RTree<T>(RTree.build(parameterCount, leaves));
        }

        private static <T> Node<T> build(int parameterCount, List<? extends Node<T>> nodes) {
            if (nodes.isEmpty()) {
                throw new IllegalStateException("Need at least one child to build a node");
            }
            if (nodes.size() == 1) {
                return nodes.get(0);
            }
            if (nodes.size() <= 10) {
                nodes.sort(Comparator.comparingLong(node -> {
                    long i1 = 0L;
                    for (int j1 = 0; j1 < parameterCount; ++j1) {
                        class_6544.class_6546 climate$parameter = node.parameterSpace[j1];
                        i1 += Math.abs((climate$parameter.comp_103() + climate$parameter.comp_104()) / 2L);
                    }
                    return i1;
                }));
                return new SubTree(nodes);
            }
            long i = Long.MAX_VALUE;
            int j = -1;
            List<SubTree<T>> list = null;
            for (int k = 0; k < parameterCount; ++k) {
                RTree.sort(nodes, parameterCount, k, false);
                List<SubTree<T>> list1 = RTree.bucketize(nodes);
                long l = 0L;
                for (SubTree<T> subtree : list1) {
                    l += RTree.cost(subtree.parameterSpace);
                }
                if (i <= l) continue;
                i = l;
                j = k;
                list = list1;
            }
            RTree.sort(list, parameterCount, j, true);
            return new SubTree(list.stream().map(p_186919_ -> RTree.build(parameterCount, Arrays.asList(p_186919_.children))).collect(Collectors.toList()));
        }

        private static <T> void sort(List<? extends Node<T>> p_186938_, int p_186939_, int p_186940_, boolean p_186941_) {
            Comparator<Node<Node<T>>> comparator = RTree.comparator(p_186940_, p_186941_);
            for (int i = 1; i < p_186939_; ++i) {
                comparator = comparator.thenComparing(RTree.comparator((p_186940_ + i) % p_186939_, p_186941_));
            }
            p_186938_.sort(comparator);
        }

        private static <T> Comparator<Node<T>> comparator(int p_186924_, boolean p_186925_) {
            return Comparator.comparingLong(p_186929_ -> {
                class_6544.class_6546 climate$parameter = p_186929_.parameterSpace[p_186924_];
                long i = (climate$parameter.comp_103() + climate$parameter.comp_104()) / 2L;
                return p_186925_ ? Math.abs(i) : i;
            });
        }

        private static <T> List<SubTree<T>> bucketize(List<? extends Node<T>> p_186945_) {
            ArrayList list = Lists.newArrayList();
            ArrayList list1 = Lists.newArrayList();
            int i = (int)Math.pow(10.0, Math.floor(Math.log((double)p_186945_.size() - 0.01) / Math.log(10.0)));
            for (Node<T> node : p_186945_) {
                list1.add(node);
                if (list1.size() < i) continue;
                list.add(new SubTree(list1));
                list1 = Lists.newArrayList();
            }
            if (!list1.isEmpty()) {
                list.add(new SubTree(list1));
            }
            return list;
        }

        private static long cost(class_6544.class_6546[] p_186943_) {
            long i = 0L;
            for (class_6544.class_6546 climate$parameter : p_186943_) {
                i += Math.abs(climate$parameter.comp_104() - climate$parameter.comp_103());
            }
            return i;
        }

        static <T> List<class_6544.class_6546> buildParameterSpace(List<? extends Node<T>> children) {
            if (children.isEmpty()) {
                throw new IllegalArgumentException("SubTree needs at least one child");
            }
            int i = 7;
            ArrayList list = Lists.newArrayList();
            for (int j = 0; j < 7; ++j) {
                list.add(null);
            }
            for (Node<T> node : children) {
                for (int k = 0; k < 7; ++k) {
                    list.set(k, node.parameterSpace[k].method_38127((class_6544.class_6546)list.get(k)));
                }
            }
            return list;
        }

        public T search(TargetPoint p_186931_, DistanceMetric<T> p_186932_) {
            long[] along = p_186931_.toParameterArray();
            Leaf<T> leaf = this.root.search(along, this.lastResult.get(), p_186932_);
            this.lastResult.set(leaf);
            return leaf.value;
        }

        static abstract class Node<T> {
            protected final class_6544.class_6546[] parameterSpace;

            protected Node(List<class_6544.class_6546> p_186958_) {
                this.parameterSpace = p_186958_.toArray(new class_6544.class_6546[0]);
            }

            protected abstract Leaf<T> search(long[] var1, @Nullable Leaf<T> var2, DistanceMetric<T> var3);

            protected long distance(long[] p_186960_) {
                long i = 0L;
                for (int j = 0; j < 7; ++j) {
                    i += class_3532.method_38652((long)this.parameterSpace[j].method_38126(p_186960_[j]));
                }
                return i;
            }

            public String toString() {
                return Arrays.toString(this.parameterSpace);
            }
        }

        static final class SubTree<T>
        extends Node<T> {
            final Node<T>[] children;

            protected SubTree(List<? extends Node<T>> p_186967_) {
                this(RTree.buildParameterSpace(p_186967_), p_186967_);
            }

            protected SubTree(List<class_6544.class_6546> p_186969_, List<? extends Node<T>> p_186970_) {
                super(p_186969_);
                this.children = p_186970_.toArray(new Node[0]);
            }

            @Override
            protected Leaf<T> search(long[] targets, @Nullable Leaf<T> lastResult, DistanceMetric<T> distanceMetric) {
                long distance = lastResult == null ? Long.MAX_VALUE : distanceMetric.distance(lastResult, targets);
                Leaf<T> leaf = lastResult;
                for (Node<T> node : this.children) {
                    long k;
                    long j = distanceMetric.distance(node, targets);
                    if (distance <= j) continue;
                    Leaf<T> leaf1 = node.search(targets, leaf, distanceMetric);
                    long l = k = node == leaf1 ? j : distanceMetric.distance(leaf1, targets);
                    if (distance <= k) continue;
                    distance = k;
                    leaf = leaf1;
                }
                return leaf;
            }
        }

        static final class Leaf<T>
        extends Node<T> {
            final T value;

            Leaf(ParameterPoint p_186950_, T p_186951_) {
                super(p_186950_.parameterSpace());
                this.value = p_186951_;
            }

            @Override
            protected Leaf<T> search(long[] targets, @Nullable Leaf<T> p_186954_, DistanceMetric<T> p_186955_) {
                return this;
            }
        }
    }

    protected static class UniquenessRTree<T> {
        private static final int VANILLA_UNIQUENESS = 0;
        private RTree[] trees;

        protected UniquenessRTree() {
        }

        public static <T> UniquenessRTree<T> create(List<Pair<ParameterPoint, T>> values) {
            RTree<T> vanillaTree;
            UniquenessRTree<T> tree = new UniquenessRTree<T>();
            List<Integer> uniquenesses = BiomeProviderUtils.getUniquenessValues(values);
            int maxUniqueness = uniquenesses.get(uniquenesses.size() - 1);
            tree.trees = new RTree[maxUniqueness + 1];
            tree.trees[0] = vanillaTree = RTree.create(UniquenessRTree.filterValues(0, values));
            for (int i = 0; i <= maxUniqueness; ++i) {
                if (i == 0) continue;
                int uniqueness = i;
                List filteredValues = values.stream().filter(pair -> {
                    class_6544.class_6546 uniquenessParameter = ((ParameterPoint)pair.getFirst()).uniqueness();
                    return (long)uniqueness >= uniquenessParameter.comp_103() && (long)uniqueness <= uniquenessParameter.comp_104();
                }).collect(Collectors.toCollection(ArrayList::new));
                if (!filteredValues.isEmpty()) {
                    tree.trees[i] = RTree.create(filteredValues);
                    continue;
                }
                if (!uniquenesses.contains(uniqueness)) continue;
                TerraBlender.LOGGER.info("No values found for uniqueness " + uniqueness + ", using Vanilla's");
                tree.trees[i] = vanillaTree;
            }
            return tree;
        }

        public T search(TargetPoint target, DistanceMetric<T> metric) {
            int uniqueness = (int)target.uniqueness();
            return this.trees[uniqueness].search(target, metric);
        }

        private static <T> List<Pair<ParameterPoint, T>> filterValues(int uniqueness, List<Pair<ParameterPoint, T>> values) {
            return values.stream().filter(pair -> {
                class_6544.class_6546 uniquenessParameter = ((ParameterPoint)pair.getFirst()).uniqueness();
                return (long)uniqueness >= uniquenessParameter.comp_103() && (long)uniqueness <= uniquenessParameter.comp_104();
            }).collect(Collectors.toCollection(ArrayList::new));
        }
    }

    public static class ParameterList<T> {
        private final List<Pair<ParameterPoint, T>> values;
        private final UniquenessRTree<T> index;

        public ParameterList(List<Pair<ParameterPoint, T>> p_186849_) {
            this.values = p_186849_;
            this.index = UniquenessRTree.create(p_186849_);
        }

        public List<Pair<ParameterPoint, T>> values() {
            return this.values;
        }

        public T findValue(TargetPoint target, T fallback) {
            return this.findValueIndex(target);
        }

        public T findValueIndex(TargetPoint p_186852_) {
            return this.findValueIndex(p_186852_, RTree.Node::distance);
        }

        protected T findValueIndex(TargetPoint p_186854_, DistanceMetric<T> p_186855_) {
            return this.index.search(p_186854_, p_186855_);
        }
    }

    static interface DistanceMetric<T> {
        public long distance(RTree.Node<T> var1, long[] var2);
    }
}

