/*
 * Decompiled with CFR 0.152.
 */
package terrablender.worldgen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6554;
import net.minecraft.class_6686;
import org.apache.logging.log4j.util.TriConsumer;
import terrablender.api.BiomeProvider;
import terrablender.api.BiomeProviders;
import terrablender.api.GenerationSettings;
import terrablender.core.TerraBlender;
import terrablender.data.DataPackManager;
import terrablender.worldgen.TBClimate;
import terrablender.worldgen.surface.NamespacedSurfaceRuleSource;

public class BiomeProviderUtils {
    private static final List<Pair<class_6544.class_4762, class_5321<class_1959>>> VANILLA_POINTS;
    private static Map<class_5321<class_1959>, List<class_6544.class_4762>> biomeParameterPointCache;
    private static Map<Integer, Float> uniquenessMidPointCache;
    private static Map<Integer, class_6544.class_6546> uniquenessParameterCache;

    public static class_6686.class_6708 createOverworldRules(class_6686.class_6708 base) {
        return BiomeProviderUtils.createNamespacedRuleSource(base, provider -> provider.getOverworldSurfaceRules());
    }

    public static class_6686.class_6708 createOverworldRules() {
        return BiomeProviderUtils.createOverworldRules(GenerationSettings.getDefaultOverworldSurfaceRules());
    }

    public static class_6686.class_6708 createNetherRules(class_6686.class_6708 base) {
        return BiomeProviderUtils.createNamespacedRuleSource(base, provider -> provider.getNetherSurfaceRules());
    }

    public static class_6686.class_6708 createNetherRules() {
        return BiomeProviderUtils.createNetherRules(GenerationSettings.getDefaultNetherSurfaceRules());
    }

    private static class_6686.class_6708 createNamespacedRuleSource(class_6686.class_6708 base, Function<BiomeProvider, Optional<class_6686.class_6708>> source) {
        return new NamespacedSurfaceRuleSource(base, (Map<String, class_6686.class_6708>)ImmutableMap.copyOf(BiomeProviderUtils.collectRuleSources(source)));
    }

    public static class_6544.class_6546 getUniquenessParameter(int index) {
        if (uniquenessParameterCache.containsKey(index)) {
            return uniquenessParameterCache.get(index);
        }
        class_6544.class_6546 parameter = new class_6544.class_6546((long)index, (long)index);
        uniquenessParameterCache.put(index, parameter);
        return parameter;
    }

    public static List<class_6544.class_4762> getVanillaParameterPoints(class_5321<class_1959> biome) {
        if (biomeParameterPointCache.containsKey(biome)) {
            return biomeParameterPointCache.get(biome);
        }
        List points = (List)VANILLA_POINTS.stream().filter(pair -> pair.getSecond() == biome).map(pair -> (class_6544.class_4762)pair.getFirst()).collect(ImmutableList.toImmutableList());
        biomeParameterPointCache.put(biome, points);
        return points;
    }

    public static <T> List<Integer> getUniquenessValues(List<Pair<TBClimate.ParameterPoint, T>> parameters) {
        List uniquenesses = (List)((ImmutableSet)parameters.stream().filter(value -> ((TBClimate.ParameterPoint)value.getFirst()).uniqueness().comp_103() == ((TBClimate.ParameterPoint)value.getFirst()).uniqueness().comp_104()).map(value -> (int)((TBClimate.ParameterPoint)value.getFirst()).uniqueness().comp_103()).collect(ImmutableSet.toImmutableSet())).stream().sorted().collect(ImmutableList.toImmutableList());
        if (uniquenesses.isEmpty()) {
            TerraBlender.LOGGER.error("No uniqueness values found in parameter values. Things may not work well!");
            return ImmutableList.of((Object)0);
        }
        if ((Integer)uniquenesses.get(0) != 0) {
            throw new IllegalStateException("Uniqueness values must start at 0");
        }
        return uniquenesses;
    }

    public static List<TBClimate.ParameterPoint> getAllSpawnTargets() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        BiomeProviders.get().forEach(provider -> builder.addAll(provider.getSpawnTargets()));
        return builder.build();
    }

    public static void addAllOverworldBiomes(class_2378<class_1959> registry, Consumer<Pair<TBClimate.ParameterPoint, class_5321<class_1959>>> mapper) {
        BiomeProviderUtils.addBiomesWithVerification(registry, mapper, BiomeProvider::getOverworldWeight, (TriConsumer<BiomeProvider, class_2378<class_1959>, Consumer<Pair<TBClimate.ParameterPoint, class_5321<class_1959>>>>)((TriConsumer)BiomeProvider::addOverworldBiomes));
    }

    public static void addAllNetherBiomes(class_2378<class_1959> registry, Consumer<Pair<TBClimate.ParameterPoint, class_5321<class_1959>>> mapper) {
        BiomeProviderUtils.addBiomesWithVerification(registry, mapper, BiomeProvider::getNetherWeight, (TriConsumer<BiomeProvider, class_2378<class_1959>, Consumer<Pair<TBClimate.ParameterPoint, class_5321<class_1959>>>>)((TriConsumer)BiomeProvider::addNetherBiomes));
    }

    private static void addBiomesWithVerification(class_2378<class_1959> registry, Consumer<Pair<TBClimate.ParameterPoint, class_5321<class_1959>>> mapper, Function<BiomeProvider, Integer> weight, TriConsumer<BiomeProvider, class_2378<class_1959>, Consumer<Pair<TBClimate.ParameterPoint, class_5321<class_1959>>>> add) {
        HashSet unusedIndices = Sets.newHashSet();
        BiomeProviders.get().forEach(provider -> {
            if ((Integer)weight.apply((BiomeProvider)provider) > 0 && provider.getName() != DataPackManager.DATA_PACK_PROVIDER_LOCATION) {
                unusedIndices.add(provider.getIndex());
            }
        });
        Consumer<Pair> verificationMapper = pair -> {
            class_6544.class_6546 uniqueness;
            if (!unusedIndices.isEmpty() && (uniqueness = ((TBClimate.ParameterPoint)pair.getFirst()).uniqueness()).comp_103() == uniqueness.comp_104()) {
                unusedIndices.remove((int)uniqueness.comp_103());
            }
            mapper.accept((Pair<TBClimate.ParameterPoint, class_5321<class_1959>>)pair);
        };
        BiomeProviders.get().forEach(provider -> add.accept(provider, (Object)registry, (Object)verificationMapper));
        if (unusedIndices.size() > 0) {
            throw new RuntimeException("Biome indices have been registered but haven't been utilised: " + unusedIndices + ". Either utilise the uniqueness assigned to your biome provider or set your provider's weight to 0.");
        }
    }

    private static Map<String, class_6686.class_6708> collectRuleSources(Function<BiomeProvider, Optional<class_6686.class_6708>> rulesSource) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BiomeProvider provider : BiomeProviders.get()) {
            Optional<class_6686.class_6708> rules = rulesSource.apply(provider);
            if (!rules.isPresent()) continue;
            builder.put((Object)provider.getName().method_12836(), (Object)rules.get());
        }
        return builder.build();
    }

    private static void onIndexReset() {
        uniquenessMidPointCache.clear();
        uniquenessParameterCache.clear();
    }

    static {
        biomeParameterPointCache = Maps.newHashMap();
        uniquenessMidPointCache = Maps.newHashMap();
        uniquenessParameterCache = Maps.newHashMap();
        BiomeProviders.addIndexResetListener(BiomeProviderUtils::onIndexReset);
        ImmutableList.Builder builder = new ImmutableList.Builder();
        new class_6554().method_38185(pair -> builder.add(pair));
        VANILLA_POINTS = builder.build();
    }
}

