/*
 * Decompiled with CFR 0.152.
 */
package terrablender.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_6686;
import terrablender.worldgen.TBSurfaceRuleData;

public class GenerationSettings {
    private static class_6686.class_6708 defaultOverworldSurfaceRules;
    private static class_6686.class_6708 defaultNetherSurfaceRules;
    private static List<Pair<Integer, class_6686.class_6708>> beforeBedrockOverworldSurfaceRules;
    private static List<Pair<Integer, class_6686.class_6708>> afterBedrockOverworldSurfaceRules;
    private static List<Pair<Integer, class_6686.class_6708>> beforeBedrockNetherSurfaceRules;
    private static List<Pair<Integer, class_6686.class_6708>> afterBedrockNetherSurfaceRules;

    public static void setDefaultOverworldSurfaceRules(class_6686.class_6708 rules) {
        defaultOverworldSurfaceRules = rules;
    }

    public static void setDefaultNetherSurfaceRules(class_6686.class_6708 rules) {
        defaultNetherSurfaceRules = rules;
    }

    public static void addBeforeBedrockOverworldSurfaceRules(int priority, class_6686.class_6708 rules) {
        beforeBedrockOverworldSurfaceRules.add((Pair<Integer, class_6686.class_6708>)Pair.of((Object)priority, (Object)rules));
    }

    public static void addBeforeBedrockOverworldSurfaceRules(class_6686.class_6708 rules) {
        GenerationSettings.addBeforeBedrockOverworldSurfaceRules(0, rules);
    }

    public static void addAfterBedrockOverworldSurfaceRules(int priority, class_6686.class_6708 rules) {
        afterBedrockOverworldSurfaceRules.add((Pair<Integer, class_6686.class_6708>)Pair.of((Object)priority, (Object)rules));
    }

    public static void addAfterBedrockOverworldSurfaceRules(class_6686.class_6708 rules) {
        GenerationSettings.addAfterBedrockOverworldSurfaceRules(0, rules);
    }

    public static void addBeforeBedrockNetherSurfaceRules(int priority, class_6686.class_6708 rules) {
        beforeBedrockNetherSurfaceRules.add((Pair<Integer, class_6686.class_6708>)Pair.of((Object)priority, (Object)rules));
    }

    public static void addBeforeBedrockNetherSurfaceRules(class_6686.class_6708 rules) {
        GenerationSettings.addBeforeBedrockNetherSurfaceRules(0, rules);
    }

    public static void addAfterBedrockNetherSurfaceRules(int priority, class_6686.class_6708 rules) {
        afterBedrockNetherSurfaceRules.add((Pair<Integer, class_6686.class_6708>)Pair.of((Object)priority, (Object)rules));
    }

    public static void addAfterBedrockNetherSurfaceRules(class_6686.class_6708 rules) {
        GenerationSettings.addAfterBedrockNetherSurfaceRules(0, rules);
    }

    public static class_6686.class_6708 getDefaultOverworldSurfaceRules() {
        if (defaultOverworldSurfaceRules == null) {
            defaultOverworldSurfaceRules = TBSurfaceRuleData.overworld();
        }
        return defaultOverworldSurfaceRules;
    }

    public static class_6686.class_6708 getDefaultNetherSurfaceRules() {
        if (defaultNetherSurfaceRules == null) {
            defaultNetherSurfaceRules = TBSurfaceRuleData.nether();
        }
        return defaultNetherSurfaceRules;
    }

    public static List<class_6686.class_6708> getBeforeBedrockOverworldSurfaceRules() {
        return (List)beforeBedrockOverworldSurfaceRules.stream().sorted(Comparator.comparing(Pair::getFirst, Comparator.reverseOrder())).map(Pair::getSecond).collect(ImmutableList.toImmutableList());
    }

    public static List<class_6686.class_6708> getAfterBedrockOverworldSurfaceRules() {
        return (List)afterBedrockOverworldSurfaceRules.stream().sorted(Comparator.comparing(Pair::getFirst, Comparator.reverseOrder())).map(Pair::getSecond).collect(ImmutableList.toImmutableList());
    }

    public static List<class_6686.class_6708> getBeforeBedrockNetherSurfaceRules() {
        return (List)beforeBedrockNetherSurfaceRules.stream().sorted(Comparator.comparing(Pair::getFirst, Comparator.reverseOrder())).map(Pair::getSecond).collect(ImmutableList.toImmutableList());
    }

    public static List<class_6686.class_6708> getAfterBedrockNetherSurfaceRules() {
        return (List)afterBedrockNetherSurfaceRules.stream().sorted(Comparator.comparing(Pair::getFirst, Comparator.reverseOrder())).map(Pair::getSecond).collect(ImmutableList.toImmutableList());
    }

    static {
        beforeBedrockOverworldSurfaceRules = Lists.newArrayList();
        afterBedrockOverworldSurfaceRules = Lists.newArrayList();
        beforeBedrockNetherSurfaceRules = Lists.newArrayList();
        afterBedrockNetherSurfaceRules = Lists.newArrayList();
    }
}

