/*
 * Decompiled with CFR 0.152.
 */
package terrablender.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import terrablender.api.BiomeProvider;
import terrablender.core.TerraBlender;
import terrablender.worldgen.DefaultBiomeProvider;

public class BiomeProviders {
    public static final class_2960 DEFAULT_PROVIDER_LOCATION = new class_2960("minecraft:biome_provider");
    private static LinkedHashMap<class_2960, BiomeProvider> biomeProviders = Maps.newLinkedHashMap();
    private static Map<class_2960, Integer> biomeIndices = Maps.newHashMap();
    private static List<Runnable> indexResetListeners = Lists.newArrayList();

    public static void register(class_2960 name, BiomeProvider provider) {
        biomeProviders.put(name, provider);
        int index = biomeProviders.size() - 1;
        biomeIndices.put(name, index);
        TerraBlender.LOGGER.info("Registered biome provider " + name + " to index " + index);
    }

    public static void register(class_2960 name, int index, BiomeProvider provider) {
        ArrayList entries = Lists.newArrayList(biomeProviders.entrySet());
        entries.add(index, Map.entry(name, provider));
        biomeProviders.clear();
        entries.forEach(entry -> biomeProviders.put((class_2960)entry.getKey(), (BiomeProvider)entry.getValue()));
        BiomeProviders.resetIndices();
        TerraBlender.LOGGER.info("Registered biome provider " + name + " to index " + index);
    }

    public static void register(BiomeProvider provider) {
        BiomeProviders.register(provider.getName(), provider);
    }

    public static void remove(class_2960 name) {
        if (!biomeProviders.containsKey(name)) {
            return;
        }
        biomeProviders.remove(name);
        BiomeProviders.resetIndices();
        TerraBlender.LOGGER.info("Removed biome provider " + name);
    }

    public static List<BiomeProvider> get() {
        return ImmutableList.copyOf(biomeProviders.values());
    }

    public static void addIndexResetListener(Runnable listener) {
        indexResetListeners.add(listener);
    }

    public static int getIndex(class_2960 location) {
        if (biomeIndices.containsKey(location)) {
            return biomeIndices.get(location);
        }
        if (!biomeProviders.containsKey(location)) {
            throw new RuntimeException("Attempted to get index of an unregistered biome provider " + location);
        }
        int index = ImmutableList.copyOf(biomeProviders.keySet()).indexOf((Object)location);
        biomeIndices.put(location, index);
        return index;
    }

    public static int getCount() {
        return biomeProviders.size();
    }

    private static void resetIndices() {
        biomeIndices.clear();
        indexResetListeners.forEach(listener -> listener.run());
    }

    static {
        BiomeProviders.register(DEFAULT_PROVIDER_LOCATION, new DefaultBiomeProvider(DEFAULT_PROVIDER_LOCATION, TerraBlender.CONFIG.vanillaOverworldRegionWeight, TerraBlender.CONFIG.vanillaNetherRegionWeight));
    }
}

