/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate.extra.dfu.v4;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.leangen.geantyref.TypeToken;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

final class TypeSerializerCodec<V>
implements Codec<V> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final TypeToken<V> token;
    private final TypeSerializer<V> serializer;
    private final DynamicOps<ConfigurationNode> ops;

    TypeSerializerCodec(TypeToken<V> token, TypeSerializer<V> serializer, DynamicOps<ConfigurationNode> ops) {
        this.token = Objects.requireNonNull(token, "token");
        this.serializer = Objects.requireNonNull(serializer, "serializer");
        this.ops = ops;
    }

    public <T> DataResult<Pair<V, T>> decode(DynamicOps<T> ops, T holder) {
        ConfigurationNode node = (ConfigurationNode)ops.convertTo(this.ops, holder);
        try {
            return DataResult.success((Object)Pair.of((Object)this.serializer.deserialize(this.token.getType(), node), holder));
        }
        catch (SerializationException ex) {
            LOGGER.debug(() -> "Error decoding value of type " + this.token, (Throwable)ex);
            return DataResult.error((String)ex.getMessage());
        }
    }

    public <T> DataResult<T> encode(V input, DynamicOps<T> ops, T container) {
        try {
            if (container instanceof ConfigurationNode) {
                this.serializer.serialize(this.token.getType(), input, (ConfigurationNode)container);
                return DataResult.success(container);
            }
            ConfigurationNode dest = (ConfigurationNode)this.ops.empty();
            this.serializer.serialize(this.token.getType(), input, dest);
            Object result = this.ops.convertTo(ops, (Object)dest);
            if (dest.isList()) {
                return ops.mergeToList(container, result);
            }
            if (dest.isMap()) {
                return ops.getMap(result).flatMap(map -> ops.mergeToMap(container, map));
            }
            return ops.mergeToPrimitive(container, result);
        }
        catch (SerializationException ex) {
            LOGGER.debug(() -> "Error encoding value of type " + this.token, (Throwable)ex);
            return DataResult.error((String)ex.getMessage());
        }
    }

    public String toString() {
        return "TypeSerializerCodec<" + this.token + '>';
    }
}

