/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate.extra.dfu.v4;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.extra.dfu.v4.ConfigurateOps;
import org.spongepowered.configurate.transformation.ConfigurationTransformation;

public final class DataFixerTransformation
implements ConfigurationTransformation.Versioned {
    private final NodePath versionPath;
    private final int targetVersion;
    private final ConfigurationTransformation wrapped;
    private final ThreadLocal<Integer> versionHolder;

    public static Builder dfuBuilder() {
        return new Builder();
    }

    DataFixerTransformation(NodePath versionPath, int targetVersion, ConfigurationTransformation wrapped, ThreadLocal<Integer> versionHolder) {
        this.versionPath = versionPath;
        this.targetVersion = targetVersion;
        this.wrapped = wrapped;
        this.versionHolder = versionHolder;
    }

    public void apply(@NonNull ConfigurationNode node) throws ConfigurateException {
        ConfigurationNode versionNode = node.node((Iterable)this.versionPath);
        int currentVersion = versionNode.getInt(-1);
        if (currentVersion < this.targetVersion) {
            this.versionHolder.set(currentVersion);
            this.wrapped.apply(node);
            versionNode.set((Object)this.targetVersion);
        } else if (currentVersion > this.targetVersion) {
            throw new ConfigurateException(node, "The target version (" + this.targetVersion + ") is older than the data's current version (" + currentVersion + ")");
        }
    }

    public int version(ConfigurationNode root) {
        return Objects.requireNonNull(root, "root").node((Iterable)this.versionKey()).getInt(-1);
    }

    public NodePath versionKey() {
        return this.versionPath;
    }

    public int latestVersion() {
        return this.targetVersion;
    }

    public static class Builder {
        private NodePath versionPath = NodePath.path((Object[])new Object[]{"dfu-version"});
        private int targetVersion = -1;
        private @Nullable DataFixer fixer;
        private final Set<Pair<DSL.TypeReference, NodePath>> dataFixes = new HashSet<Pair<DSL.TypeReference, NodePath>>();

        public Builder dataFixer(DataFixer fixer) {
            this.fixer = Objects.requireNonNull(fixer);
            return this;
        }

        public Builder versionKey(Object ... path) {
            this.versionPath = NodePath.of((Object[])Objects.requireNonNull(path, "path"));
            return this;
        }

        public Builder versionKey(NodePath path) {
            this.versionPath = Objects.requireNonNull(path, "path");
            return this;
        }

        public Builder targetVersion(int targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        public Builder addType(DSL.TypeReference type, Object ... path) {
            return this.addType(type, NodePath.of((Object[])path));
        }

        public Builder addType(DSL.TypeReference type, NodePath path) {
            this.dataFixes.add((Pair<DSL.TypeReference, NodePath>)Pair.of((Object)type, (Object)path));
            return this;
        }

        public DataFixerTransformation build() {
            Objects.requireNonNull(this.fixer, "A fixer must be provided!");
            if (this.targetVersion == -1) {
                this.targetVersion = DataFixUtils.getVersion((int)this.fixer.getSchema(0x7FFFFFFE).getVersionKey());
            }
            ConfigurationTransformation.Builder wrappedBuilder = ConfigurationTransformation.builder();
            ThreadLocal<Integer> versionHolder = new ThreadLocal<Integer>();
            for (Pair<DSL.TypeReference, NodePath> fix : this.dataFixes) {
                wrappedBuilder.addAction((NodePath)fix.getSecond(), (path, valueAtPath) -> {
                    valueAtPath.from((ConfigurationNode)this.fixer.update((DSL.TypeReference)fix.getFirst(), ConfigurateOps.wrap(valueAtPath), ((Integer)versionHolder.get()).intValue(), this.targetVersion).getValue());
                    return null;
                });
            }
            return new DataFixerTransformation(this.versionPath, this.targetVersion, wrappedBuilder.build(), versionHolder);
        }
    }
}

