/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate.extra.dfu.v4;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.BasicConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationNodeFactory;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.extra.dfu.v4.ConfigurateOpsBuilder;
import org.spongepowered.configurate.extra.dfu.v4.NodeMaplike;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;

public final class ConfigurateOps
implements DynamicOps<ConfigurationNode> {
    private static final ConfigurateOps UNCOMPRESSED = ConfigurateOps.builder().build();
    private static final ConfigurateOps COMPRESSED = ConfigurateOps.builder().compressed(true).build();
    private final ConfigurationNodeFactory<? extends ConfigurationNode> factory;
    private final boolean compressed;
    private final Protection readProtection;
    private final Protection writeProtection;

    public static DynamicOps<ConfigurationNode> instance() {
        return ConfigurateOps.instance(false);
    }

    public static DynamicOps<ConfigurationNode> instance(boolean compressed) {
        return compressed ? COMPRESSED : UNCOMPRESSED;
    }

    public static DynamicOps<ConfigurationNode> forSerializers(TypeSerializerCollection collection) {
        if (Objects.requireNonNull(collection, "collection").equals((Object)TypeSerializerCollection.defaults())) {
            return UNCOMPRESSED;
        }
        return ConfigurateOps.builder().factoryFromSerializers(collection).build();
    }

    public static Dynamic<ConfigurationNode> wrap(ConfigurationNode node) {
        if (node.options().serializers().equals((Object)TypeSerializerCollection.defaults())) {
            return new Dynamic(ConfigurateOps.instance(), (Object)node);
        }
        return ConfigurateOps.builder().factoryFromNode(node).buildWrapping(node);
    }

    public static DynamicOps<ConfigurationNode> fromNode(ConfigurationNode value) {
        return ConfigurateOps.builder().factoryFromNode(value).build();
    }

    public static ConfigurateOpsBuilder builder() {
        return new ConfigurateOpsBuilder();
    }

    ConfigurateOps(ConfigurationNodeFactory<? extends ConfigurationNode> factory, boolean compressed, Protection readProtection, Protection writeProtection) {
        this.factory = factory;
        this.compressed = compressed;
        this.readProtection = readProtection;
        this.writeProtection = writeProtection;
    }

    public boolean compressMaps() {
        return this.compressed;
    }

    static Object keyFrom(ConfigurationNode node) {
        if (node.isList() || node.isMap()) {
            throw new IllegalArgumentException("Key nodes must have scalar values");
        }
        return Objects.requireNonNull(node.raw(), "The provided key node must have a value");
    }

    ConfigurationNode guardOutputRead(ConfigurationNode untrusted) {
        switch (this.readProtection) {
            case COPY_DEEP: {
                return untrusted.copy();
            }
            case NONE: {
                return untrusted;
            }
        }
        throw new IllegalArgumentException("Unexpected state");
    }

    ConfigurationNode guardInputWrite(ConfigurationNode untrusted) {
        switch (this.writeProtection) {
            case COPY_DEEP: {
                return untrusted.copy();
            }
            case NONE: {
                return untrusted;
            }
        }
        throw new IllegalArgumentException("Unexpected state");
    }

    public ConfigurationNode empty() {
        return this.factory.createNode();
    }

    public ConfigurationNode emptyMap() {
        return this.empty().raw((Object)ImmutableMap.of());
    }

    public ConfigurationNode emptyList() {
        return this.empty().raw((Object)ImmutableList.of());
    }

    private <U> @Nullable U convertSelf(DynamicOps<U> outOps, ConfigurationNode input) {
        if (outOps instanceof ConfigurateOps) {
            return (U)input;
        }
        return null;
    }

    public <U> U convertTo(DynamicOps<U> targetOps, ConfigurationNode source) {
        @Nullable U self = this.convertSelf(Objects.requireNonNull(targetOps, "targetOps"), Objects.requireNonNull(source, "source"));
        if (self != null) {
            return self;
        }
        if (source.isMap()) {
            return (U)this.convertMap(targetOps, source);
        }
        if (source.isList()) {
            return (U)this.convertList(targetOps, source);
        }
        @Nullable Object value = source.rawScalar();
        if (value == null) {
            return (U)targetOps.empty();
        }
        if (value instanceof String) {
            return (U)targetOps.createString((String)value);
        }
        if (value instanceof Boolean) {
            return (U)targetOps.createBoolean(((Boolean)value).booleanValue());
        }
        if (value instanceof Short) {
            return (U)targetOps.createShort(((Short)value).shortValue());
        }
        if (value instanceof Integer) {
            return (U)targetOps.createInt(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return (U)targetOps.createLong(((Long)value).longValue());
        }
        if (value instanceof Float) {
            return (U)targetOps.createFloat(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return (U)targetOps.createDouble(((Double)value).doubleValue());
        }
        if (value instanceof Byte) {
            return (U)targetOps.createByte(((Byte)value).byteValue());
        }
        if (value instanceof byte[]) {
            return (U)targetOps.createByteList(ByteBuffer.wrap((byte[])value));
        }
        if (value instanceof int[]) {
            return (U)targetOps.createIntList(IntStream.of((int[])value));
        }
        if (value instanceof long[]) {
            return (U)targetOps.createLongList(LongStream.of((long[])value));
        }
        throw new IllegalArgumentException("Scalar value '" + source + "' has an unknown type: " + value.getClass().getName());
    }

    public DataResult<Number> getNumberValue(ConfigurationNode input) {
        if (!input.isMap() && !input.isList()) {
            @Nullable Object value = input.rawScalar();
            if (value instanceof Number) {
                return DataResult.success((Object)((Number)value));
            }
            if (value instanceof Boolean) {
                return DataResult.success((Object)((Boolean)value != false ? 1 : 0));
            }
            if (this.compressMaps()) {
                int result = input.getInt(Integer.MIN_VALUE);
                if (result == Integer.MIN_VALUE) {
                    return DataResult.error((String)"Value is not a number");
                }
                return DataResult.success((Object)result);
            }
        }
        return DataResult.error((String)("Not a number: " + input));
    }

    public DataResult<String> getStringValue(ConfigurationNode input) {
        @Nullable String value = input.getString();
        if (value != null) {
            return DataResult.success((Object)value);
        }
        return DataResult.error((String)("Not a string: " + input));
    }

    public ConfigurationNode createNumeric(Number value) {
        return this.empty().raw((Object)Objects.requireNonNull(value, "value"));
    }

    public ConfigurationNode createBoolean(boolean value) {
        return this.empty().raw((Object)value);
    }

    public ConfigurationNode createString(String value) {
        return this.empty().raw((Object)Objects.requireNonNull(value, "value"));
    }

    public DataResult<ConfigurationNode> mergeToPrimitive(ConfigurationNode prefix, ConfigurationNode value) {
        if (!prefix.empty()) {
            return DataResult.error((String)("Cannot merge " + value + " into non-empty node " + prefix));
        }
        return DataResult.success((Object)this.guardOutputRead(value));
    }

    public DataResult<ConfigurationNode> mergeToList(ConfigurationNode input, ConfigurationNode value) {
        if (input.isList() || input.empty()) {
            ConfigurationNode ret = this.guardOutputRead(input);
            ret.appendListNode().from(value);
            return DataResult.success((Object)ret);
        }
        return DataResult.error((String)("mergeToList called on a node which is not a list: " + input), (Object)input);
    }

    public DataResult<ConfigurationNode> mergeToList(ConfigurationNode input, List<ConfigurationNode> values) {
        if (input.isList() || input.empty()) {
            ConfigurationNode ret = this.guardInputWrite(input);
            for (ConfigurationNode node : values) {
                ret.appendListNode().from(node);
            }
            return DataResult.success((Object)ret);
        }
        return DataResult.error((String)("mergeToList called on a node which is not a list: " + input), (Object)input);
    }

    public DataResult<ConfigurationNode> mergeToMap(ConfigurationNode input, ConfigurationNode key, ConfigurationNode value) {
        if (input.isMap() || input.empty()) {
            ConfigurationNode copied = this.guardInputWrite(input);
            copied.node(new Object[]{ConfigurateOps.keyFrom(key)}).from(value);
            return DataResult.success((Object)copied);
        }
        return DataResult.error((String)("mergeToMap called on a node which is not a map: " + input), (Object)input);
    }

    public DataResult<Stream<Pair<ConfigurationNode, ConfigurationNode>>> getMapValues(ConfigurationNode input) {
        if (input.empty() || input.isMap()) {
            return DataResult.success(input.childrenMap().entrySet().stream().map(entry -> Pair.of((Object)BasicConfigurationNode.root((ConfigurationOptions)input.options()).raw(entry.getKey()), (Object)this.guardOutputRead((ConfigurationNode)entry.getValue()))));
        }
        return DataResult.error((String)("Not a map: " + input));
    }

    public DataResult<MapLike<ConfigurationNode>> getMap(ConfigurationNode input) {
        if (input.empty() || input.isMap()) {
            return DataResult.success((Object)new NodeMaplike(this, input.options(), input.childrenMap()));
        }
        return DataResult.error((String)"Input node is not a map");
    }

    public DataResult<Consumer<Consumer<ConfigurationNode>>> getList(ConfigurationNode input) {
        if (input.isList()) {
            return DataResult.success(action -> {
                for (ConfigurationNode child : input.childrenList()) {
                    action.accept(this.guardOutputRead(child));
                }
            });
        }
        return DataResult.error((String)"Input node is not a list");
    }

    public DataResult<Stream<ConfigurationNode>> getStream(ConfigurationNode input) {
        if (input.empty() || input.isList()) {
            Stream<ConfigurationNode> stream = input.childrenList().stream().map(this::guardOutputRead);
            return DataResult.success(stream);
        }
        return DataResult.error((String)("Not a list: " + input));
    }

    public ConfigurationNode createMap(Stream<Pair<ConfigurationNode, ConfigurationNode>> values) {
        ConfigurationNode ret = this.empty();
        values.forEach(p -> ret.node(new Object[]{ConfigurateOps.keyFrom((ConfigurationNode)p.getFirst())}).from((ConfigurationNode)p.getSecond()));
        return ret;
    }

    public ConfigurationNode createMap(Map<ConfigurationNode, ConfigurationNode> values) {
        ConfigurationNode ret = this.empty();
        for (Map.Entry<ConfigurationNode, ConfigurationNode> entry : values.entrySet()) {
            ret.node(new Object[]{ConfigurateOps.keyFrom(entry.getKey())}).from(entry.getValue());
        }
        return ret;
    }

    public ConfigurationNode createList(Stream<ConfigurationNode> input) {
        ConfigurationNode ret = this.empty();
        input.forEach(it -> ret.appendListNode().from(it));
        return ret;
    }

    public ConfigurationNode remove(ConfigurationNode input, String key) {
        if (input.isMap()) {
            ConfigurationNode ret = this.guardInputWrite(input);
            ret.node(new Object[]{key}).raw(null);
            return ret;
        }
        return input;
    }

    public DataResult<ConfigurationNode> get(ConfigurationNode input, String key) {
        ConfigurationNode ret = input.node(new Object[]{key});
        return ret.virtual() ? DataResult.error((String)("No element " + key + " in the map " + input)) : DataResult.success((Object)this.guardOutputRead(ret));
    }

    public DataResult<ConfigurationNode> getGeneric(ConfigurationNode input, ConfigurationNode key) {
        ConfigurationNode ret = input.node(new Object[]{ConfigurateOps.keyFrom(key)});
        return ret.virtual() ? DataResult.error((String)("No element " + key + " in the map " + input)) : DataResult.success((Object)this.guardOutputRead(ret));
    }

    public ConfigurationNode set(ConfigurationNode input, String key, ConfigurationNode value) {
        ConfigurationNode ret = this.guardInputWrite(input);
        ret.node(new Object[]{key}).from(value);
        return ret;
    }

    public ConfigurationNode update(ConfigurationNode input, String key, Function<ConfigurationNode, ConfigurationNode> function) {
        if (input.node(new Object[]{key}).virtual()) {
            return input;
        }
        ConfigurationNode ret = this.guardInputWrite(input);
        ConfigurationNode child = ret.node(new Object[]{key});
        child.from(function.apply(child));
        return ret;
    }

    public ConfigurationNode updateGeneric(ConfigurationNode input, ConfigurationNode wrappedKey, Function<ConfigurationNode, ConfigurationNode> function) {
        Object key = ConfigurateOps.keyFrom(wrappedKey);
        if (input.node(new Object[]{key}).virtual()) {
            return input;
        }
        ConfigurationNode ret = this.guardInputWrite(input);
        ConfigurationNode child = ret.node(new Object[]{key});
        child.from(function.apply(child));
        return ret;
    }

    public String toString() {
        return "Configurate";
    }

    public static enum Protection {
        COPY_DEEP,
        NONE;

    }
}

