/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate.extra.dfu.v4;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.lang.reflect.Type;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.extra.dfu.v4.ConfigurateOps;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;

final class CodecSerializer<V>
implements TypeSerializer<V> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ConfigurateOps DEFAULT_OPS = ConfigurateOps.builder().readWriteProtection(ConfigurateOps.Protection.NONE).build();
    private final Codec<V> codec;

    static DynamicOps<ConfigurationNode> opsFor(ConfigurationNode node) {
        if (node.options().serializers().equals((Object)TypeSerializerCollection.defaults())) {
            return DEFAULT_OPS;
        }
        return ConfigurateOps.builder().factoryFromNode(node).readWriteProtection(ConfigurateOps.Protection.NONE).build();
    }

    CodecSerializer(Codec<V> codec) {
        this.codec = Objects.requireNonNull(codec, "codec");
    }

    public V deserialize(@NonNull Type type, @NonNull ConfigurationNode value) throws SerializationException {
        DataResult result = this.codec.decode(CodecSerializer.opsFor(value), (Object)value);
        DataResult.PartialResult error = result.error().orElse(null);
        if (error != null) {
            LOGGER.debug("Unable to decode value using {} due to {}", this.codec, (Object)error.message());
            throw new SerializationException(error.message());
        }
        return (V)((Pair)result.result().orElseThrow(() -> new SerializationException("Neither a result or error was present"))).getFirst();
    }

    public void serialize(@NonNull Type type, @Nullable V obj, @NonNull ConfigurationNode value) throws SerializationException {
        DataResult result = this.codec.encode(obj, CodecSerializer.opsFor(value), (Object)value);
        DataResult.PartialResult error = result.error().orElse(null);
        if (error != null) {
            LOGGER.debug("Unable to encode value using {} due to {}", this.codec, (Object)error.message());
            throw new SerializationException(error.message());
        }
        value.set(result.result().orElseThrow(() -> new SerializationException("Neither a result or error was present")));
    }
}

