/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips;

import com.anthonyhilyard.iceberg.util.Selectors;
import com.anthonyhilyard.legendarytooltips.render.TooltipDecor;
import com.electronwill.nightconfig.core.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5251;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class LegendaryTooltipsConfig {
    public static final ForgeConfigSpec SPEC;
    public static final LegendaryTooltipsConfig INSTANCE;
    private static final FrameDefinition STANDARD_BORDER;
    private static final FrameDefinition NO_BORDER;
    public static final class_5251 DEFAULT_START_COLOR;
    public static final class_5251 DEFAULT_END_COLOR;
    public static final class_5251 DEFAULT_BG_COLOR;
    public final ForgeConfigSpec.BooleanValue nameSeparator;
    public final ForgeConfigSpec.BooleanValue bordersMatchRarity;
    public final ForgeConfigSpec.BooleanValue tooltipShadow;
    public final ForgeConfigSpec.BooleanValue shineEffect;
    public final ForgeConfigSpec.BooleanValue centeredTitle;
    public final ForgeConfigSpec.BooleanValue enforceMinimumWidth;
    private final class_5251[] startColors = new class_5251[16];
    private final class_5251[] endColors = new class_5251[16];
    private final class_5251[] bgColors = new class_5251[16];
    final ForgeConfigSpec.ConfigValue<List<? extends Integer>> framePriorities;
    static final List<ForgeConfigSpec.ConfigValue<List<? extends String>>> itemSelectors;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> blacklist;
    private static final Map<FrameDefinition, Set<String>> customFrameDefinitions;
    private static final Map<class_1799, FrameDefinition> frameDefinitionCache;
    static final List<ForgeConfigSpec.ConfigValue<Object>> startColorConfigs;
    static final List<ForgeConfigSpec.ConfigValue<Object>> endColorConfigs;
    private static final List<Supplier<ForgeConfigSpec.ConfigValue<?>>> startColorSuppliers;
    private static final List<Supplier<ForgeConfigSpec.ConfigValue<?>>> endColorSuppliers;
    private static final List<Supplier<ForgeConfigSpec.ConfigValue<?>>> bgColorSuppliers;

    public LegendaryTooltipsConfig(ForgeConfigSpec.Builder build) {
        int i;
        build.comment(" Legendary Tooltips Configuration Instructions\n\n *** READ THIS FIRST ***\n\n By default, this mod does not apply special borders to most items.  It was designed to work well with mod packs\n where the available selection of items can vary widely, so it is up to the user or mod pack designer to customize as needed.\n There are many options available for setting up which custom borders (also called frames) apply to which items.  Follow these steps:\n   1. Decide which items you want to have custom borders, and which borders.  Note that each custom border has a number associated with it (starting at 0).\n   2. For each custom border you want to use, fill out the associated list in the \"definitions\" section.  This will be filled out with a list of \"selectors\",\n      each of which tell the mod what items have that border.  Please read the information above the definitions section for specifics.\n   3. Selectors for borders are checked in the order provided in the \"priorities\" section.  Once a match is found, that border is displayed.\n      For example, if border 0 had the selector \"%Diamond\" and border 1 had the selector \"diamond_sword\", they would both match for diamond swords.\n      In this case, whichever border number came first in the priority list would be the border that would get drawn in-game.\n   4. Optionally, border colors associated with custom borders can be set in the \"colors\" section.  The start color is the color at the top of the tooltip,\n      and the end color is the bottom, with a smooth transition between.  Please read the information above the color section for specifics.").push("client").push("visual_options");
        this.nameSeparator = build.comment(" Whether item names in tooltips should have a line under them separating them from the rest of the tooltip.").define("name_separator", true);
        this.bordersMatchRarity = build.comment(" If enabled, tooltip border colors will match item rarity colors (except for custom borders).").define("borders_match_rarity", true);
        this.tooltipShadow = build.comment(" If enabled, tooltips will display a drop shadow.").define("tooltip_shadow", true);
        this.shineEffect = build.comment(" If enabled, items showing a custom border will have a special shine effect when hovered over.").define("shine_effect", true);
        this.centeredTitle = build.comment(" If enabled, tooltip titles will be drawn centered.").define("centered_title", true);
        this.enforceMinimumWidth = build.comment(" If enabled, tooltips with custom borders will always be at least wide enough to display all border decorations.").define("enforce_minimum_width", false);
        build.pop().comment(String.format(" Custom borders are broken into %d \"levels\", with level 0 being intended for the \"best\" or \"rarest\" items. Only level 0 has a custom border built-in, but others can be added with resource packs.", 16)).push("custom_borders");
        StringBuilder selectorsComment = new StringBuilder(" Entry types:\n");
        for (Selectors.SelectorDocumentation doc : Selectors.selectorDocumentation()) {
            selectorsComment.append("    ").append(doc.name()).append(" - ").append(doc.description());
            if (!doc.examples().isEmpty()) {
                selectorsComment.append("  Examples: ");
                for (int i2 = 0; i2 < doc.examples().size(); ++i2) {
                    if (i2 > 0) {
                        selectorsComment.append(", ");
                    }
                    selectorsComment.append("\"").append((String)doc.examples().get(i2)).append("\"");
                }
            }
            selectorsComment.append("\n");
        }
        selectorsComment.setLength(selectorsComment.length() - 1);
        build.pop().comment(selectorsComment.toString());
        build.push("definitions");
        itemSelectors.clear();
        itemSelectors.add((ForgeConfigSpec.ConfigValue<List<? extends String>>)build.defineListAllowEmpty(Arrays.asList("level0_entries"), () -> Arrays.asList("!epic", "!rare"), e -> Selectors.validateSelector((String)((String)e))));
        for (i = 1; i < 16; ++i) {
            itemSelectors.add((ForgeConfigSpec.ConfigValue<List<? extends String>>)build.defineListAllowEmpty(Arrays.asList(String.format("level%d_entries", i)), () -> new ArrayList(), e -> Selectors.validateSelector((String)((String)e))));
        }
        this.blacklist = build.comment(" Enter blacklist selectors here using the same format as above. Any items that match these selectors will NOT show a border.").defineListAllowEmpty(Arrays.asList("blacklist"), () -> Arrays.asList(new String[0]), e -> Selectors.validateSelector((String)((String)e)));
        build.pop().comment(" Set border priorities here.  This should be a list of numbers that correspond to border levels, with numbers coming first being higher priority.  Optionally, -1 can be inserted to indicate relative priority of data and api-defined borders.  If you don't know what that means, don't worry about it.").push("priorities");
        this.framePriorities = build.defineList("priorities", () -> IntStream.rangeClosed(0, 15).boxed().collect(Collectors.toList()), e -> (Integer)e >= -1 && (Integer)e < 16);
        build.pop().comment(" The start and end border colors and background colors of each level.\n Note that they can be entered as any one of: a decimal or hex color code in the format 0xAARRGGBB or 0xRRGGBB, OR a string color name or color code.\n Examples: 0xFFFF00, 0xFF73D984, 4290445567, \"red\", \"#FFCC00\" are all valid.").push("colors");
        startColorSuppliers.clear();
        endColorSuppliers.clear();
        bgColorSuppliers.clear();
        startColorConfigs.clear();
        endColorConfigs.clear();
        for (i = 0; i < 16; ++i) {
            int index = i;
            ForgeConfigSpec.ConfigValue startColorValue = build.define(String.format("level%d_start_color", i), (Object)((long)DEFAULT_START_COLOR.method_27716() & 0xFFFFFFFFL), v -> LegendaryTooltipsConfig.validateColor(v));
            ForgeConfigSpec.ConfigValue endColorValue = build.define(String.format("level%d_end_color", i), (Object)((long)DEFAULT_END_COLOR.method_27716() & 0xFFFFFFFFL), v -> LegendaryTooltipsConfig.validateColor(v));
            ForgeConfigSpec.ConfigValue bgColorValue = build.define(String.format("level%d_bg_color", i), (Object)((long)DEFAULT_BG_COLOR.method_27716() & 0xFFFFFFFFL), v -> LegendaryTooltipsConfig.validateColor(v));
            startColorConfigs.add((ForgeConfigSpec.ConfigValue<Object>)startColorValue);
            endColorConfigs.add((ForgeConfigSpec.ConfigValue<Object>)endColorValue);
            startColorSuppliers.add(() -> startColorConfigs.get(index));
            endColorSuppliers.add(() -> endColorConfigs.get(index));
            bgColorSuppliers.add(() -> bgColorValue);
        }
        build.pop().pop();
    }

    public static class_5251 getColor(Object value) {
        class_5251 color = null;
        if (value instanceof String) {
            String colorString = ((String)value).toLowerCase().replace("0x", "").replace("#", "");
            color = class_5251.method_27719((String)colorString);
            if (color == null && (colorString.length() == 6 || colorString.length() == 8)) {
                color = class_5251.method_27719((String)("#" + colorString));
            }
        } else if (value instanceof Long) {
            int colorValue = (int)((Long)value & 0xFFFFFFFFL);
            color = class_5251.method_27717((int)colorValue);
        }
        if (color != null && color.method_27716() > 0 && color.method_27716() <= 0xFFFFFF) {
            color = class_5251.method_27717((int)(color.method_27716() | 0xFF000000));
        }
        return color;
    }

    private static boolean validateColor(Object value) {
        return LegendaryTooltipsConfig.getColor(value) != null;
    }

    private static void resolveColors() {
        for (int i = 0; i < 16; ++i) {
            Supplier<ForgeConfigSpec.ConfigValue<?>> startColorSupplier = startColorSuppliers.get(i);
            Supplier<ForgeConfigSpec.ConfigValue<?>> endColorSupplier = endColorSuppliers.get(i);
            Supplier<ForgeConfigSpec.ConfigValue<?>> bgColorSupplier = bgColorSuppliers.get(i);
            LegendaryTooltipsConfig.INSTANCE.startColors[i] = LegendaryTooltipsConfig.getColor(startColorSupplier.get().get());
            LegendaryTooltipsConfig.INSTANCE.endColors[i] = LegendaryTooltipsConfig.getColor(endColorSupplier.get().get());
            LegendaryTooltipsConfig.INSTANCE.bgColors[i] = LegendaryTooltipsConfig.getColor(bgColorSupplier.get().get());
        }
    }

    public void addFrameDefinition(class_2960 resource, int index, Integer startBorder, Integer endBorder, Integer background, int priority, List<String> selectors) {
        FrameDefinition definition = new FrameDefinition(resource, index, startBorder, endBorder, background, FrameSource.API, priority);
        this.addFrameDefinition(definition, selectors);
    }

    void addFrameDefinition(FrameDefinition definition, List<String> selectors) {
        if (definition.source != FrameSource.API && definition.source != FrameSource.DATA) {
            return;
        }
        LinkedHashSet<String> selectorSet = new LinkedHashSet<String>();
        if (customFrameDefinitions.containsKey(definition)) {
            selectorSet.addAll((Collection)customFrameDefinitions.get(definition));
        }
        selectorSet.addAll(selectors);
        customFrameDefinitions.put(definition, selectorSet);
    }

    public FrameDefinition getFrameDefinition(class_1799 item) {
        if (frameDefinitionCache.containsKey(item)) {
            return frameDefinitionCache.get(item);
        }
        if (item == null) {
            frameDefinitionCache.put(item, STANDARD_BORDER);
            return STANDARD_BORDER;
        }
        if (this.startColors[0] == null) {
            LegendaryTooltipsConfig.resolveColors();
        }
        for (String entry : (List)this.blacklist.get()) {
            if (!Selectors.itemMatches((class_1799)item, (String)entry)) continue;
            frameDefinitionCache.put(item, NO_BORDER);
            return NO_BORDER;
        }
        List priorities = ((List)this.framePriorities.get()).stream().map(i -> (int)i).collect(Collectors.toCollection(ArrayList::new));
        if (!priorities.contains(-1)) {
            priorities.add(0, -1);
        }
        for (int i2 = 0; i2 < priorities.size(); ++i2) {
            int frameIndex = (Integer)priorities.get(i2);
            if (frameIndex != -1 && frameIndex < 16) {
                class_5251 startColor = this.startColors[frameIndex] == null ? DEFAULT_START_COLOR : this.startColors[frameIndex];
                class_5251 endColor = this.endColors[frameIndex] == null ? DEFAULT_END_COLOR : this.endColors[frameIndex];
                class_5251 bgColor = this.bgColors[frameIndex] == null ? DEFAULT_BG_COLOR : this.bgColors[frameIndex];
                for (String entry : (List)itemSelectors.get(frameIndex).get()) {
                    if (!Selectors.itemMatches((class_1799)item, (String)entry)) continue;
                    FrameDefinition frameDefinition = new FrameDefinition(TooltipDecor.DEFAULT_BORDERS, frameIndex, startColor.method_27716(), endColor.method_27716(), bgColor.method_27716(), FrameSource.CONFIG, i2);
                    frameDefinitionCache.put(item, frameDefinition);
                    return frameDefinition;
                }
                continue;
            }
            List sortedDefinitions = customFrameDefinitions.keySet().stream().sorted((a, b) -> Integer.compare(a.priority, b.priority)).toList();
            for (FrameDefinition frameDefinition : sortedDefinitions) {
                for (String entry : customFrameDefinitions.get(frameDefinition)) {
                    if (!Selectors.itemMatches((class_1799)item, (String)entry)) continue;
                    frameDefinitionCache.put(item, frameDefinition);
                    return frameDefinition;
                }
            }
        }
        frameDefinitionCache.put(item, STANDARD_BORDER);
        return STANDARD_BORDER;
    }

    public static void reset() {
        frameDefinitionCache.clear();
        LegendaryTooltipsConfig.resolveColors();
    }

    public static void onLoad(ModConfig config) {
        if (config.getModId().equals("legendarytooltips")) {
            LegendaryTooltipsConfig.reset();
        }
    }

    static {
        STANDARD_BORDER = new FrameDefinition(null, -1, null, null, null, FrameSource.NONE, 0);
        NO_BORDER = new FrameDefinition(null, -2, null, null, null, FrameSource.NONE, 0);
        DEFAULT_START_COLOR = class_5251.method_27717((int)-6723294);
        DEFAULT_END_COLOR = class_5251.method_27717((int)-10864099);
        DEFAULT_BG_COLOR = class_5251.method_27717((int)-266991104);
        itemSelectors = new ArrayList<ForgeConfigSpec.ConfigValue<List<? extends String>>>(16);
        customFrameDefinitions = new LinkedHashMap<FrameDefinition, Set<String>>();
        frameDefinitionCache = new HashMap<class_1799, FrameDefinition>();
        startColorConfigs = new ArrayList<ForgeConfigSpec.ConfigValue<Object>>();
        endColorConfigs = new ArrayList<ForgeConfigSpec.ConfigValue<Object>>();
        startColorSuppliers = new ArrayList();
        endColorSuppliers = new ArrayList();
        bgColorSuppliers = new ArrayList();
        Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(LegendaryTooltipsConfig::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        INSTANCE = (LegendaryTooltipsConfig)specPair.getLeft();
    }

    public record FrameDefinition(class_2960 resource, int index, Integer startBorder, Integer endBorder, Integer background, FrameSource source, int priority) {
    }

    public static enum FrameSource {
        NONE,
        CONFIG,
        API,
        DATA;

    }
}

