/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips;

import com.anthonyhilyard.iceberg.events.RenderTickEvents;
import com.anthonyhilyard.iceberg.events.RenderTooltipEvents;
import com.anthonyhilyard.iceberg.util.ItemColor;
import com.anthonyhilyard.legendarytooltips.FrameResourceParser;
import com.anthonyhilyard.legendarytooltips.LegacyConfigConverter;
import com.anthonyhilyard.legendarytooltips.LegendaryTooltipsConfig;
import com.anthonyhilyard.legendarytooltips.render.TooltipDecor;
import com.mojang.datafixers.util.Either;
import java.awt.Color;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraftforge.api.ModLoadingContext;
import net.minecraftforge.api.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class LegendaryTooltips
implements ClientModInitializer {
    public static final int STANDARD = -1;
    public static final int NO_BORDER = -2;
    public static final int NUM_FRAMES = 16;
    private static class_1799 lastTooltipItem = null;

    public void onInitializeClient() {
        ModLoadingContext.registerConfig((String)"legendarytooltips", (ModConfig.Type)ModConfig.Type.COMMON, (IConfigSpec)LegendaryTooltipsConfig.SPEC);
        LegacyConfigConverter.convert();
        RenderTooltipEvents.GATHER.register(LegendaryTooltips::onGatherComponentsEvent);
        RenderTooltipEvents.COLOREXT.register(LegendaryTooltips::onTooltipColorEvent);
        RenderTooltipEvents.POSTEXT.register(LegendaryTooltips::onPostTooltipEvent);
        RenderTickEvents.START.register(LegendaryTooltips::onRenderTick);
        ModConfigEvent.RELOADING.register(LegendaryTooltipsConfig::onLoad);
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)FrameResourceParser.INSTANCE);
    }

    private static LegendaryTooltipsConfig.FrameDefinition getDefinitionColors(class_1799 item, int defaultStartBorder, int defaultEndBorder, int defaultBackground) {
        LegendaryTooltipsConfig.FrameDefinition result = LegendaryTooltipsConfig.INSTANCE.getFrameDefinition(item);
        switch (result.index()) {
            case -2: {
                result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), defaultStartBorder, defaultEndBorder, defaultBackground, LegendaryTooltipsConfig.FrameSource.NONE, 0);
                break;
            }
            case -1: {
                if (!((Boolean)LegendaryTooltipsConfig.INSTANCE.bordersMatchRarity.get()).booleanValue()) break;
                class_5251 rarityColor = ItemColor.getColorForItem((class_1799)item, (class_5251)class_5251.method_27718((class_124)class_124.field_1068));
                float[] hsbVals = new float[3];
                Color.RGBtoHSB(rarityColor.method_27716() >> 16 & 0xFF, rarityColor.method_27716() >> 8 & 0xFF, rarityColor.method_27716() >> 0 & 0xFF, hsbVals);
                boolean addHue = false;
                if (hsbVals[0] * 360.0f < 62.0f) {
                    addHue = false;
                } else if (hsbVals[0] * 360.0f <= 240.0f) {
                    addHue = true;
                }
                float startHue = addHue ? hsbVals[0] - 0.006f : hsbVals[0] + 0.006f;
                float endHue = addHue ? hsbVals[0] + 0.04f : hsbVals[0] - 0.04f;
                startHue = (startHue + 1.0f) % 1.0f;
                endHue = (endHue + 1.0f) % 1.0f;
                class_5251 startColor = class_5251.method_27717((int)Color.getHSBColor(startHue, hsbVals[1], hsbVals[2]).getRGB());
                class_5251 endColor = class_5251.method_27717((int)Color.getHSBColor(endHue, hsbVals[1], hsbVals[2]).getRGB());
                class_5251 backgroundColor = class_5251.method_27717((int)Color.getHSBColor(hsbVals[0], hsbVals[1] * 0.9f, 0.06f).getRGB());
                result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), startColor.method_27716() & 0xAAFFFFFF, endColor.method_27716() & 0x44FFFFFF, backgroundColor.method_27716() & 0xF0FFFFFF, LegendaryTooltipsConfig.FrameSource.NONE, 0);
            }
        }
        if (result.startBorder() == null) {
            result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), defaultStartBorder, result.endBorder(), result.background(), LegendaryTooltipsConfig.FrameSource.NONE, 0);
        }
        if (result.endBorder() == null) {
            result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), result.startBorder(), defaultEndBorder, result.background(), LegendaryTooltipsConfig.FrameSource.NONE, 0);
        }
        if (result.background() == null) {
            result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), result.startBorder(), result.endBorder(), defaultBackground, LegendaryTooltipsConfig.FrameSource.NONE, 0);
        }
        return result;
    }

    public static void onRenderTick(float timer) {
        class_310 client = class_310.method_1551();
        TooltipDecor.updateTimer();
        if (client.field_1755 != null && client.field_1755 instanceof class_465 && ((class_465)client.field_1755).field_2787 != null && ((class_465)client.field_1755).field_2787.method_7681() && lastTooltipItem != ((class_465)client.field_1755).field_2787.method_7677()) {
            TooltipDecor.resetTimer();
            lastTooltipItem = ((class_465)client.field_1755).field_2787.method_7677();
        }
    }

    public static RenderTooltipEvents.GatherResult onGatherComponentsEvent(class_1799 itemStack, int screenWidth, int screenHeight, List<Either<class_5348, class_5632>> tooltipElements, int maxWidth, int index) {
        if (LegendaryTooltipsConfig.INSTANCE.getFrameDefinition(itemStack).index() != -2) {
            TooltipDecor.setCachedLines(tooltipElements, index);
        }
        return new RenderTooltipEvents.GatherResult(class_1269.field_5811, maxWidth, tooltipElements);
    }

    public static RenderTooltipEvents.ColorExtResult onTooltipColorEvent(class_1799 stack, List<class_5684> components, class_4587 poseStack, int x, int y, class_327 font, int backgroundStart, int backgroundEnd, int borderStart, int borderEnd, boolean comparison, int index) {
        LegendaryTooltipsConfig.FrameDefinition frameDefinition = LegendaryTooltips.getDefinitionColors(stack, borderStart, borderEnd, backgroundStart);
        TooltipDecor.setCurrentTooltipBorderStart(frameDefinition.startBorder());
        TooltipDecor.setCurrentTooltipBorderEnd(frameDefinition.endBorder());
        RenderTooltipEvents.ColorExtResult result = comparison ? new RenderTooltipEvents.ColorExtResult(frameDefinition.background().intValue(), frameDefinition.background().intValue(), 0, 0) : new RenderTooltipEvents.ColorExtResult(frameDefinition.background().intValue(), frameDefinition.background().intValue(), frameDefinition.startBorder().intValue(), frameDefinition.endBorder().intValue());
        return result;
    }

    public static void onPostTooltipEvent(class_1799 itemStack, List<class_5684> components, class_4587 poseStack, int x, int y, class_327 font, int width, int height, boolean comparison, int index) {
        if (LegendaryTooltipsConfig.INSTANCE.getFrameDefinition(itemStack).index() == -2) {
            return;
        }
        if (((Boolean)LegendaryTooltipsConfig.INSTANCE.tooltipShadow.get()).booleanValue()) {
            if (comparison) {
                TooltipDecor.drawShadow(poseStack, x, y - 11, width, height + 11);
            } else {
                TooltipDecor.drawShadow(poseStack, x, y, width, height);
            }
        }
        if (comparison) {
            TooltipDecor.drawBorder(poseStack, x, y - 11, width, height + 11, itemStack, font, LegendaryTooltipsConfig.INSTANCE.getFrameDefinition(itemStack), comparison, index);
        } else {
            TooltipDecor.drawBorder(poseStack, x, y, width, height, itemStack, font, LegendaryTooltipsConfig.INSTANCE.getFrameDefinition(itemStack), comparison, index);
        }
    }
}

