/*
 * Decompiled with CFR 0.152.
 */
package malte0811.ferritecore.util;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import malte0811.ferritecore.ducks.SmallThreadDetectable;
import net.minecraft.class_5798;

public class SmallThreadingDetector {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void acquire(SmallThreadDetectable obj, String name) {
        byte oldState;
        SmallThreadDetectable smallThreadDetectable = obj;
        synchronized (smallThreadDetectable) {
            oldState = obj.ferritecore$getState();
            if (oldState == 0) {
                obj.ferritecore$setState((byte)1);
                return;
            }
            if (oldState == 1) {
                GlobalCrashHandler.startCrash(obj, name);
                obj.ferritecore$setState((byte)2);
            }
        }
        if (oldState == 1) {
            GlobalCrashHandler.crashAcquire(obj);
        } else {
            GlobalCrashHandler.crashBystander(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(SmallThreadDetectable obj) {
        byte oldState;
        SmallThreadDetectable smallThreadDetectable = obj;
        synchronized (smallThreadDetectable) {
            oldState = obj.ferritecore$getState();
            if (oldState == 1) {
                obj.ferritecore$setState((byte)0);
                return;
            }
        }
        if (oldState == 2) {
            GlobalCrashHandler.crashRelease(obj);
        }
    }

    private static class GlobalCrashHandler {
        private static final Object MONITOR = new Object();
        private static final Map<SmallThreadDetectable, CrashingState> ACTIVE_CRASHES = new IdentityHashMap<SmallThreadDetectable, CrashingState>();

        private GlobalCrashHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void startCrash(SmallThreadDetectable owner, String name) {
            Object object = MONITOR;
            synchronized (object) {
                ACTIVE_CRASHES.put(owner, new CrashingState(name));
            }
        }

        private static void crashAcquire(SmallThreadDetectable owner) {
            CrashingState state = GlobalCrashHandler.getAndWait(owner, ThreadRole.ACQUIRE);
            throw class_5798.method_33564((String)state.name, (Thread)state.acquireThread);
        }

        private static void crashRelease(SmallThreadDetectable owner) {
            CrashingState state = GlobalCrashHandler.getAndWait(owner, ThreadRole.RELEASE);
            throw class_5798.method_33564((String)state.name, (Thread)state.releaseThread);
        }

        private static void crashBystander(SmallThreadDetectable owner) {
            CrashingState state = GlobalCrashHandler.getAndWait(owner, ThreadRole.BYSTANDER);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException x) {
                Thread.currentThread().interrupt();
            }
            throw new RuntimeException("Bystander to crash of type" + state.name + "on threads " + state.releaseThread + ", " + state.acquireThread);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static CrashingState getAndWait(SmallThreadDetectable owner, ThreadRole role) {
            CrashingState result;
            Object object = MONITOR;
            synchronized (object) {
                result = Objects.requireNonNull(ACTIVE_CRASHES.get(owner));
            }
            result.waitUntilReady(role);
            return result;
        }
    }

    private static enum ThreadRole {
        ACQUIRE,
        RELEASE,
        BYSTANDER;

    }

    private static class CrashingState {
        final String name;
        Thread acquireThread;
        Thread releaseThread;

        private CrashingState(String name) {
            this.name = name;
        }

        public synchronized void waitUntilReady(ThreadRole role) {
            if (role == ThreadRole.ACQUIRE) {
                this.acquireThread = Thread.currentThread();
            } else if (role == ThreadRole.RELEASE) {
                this.releaseThread = Thread.currentThread();
            }
            this.notifyAll();
            try {
                long maxTotalTime = 10000L;
                long start = System.currentTimeMillis();
                while (this.acquireThread == null || this.releaseThread == null) {
                    if (System.currentTimeMillis() - start > 10000L) {
                        throw new RuntimeException("Threading detector crash did not find other thread, missing release call?");
                    }
                    this.wait(10000L);
                }
            }
            catch (InterruptedException x) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

