/*
 * Decompiled with CFR 0.152.
 */
package malte0811.ferritecore.impl;

import com.google.common.base.Suppliers;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import malte0811.ferritecore.ducks.BlockStateCacheAccess;
import malte0811.ferritecore.hash.ArrayVoxelShapeHash;
import malte0811.ferritecore.hash.VoxelShapeHash;
import malte0811.ferritecore.mixin.blockstatecache.ArrayVSAccess;
import malte0811.ferritecore.mixin.blockstatecache.SliceShapeAccess;
import malte0811.ferritecore.util.Constants;
import net.minecraft.class_245;
import net.minecraft.class_265;
import net.minecraft.class_4970;
import org.apache.commons.lang3.tuple.Pair;

public class BlockStateCacheImpl {
    public static final Map<ArrayVSAccess, ArrayVSAccess> CACHE_COLLIDE = new Object2ObjectOpenCustomHashMap((Hash.Strategy)ArrayVoxelShapeHash.INSTANCE);
    public static final Map<class_265, Pair<class_265, class_265[]>> CACHE_PROJECT = new Object2ObjectOpenCustomHashMap((Hash.Strategy)VoxelShapeHash.INSTANCE);
    private static final Supplier<Function<class_4970.class_4971, BlockStateCacheAccess>> GET_CACHE = Suppliers.memoize(() -> {
        try {
            Field cacheField = class_4970.class_4971.class.getDeclaredField(Constants.blockstateCacheFieldName);
            cacheField.setAccessible(true);
            MethodHandle getter = MethodHandles.lookup().unreflectGetter(cacheField);
            return state -> {
                try {
                    return getter.invoke((class_4970.class_4971)state);
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            };
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    });
    private static final ThreadLocal<BlockStateCacheAccess> LAST_CACHE = new ThreadLocal();

    public static void deduplicateCachePre(class_4970.class_4971 state) {
        LAST_CACHE.set(GET_CACHE.get().apply(state));
    }

    public static void deduplicateCachePost(class_4970.class_4971 state) {
        BlockStateCacheAccess newCache = GET_CACHE.get().apply(state);
        if (newCache != null) {
            BlockStateCacheAccess oldCache = LAST_CACHE.get();
            BlockStateCacheImpl.deduplicateCollisionShape(newCache, oldCache);
            BlockStateCacheImpl.deduplicateRenderShapes(newCache, oldCache);
            LAST_CACHE.set(null);
        }
    }

    private static void deduplicateCollisionShape(BlockStateCacheAccess newCache, @Nullable BlockStateCacheAccess oldCache) {
        class_265 dedupedCollisionShape;
        if (oldCache != null && VoxelShapeHash.INSTANCE.equals(oldCache.getCollisionShape(), newCache.getCollisionShape())) {
            dedupedCollisionShape = oldCache.getCollisionShape();
        } else {
            dedupedCollisionShape = newCache.getCollisionShape();
            if (dedupedCollisionShape instanceof ArrayVSAccess) {
                ArrayVSAccess access = (ArrayVSAccess)dedupedCollisionShape;
                dedupedCollisionShape = (class_265)CACHE_COLLIDE.computeIfAbsent(access, Function.identity());
            }
        }
        BlockStateCacheImpl.replaceInternals(dedupedCollisionShape, newCache.getCollisionShape());
        newCache.setCollisionShape(dedupedCollisionShape);
    }

    private static void deduplicateRenderShapes(BlockStateCacheAccess newCache, @Nullable BlockStateCacheAccess oldCache) {
        Pair newPair;
        class_265 oldRenderShape;
        class_265 newRenderShape = BlockStateCacheImpl.getRenderShape(newCache.getOcclusionShapes());
        if (newRenderShape == null) {
            return;
        }
        Pair dedupedRenderShapes = null;
        if (oldCache != null && VoxelShapeHash.INSTANCE.equals(newRenderShape, oldRenderShape = BlockStateCacheImpl.getRenderShape(oldCache.getOcclusionShapes()))) {
            dedupedRenderShapes = Pair.of((Object)oldRenderShape, (Object)oldCache.getOcclusionShapes());
        }
        if (dedupedRenderShapes == null && (dedupedRenderShapes = CACHE_PROJECT.putIfAbsent(newRenderShape, (Pair<class_265, class_265[]>)(newPair = Pair.of((Object)newRenderShape, (Object)newCache.getOcclusionShapes())))) == null) {
            dedupedRenderShapes = newPair;
        }
        BlockStateCacheImpl.replaceInternals((class_265)dedupedRenderShapes.getLeft(), newRenderShape);
        newCache.setOcclusionShapes((class_265[])dedupedRenderShapes.getRight());
    }

    private static void replaceInternals(class_265 toKeep, class_265 toReplace) {
        if (toKeep instanceof class_245) {
            class_245 keepArray = (class_245)toKeep;
            if (toReplace instanceof class_245) {
                class_245 replaceArray = (class_245)toReplace;
                BlockStateCacheImpl.replaceInternals(keepArray, replaceArray);
            }
        }
    }

    public static void replaceInternals(class_245 toKeep, class_245 toReplace) {
        if (toKeep == toReplace) {
            return;
        }
        ArrayVSAccess toReplaceAccess = (ArrayVSAccess)toReplace;
        ArrayVSAccess toKeepAccess = (ArrayVSAccess)toKeep;
        toReplaceAccess.setXPoints(toKeepAccess.getXPoints());
        toReplaceAccess.setYPoints(toKeepAccess.getYPoints());
        toReplaceAccess.setZPoints(toKeepAccess.getZPoints());
        toReplaceAccess.setFaces(toKeepAccess.getFaces());
        toReplaceAccess.setShape(toKeepAccess.getShape());
    }

    @Nullable
    private static class_265 getRenderShape(@Nullable class_265[] projected) {
        if (projected != null) {
            for (class_265 side : projected) {
                if (!(side instanceof SliceShapeAccess)) continue;
                SliceShapeAccess slice = (SliceShapeAccess)side;
                return slice.getDelegate();
            }
        }
        return null;
    }
}

