/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.shape;

import dev.ftb.mods.ftbultimine.EntityDistanceComparator;
import dev.ftb.mods.ftbultimine.shape.BlockMatcher;
import dev.ftb.mods.ftbultimine.shape.Shape;
import dev.ftb.mods.ftbultimine.shape.ShapeContext;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

public class ShapelessShape
extends Shape {
    public static final class_2338[] NEIGHBOR_POSITIONS = new class_2338[26];
    public static final class_2338[] NEIGHBOR_POSITIONS_PLANT = new class_2338[24];

    @Override
    public String getName() {
        return "shapeless";
    }

    @Override
    public boolean isDefault() {
        return true;
    }

    @Override
    public List<class_2338> getBlocks(ShapeContext context) {
        HashSet<class_2338> known = new HashSet<class_2338>();
        this.walk(context, known, context.matcher == BlockMatcher.BUSH);
        ArrayList<class_2338> list = new ArrayList<class_2338>(known);
        list.sort(new EntityDistanceComparator(context.pos));
        if (list.size() > context.maxBlocks) {
            list.subList(context.maxBlocks, list.size()).clear();
        }
        return list;
    }

    private void walk(ShapeContext context, HashSet<class_2338> known, boolean plant) {
        HashSet<class_2338> traversed = new HashSet<class_2338>();
        ArrayDeque<class_2338> openSet = new ArrayDeque<class_2338>();
        openSet.add(context.pos);
        traversed.add(context.pos);
        while (!openSet.isEmpty()) {
            class_2338 ptr = (class_2338)openSet.pop();
            if (!context.check(ptr) || !known.add(ptr)) continue;
            if (known.size() >= context.maxBlocks) {
                return;
            }
            for (class_2338 side : plant ? NEIGHBOR_POSITIONS_PLANT : NEIGHBOR_POSITIONS) {
                class_2338 offset = ptr.method_10081((class_2382)side);
                if (!traversed.add(offset)) continue;
                openSet.add(offset);
            }
        }
    }

    static {
        ShapelessShape.NEIGHBOR_POSITIONS[0] = new class_2338(1, 0, 0);
        ShapelessShape.NEIGHBOR_POSITIONS[1] = new class_2338(-1, 0, 0);
        ShapelessShape.NEIGHBOR_POSITIONS[2] = new class_2338(0, 0, 1);
        ShapelessShape.NEIGHBOR_POSITIONS[3] = new class_2338(0, 0, -1);
        ShapelessShape.NEIGHBOR_POSITIONS[4] = new class_2338(0, 1, 0);
        ShapelessShape.NEIGHBOR_POSITIONS[5] = new class_2338(0, -1, 0);
        ShapelessShape.NEIGHBOR_POSITIONS[6] = new class_2338(1, 0, 1);
        ShapelessShape.NEIGHBOR_POSITIONS[7] = new class_2338(1, 0, -1);
        ShapelessShape.NEIGHBOR_POSITIONS[8] = new class_2338(-1, 0, 1);
        ShapelessShape.NEIGHBOR_POSITIONS[9] = new class_2338(-1, 0, -1);
        ShapelessShape.NEIGHBOR_POSITIONS[10] = new class_2338(1, 1, 0);
        ShapelessShape.NEIGHBOR_POSITIONS[11] = new class_2338(-1, 1, 0);
        ShapelessShape.NEIGHBOR_POSITIONS[12] = new class_2338(0, 1, 1);
        ShapelessShape.NEIGHBOR_POSITIONS[13] = new class_2338(0, 1, -1);
        ShapelessShape.NEIGHBOR_POSITIONS[14] = new class_2338(1, -1, 0);
        ShapelessShape.NEIGHBOR_POSITIONS[15] = new class_2338(-1, -1, 0);
        ShapelessShape.NEIGHBOR_POSITIONS[16] = new class_2338(0, -1, 1);
        ShapelessShape.NEIGHBOR_POSITIONS[17] = new class_2338(0, -1, -1);
        ShapelessShape.NEIGHBOR_POSITIONS[18] = new class_2338(1, 1, 1);
        ShapelessShape.NEIGHBOR_POSITIONS[19] = new class_2338(1, 1, -1);
        ShapelessShape.NEIGHBOR_POSITIONS[20] = new class_2338(-1, 1, 1);
        ShapelessShape.NEIGHBOR_POSITIONS[21] = new class_2338(-1, 1, -1);
        ShapelessShape.NEIGHBOR_POSITIONS[22] = new class_2338(1, -1, 1);
        ShapelessShape.NEIGHBOR_POSITIONS[23] = new class_2338(1, -1, -1);
        ShapelessShape.NEIGHBOR_POSITIONS[24] = new class_2338(-1, -1, 1);
        ShapelessShape.NEIGHBOR_POSITIONS[25] = new class_2338(-1, -1, -1);
        ShapelessShape.NEIGHBOR_POSITIONS_PLANT[0] = new class_2338(1, 0, 0);
        ShapelessShape.NEIGHBOR_POSITIONS_PLANT[1] = new class_2338(-1, 0, 0);
        ShapelessShape.NEIGHBOR_POSITIONS_PLANT[2] = new class_2338(0, 0, 1);
        ShapelessShape.NEIGHBOR_POSITIONS_PLANT[3] = new class_2338(0, 0, -1);
        ShapelessShape.NEIGHBOR_POSITIONS_PLANT[4] = new class_2338(1, 0, 1);
        ShapelessShape.NEIGHBOR_POSITIONS_PLANT[5] = new class_2338(1, 0, -1);
        ShapelessShape.NEIGHBOR_POSITIONS_PLANT[6] = new class_2338(-1, 0, 1);
        ShapelessShape.NEIGHBOR_POSITIONS_PLANT[7] = new class_2338(-1, 0, -1);
        ShapelessShape.NEIGHBOR_POSITIONS_PLANT[8] = new class_2338(2, 0, 0);
        ShapelessShape.NEIGHBOR_POSITIONS_PLANT[9] = new class_2338(-2, 0, 0);
        ShapelessShape.NEIGHBOR_POSITIONS_PLANT[10] = new class_2338(0, 0, 2);
        ShapelessShape.NEIGHBOR_POSITIONS_PLANT[11] = new class_2338(0, 0, -2);
        ShapelessShape.NEIGHBOR_POSITIONS_PLANT[12] = new class_2338(-1, 0, -2);
        ShapelessShape.NEIGHBOR_POSITIONS_PLANT[13] = new class_2338(1, 0, -2);
        ShapelessShape.NEIGHBOR_POSITIONS_PLANT[14] = new class_2338(2, 0, -1);
        ShapelessShape.NEIGHBOR_POSITIONS_PLANT[15] = new class_2338(2, 0, 1);
        ShapelessShape.NEIGHBOR_POSITIONS_PLANT[16] = new class_2338(2, 0, 2);
        ShapelessShape.NEIGHBOR_POSITIONS_PLANT[17] = new class_2338(-2, 0, 2);
        ShapelessShape.NEIGHBOR_POSITIONS_PLANT[18] = new class_2338(-2, 0, 1);
        ShapelessShape.NEIGHBOR_POSITIONS_PLANT[19] = new class_2338(-2, 0, -1);
        ShapelessShape.NEIGHBOR_POSITIONS_PLANT[20] = new class_2338(2, 0, 2);
        ShapelessShape.NEIGHBOR_POSITIONS_PLANT[21] = new class_2338(2, 0, -2);
        ShapelessShape.NEIGHBOR_POSITIONS_PLANT[22] = new class_2338(-2, 0, 2);
        ShapelessShape.NEIGHBOR_POSITIONS_PLANT[23] = new class_2338(-2, 0, -2);
    }
}

