/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.config;

import dev.architectury.hooks.tags.TagHooks;
import dev.ftb.mods.ftblibrary.snbt.config.ConfigUtil;
import dev.ftb.mods.ftblibrary.snbt.config.DoubleValue;
import dev.ftb.mods.ftblibrary.snbt.config.IntValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.mods.ftblibrary.snbt.config.StringListValue;
import dev.ftb.mods.ftbultimine.FTBUltimine;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.server.MinecraftServer;

public interface FTBUltimineServerConfig {
    public static final SNBTConfig CONFIG = (SNBTConfig)SNBTConfig.create((String)"ftbultimine-server").comment(new String[]{"Server-specific configuration for FTB Ultimine", "This file is meant for server administrators to control user behaviour.", "Changes in this file currently require a server restart to take effect"});
    public static final IntValue MAX_BLOCKS = (IntValue)CONFIG.getInt("max_blocks", 64).range(32768).comment(new String[]{"Max amount of blocks that can be ultimined at once"});
    public static final DoubleValue EXHAUSTION_PER_BLOCK = (DoubleValue)CONFIG.getDouble("exhaustion_per_block", 20.0).range(10000.0).comment(new String[]{"Hunger multiplied for each block mined with ultimine"});
    public static final BlockTagsConfig MERGE_TAGS = new BlockTagsConfig(CONFIG, "merge_tags", Arrays.asList("minecraft:base_stone_overworld", "c:*_ores", "forge:ores/*"), "These tags will be considered the same block when checking for blocks to Ultimine");

    public static void load(MinecraftServer server) {
        ConfigUtil.loadDefaulted((SNBTConfig)CONFIG, (Path)server.method_27050(ConfigUtil.SERVER_CONFIG_DIR), (String)"ftbultimine");
        FTBUltimineServerConfig.MERGE_TAGS.tags = null;
        if ((Integer)MAX_BLOCKS.get() > 8192) {
            FTBUltimine.LOGGER.warn("maxBlocks is set to more than 8192 blocks!");
            FTBUltimine.LOGGER.warn("This may cause a lot of tick and FPS lag!");
        }
    }

    public static class BlockTagsConfig {
        public final String name;
        public final SNBTConfig config;
        public final StringListValue value;
        private Collection<class_3494<class_2248>> tags = null;

        public BlockTagsConfig(SNBTConfig parent, String name, List<String> defaults, String ... comment) {
            this.name = name;
            this.config = parent;
            this.value = (StringListValue)this.config.getStringList(name, defaults).comment(comment);
        }

        public Collection<class_3494<class_2248>> getTags() {
            if (this.tags == null) {
                this.tags = new HashSet<class_3494<class_2248>>();
                ((List)this.value.get()).forEach(s -> {
                    class_2960 rl = class_2960.method_12829((String)s);
                    if (rl != null) {
                        this.tags.add((class_3494<class_2248>)TagHooks.optionalBlock((class_2960)rl));
                    } else {
                        Pattern pattern = this.regexFromGlobString((String)s);
                        class_3481.method_15073().method_30204().forEach((id, tag) -> {
                            if (pattern.asPredicate().test(id.toString())) {
                                this.tags.add((class_3494<class_2248>)tag);
                            }
                        });
                    }
                });
            }
            return this.tags;
        }

        public Pattern regexFromGlobString(String glob) {
            StringBuilder sb = new StringBuilder();
            sb.append("^");
            for (int i = 0; i < glob.length(); ++i) {
                char c = glob.charAt(i);
                if (c == '*') {
                    sb.append(".*");
                    continue;
                }
                if (c == '?') {
                    sb.append(".");
                    continue;
                }
                if (c == '.') {
                    sb.append("\\.");
                    continue;
                }
                if (c == '\\') {
                    sb.append("\\\\");
                    continue;
                }
                sb.append(c);
            }
            sb.append("$");
            return Pattern.compile(sb.toString());
        }
    }
}

