/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.ftb.mods.ftbultimine.FTBUltimine;
import dev.ftb.mods.ftbultimine.FTBUltimineCommon;
import dev.ftb.mods.ftbultimine.client.CachedEdge;
import dev.ftb.mods.ftbultimine.client.UltimineRenderTypes;
import dev.ftb.mods.ftbultimine.config.FTBUltimineClientConfig;
import dev.ftb.mods.ftbultimine.event.LevelRenderLastEvent;
import dev.ftb.mods.ftbultimine.net.KeyPressedPacket;
import dev.ftb.mods.ftbultimine.net.ModeChangedPacket;
import dev.ftb.mods.ftbultimine.net.SendShapePacket;
import dev.ftb.mods.ftbultimine.utils.ShapeMerger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1159;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_4184;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5481;

public class FTBUltimineClient
extends FTBUltimineCommon {
    public static class_304 keyBinding;
    private boolean pressed;
    private boolean canUltimine;
    private List<class_2338> shapeBlocks = Collections.emptyList();
    private int actualBlocks = 0;
    private List<CachedEdge> cachedEdges = null;
    private class_2338 cachedPos = null;
    public boolean hasScrolled = false;
    private long lastToggle = 0L;
    public final int INPUT_DELAY = 125;
    private final int infoOffset = 0;

    public FTBUltimineClient() {
        ClientLifecycleEvent.CLIENT_SETUP.register(this::setup);
        ClientLifecycleEvent.CLIENT_LEVEL_LOAD.register(__ -> FTBUltimineClientConfig.load());
        ClientTickEvent.CLIENT_PRE.register(this::clientTick);
        ClientGuiEvent.RENDER_HUD.register(this::renderGameOverlay);
        LevelRenderLastEvent.EVENT.register(this::renderInGame);
        ClientRawInputEvent.MOUSE_SCROLLED.register(this::mouseEvent);
        ClientRawInputEvent.KEY_PRESSED.register(this::onKeyPress);
    }

    private void setup(class_310 minecraft) {
        keyBinding = new class_304("key.ftbultimine", class_3675.class_307.field_1668, 96, "key.categories.ftbultimine");
        KeyMappingRegistry.register((class_304)keyBinding);
    }

    @Override
    public void setShape(List<class_2338> blocks) {
        this.actualBlocks = blocks.size();
        int maxRendered = Math.min(this.actualBlocks, (Integer)FTBUltimineClientConfig.renderOutline.get());
        this.shapeBlocks = blocks.subList(0, maxRendered);
        this.cachedEdges = null;
        this.updateEdges();
    }

    public void renderInGame(class_4587 stack) {
        if (!this.pressed || this.cachedPos == null || this.cachedEdges == null || this.cachedEdges.isEmpty()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (!this.canUltimine) {
            return;
        }
        class_4184 activeRenderInfo = mc.method_1561().field_4686;
        class_243 projectedView = activeRenderInfo.method_19326();
        stack.method_22903();
        stack.method_22904((double)this.cachedPos.method_10263() - projectedView.field_1352, (double)this.cachedPos.method_10264() - projectedView.field_1351, (double)this.cachedPos.method_10260() - projectedView.field_1350);
        class_1159 matrix = stack.method_23760().method_23761();
        class_4588 buffer = mc.method_22940().method_23000().getBuffer(UltimineRenderTypes.LINES_NORMAL);
        for (CachedEdge edge : this.cachedEdges) {
            buffer.method_22918(matrix, edge.x1, edge.y1, edge.z1).method_1336(255, 255, 255, 255).method_1344();
            buffer.method_22918(matrix, edge.x2, edge.y2, edge.z2).method_1336(255, 255, 255, 255).method_1344();
        }
        mc.method_22940().method_23000().method_22994(UltimineRenderTypes.LINES_NORMAL);
        class_4588 buffer2 = mc.method_22940().method_23000().getBuffer(UltimineRenderTypes.LINES_TRANSPARENT);
        for (CachedEdge edge : this.cachedEdges) {
            buffer2.method_22918(matrix, edge.x1, edge.y1, edge.z1).method_1336(255, 255, 255, 10).method_1344();
            buffer2.method_22918(matrix, edge.x2, edge.y2, edge.z2).method_1336(255, 255, 255, 10).method_1344();
        }
        mc.method_22940().method_23000().method_22994(UltimineRenderTypes.LINES_TRANSPARENT);
        stack.method_22909();
    }

    public EventResult mouseEvent(class_310 client, double amount) {
        if (this.pressed && amount != 0.0 && this.sneak()) {
            this.hasScrolled = true;
            new ModeChangedPacket(amount < 0.0).sendToServer();
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public EventResult onKeyPress(class_310 client, int keyCode, int scanCode, int action, int modifiers) {
        if (System.currentTimeMillis() - this.lastToggle < 125L) {
            return EventResult.pass();
        }
        if (keyCode != 265 && keyCode != 264) {
            return EventResult.pass();
        }
        if (!this.pressed || !this.sneak()) {
            return EventResult.pass();
        }
        this.hasScrolled = true;
        new ModeChangedPacket(keyCode == 264).sendToServer();
        this.lastToggle = System.currentTimeMillis();
        return EventResult.pass();
    }

    private boolean sneak() {
        return FTBUltimineClient.keyBinding.field_1655.method_1444() == 340 || FTBUltimineClient.keyBinding.field_1655.method_1444() == 344 ? class_437.method_25441() : class_437.method_25442();
    }

    private void addPressedInfo(List<class_5250> list) {
        list.add((class_5250)new class_2588("ftbultimine.info.base", new Object[]{this.canUltimine ? new class_2588("ftbultimine.info.active").method_27694(style -> style.method_27703(class_5251.method_27717((int)10731148))) : new class_2588("ftbultimine.info.not_active").method_27694(style -> style.method_27703(class_5251.method_27717((int)12542314)))}));
        if (!this.hasScrolled) {
            list.add(new class_2588("ftbultimine.change_shape").method_27692(class_124.field_1080));
        }
        if (SendShapePacket.current != null) {
            if (this.sneak()) {
                list.add((class_5250)new class_2585(""));
                list.add(new class_2585("^ ").method_27692(class_124.field_1080).method_10852((class_2561)new class_2588("ftbultimine.shape." + SendShapePacket.current.prev.getName())));
            }
            class_5250 mining = new class_2585("- ").method_10852((class_2561)new class_2588("ftbultimine.shape." + SendShapePacket.current.getName()));
            if (this.canUltimine && this.actualBlocks != 0) {
                mining.method_27693(" (").method_10852((class_2561)new class_2588("ftbultimine.info.blocks", new Object[]{this.actualBlocks}));
                if (this.actualBlocks > this.shapeBlocks.size()) {
                    mining.method_27693(", ").method_10852((class_2561)new class_2588("ftbultimine.info.partial_render", new Object[]{this.shapeBlocks.size()}));
                }
                mining.method_27693(")");
            }
            list.add(mining);
            if (this.sneak()) {
                list.add(new class_2585("v ").method_27692(class_124.field_1080).method_10852((class_2561)new class_2588("ftbultimine.shape." + SendShapePacket.current.next.getName())));
            }
        }
    }

    public void renderGameOverlay(class_4587 matrices, float tickDelta) {
        if (this.pressed) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
            ArrayList<class_5250> list = new ArrayList<class_5250>();
            this.addPressedInfo(list);
            class_310 minecraft = class_310.method_1551();
            Objects.requireNonNull(minecraft.field_1772);
            int top = 2 + 9 * 0;
            for (class_5250 msg : list) {
                class_5481 formatted = msg.method_30937();
                int n = 2 + minecraft.field_1772.method_30880(formatted) + 1;
                Objects.requireNonNull(minecraft.field_1772);
                class_332.method_25294((class_4587)matrices, (int)1, (int)(top - 1), (int)n, (int)(top + 9 - 1), (int)-1439812544);
                minecraft.field_1772.method_27517(matrices, formatted, 2.0f, (float)top, 15527924);
                Objects.requireNonNull(minecraft.field_1772);
                top += 9;
            }
        }
    }

    public void clientTick(class_310 mc) {
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        boolean p = this.pressed;
        this.pressed = keyBinding.method_1434();
        if (this.pressed != p) {
            new KeyPressedPacket(this.pressed).sendToServer();
        }
        this.canUltimine = this.pressed && FTBUltimine.instance.canUltimine((class_1657)mc.field_1724);
    }

    private void updateEdges() {
        if (this.cachedEdges != null) {
            return;
        }
        if (this.shapeBlocks.isEmpty()) {
            this.cachedEdges = Collections.emptyList();
            return;
        }
        this.cachedPos = this.shapeBlocks.get(0);
        double d = 0.005;
        this.cachedEdges = new ArrayList<CachedEdge>();
        HashSet<class_265> shapes = new HashSet<class_265>();
        for (class_238 aabb : ShapeMerger.merge(this.shapeBlocks, this.cachedPos)) {
            shapes.add(class_259.method_1078((class_238)aabb.method_1014(d)));
        }
        FTBUltimineClient.orShapes(shapes).method_1104((x1, y1, z1, x2, y2, z2) -> {
            CachedEdge edge = new CachedEdge();
            edge.x1 = (float)x1;
            edge.y1 = (float)y1;
            edge.z1 = (float)z1;
            edge.x2 = (float)x2;
            edge.y2 = (float)y2;
            edge.z2 = (float)z2;
            this.cachedEdges.add(edge);
        });
    }

    static class_265 orShapes(Collection<class_265> shapes) {
        class_265 combinedShape = class_259.method_1073();
        for (class_265 shape : shapes) {
            combinedShape = class_259.method_1082((class_265)combinedShape, (class_265)shape, (class_247)class_247.field_1366);
        }
        return combinedShape;
    }
}

