/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.architectury.hooks.tags.TagHooks;
import dev.architectury.utils.EnvExecutor;
import dev.architectury.utils.value.IntValue;
import dev.ftb.mods.ftbultimine.BrokenItemHandler;
import dev.ftb.mods.ftbultimine.FTBUltimineCommon;
import dev.ftb.mods.ftbultimine.FTBUltiminePlayerData;
import dev.ftb.mods.ftbultimine.ItemCollection;
import dev.ftb.mods.ftbultimine.client.FTBUltimineClient;
import dev.ftb.mods.ftbultimine.config.FTBUltimineCommonConfig;
import dev.ftb.mods.ftbultimine.config.FTBUltimineServerConfig;
import dev.ftb.mods.ftbultimine.integration.FTBUltiminePlugins;
import dev.ftb.mods.ftbultimine.net.FTBUltimineNet;
import dev.ftb.mods.ftbultimine.net.SendShapePacket;
import dev.ftb.mods.ftbultimine.shape.BlockMatcher;
import dev.ftb.mods.ftbultimine.shape.EscapeTunnelShape;
import dev.ftb.mods.ftbultimine.shape.MiningTunnelShape;
import dev.ftb.mods.ftbultimine.shape.Shape;
import dev.ftb.mods.ftbultimine.shape.ShapeContext;
import dev.ftb.mods.ftbultimine.shape.ShapelessShape;
import dev.ftb.mods.ftbultimine.shape.SmallSquareShape;
import dev.ftb.mods.ftbultimine.shape.SmallTunnelShape;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1831;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_3965;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FTBUltimine {
    public static FTBUltimine instance;
    public static final String MOD_ID = "ftbultimine";
    public static final Logger LOGGER;
    public final FTBUltimineCommon proxy;
    private Map<UUID, FTBUltiminePlayerData> cachedDataMap;
    private boolean isBreakingBlock;
    private int tempBlockDroppedXp;
    private ItemCollection tempBlockDropsList;
    public static final class_3494.class_5123<class_1792> DENY_TAG;
    public static final class_3494.class_5123<class_1792> STRICT_DENY_TAG;
    public static final class_3494.class_5123<class_1792> ALLOW_TAG;
    public static final class_3494.class_5123<class_2248> EXCLUDED_BLOCKS;
    private static Predicate<class_1657> permissionOverride;

    public static void setPermissionOverride(Predicate<class_1657> p) {
        permissionOverride = p;
    }

    public FTBUltimine() {
        instance = this;
        FTBUltimineNet.init();
        this.proxy = (FTBUltimineCommon)EnvExecutor.getEnvSpecific(() -> FTBUltimineClient::new, () -> FTBUltimineCommon::new);
        FTBUltimineCommonConfig.load();
        FTBUltiminePlugins.init();
        Shape.register(new ShapelessShape());
        Shape.register(new SmallTunnelShape());
        Shape.register(new SmallSquareShape());
        Shape.register(new MiningTunnelShape());
        Shape.register(new EscapeTunnelShape());
        Shape.postinit();
        LifecycleEvent.SERVER_BEFORE_START.register(this::serverStarting);
        BlockEvent.BREAK.register(this::blockBroken);
        InteractionEvent.RIGHT_CLICK_BLOCK.register(this::blockRightClick);
        TickEvent.PLAYER_PRE.register(this::playerTick);
        EntityEvent.ADD.register(this::entityJoinedWorld);
    }

    public FTBUltiminePlayerData get(class_1657 player) {
        return this.cachedDataMap.computeIfAbsent(player.method_5667(), FTBUltiminePlayerData::new);
    }

    private void serverStarting(MinecraftServer server) {
        this.cachedDataMap = new HashMap<UUID, FTBUltiminePlayerData>();
        FTBUltimineServerConfig.load(server);
    }

    public void setKeyPressed(class_3222 player, boolean pressed) {
        FTBUltiminePlayerData data = this.get((class_1657)player);
        data.pressed = pressed;
        data.clearCache();
        if (!data.pressed) {
            new SendShapePacket(data.shape, Collections.emptyList()).sendTo(player);
        }
    }

    public void modeChanged(class_3222 player, boolean next) {
        FTBUltiminePlayerData data = this.get((class_1657)player);
        data.shape = next ? data.shape.next : data.shape.prev;
        data.clearCache();
        new SendShapePacket(data.shape, Collections.emptyList()).sendTo(player);
    }

    private int getMaxBlocks(class_1657 player) {
        return (Integer)FTBUltimineServerConfig.MAX_BLOCKS.get();
    }

    public static boolean isValidTool(class_1792 mainHand, class_1792 offHand) {
        if (STRICT_DENY_TAG.method_15141((Object)mainHand) || STRICT_DENY_TAG.method_15141((Object)offHand)) {
            return false;
        }
        if (DENY_TAG.method_15141((Object)mainHand)) {
            return false;
        }
        List allowedTools = ALLOW_TAG.method_15138();
        if (((Boolean)FTBUltimineCommonConfig.REQUIRE_TOOL.get()).booleanValue()) {
            if (mainHand == class_1802.field_8162) {
                return false;
            }
            return mainHand instanceof class_1831 || mainHand.method_7841() > 0 || allowedTools.contains(mainHand);
        }
        return allowedTools.isEmpty() || allowedTools.contains(mainHand);
    }

    public boolean canUltimine(class_1657 player) {
        class_1792 offHand;
        if (PlayerHooks.isFake((class_1657)player) || player.method_5667() == null) {
            return false;
        }
        if (player.method_7344().method_7586() <= 0 && !player.method_7337()) {
            return false;
        }
        if (!permissionOverride.test(player)) {
            return false;
        }
        class_1792 mainHand = player.method_6047().method_7909();
        return FTBUltimine.isValidTool(mainHand, offHand = player.method_6079().method_7909()) && FTBUltiminePlugins.canUltimine(player);
    }

    public EventResult blockBroken(class_1937 world, class_2338 pos, class_2680 state, class_3222 player, @Nullable IntValue xp) {
        if (this.isBreakingBlock || !this.canUltimine((class_1657)player)) {
            return EventResult.pass();
        }
        FTBUltiminePlayerData data = this.get((class_1657)player);
        if (!data.pressed) {
            return EventResult.pass();
        }
        class_239 result = FTBUltiminePlayerData.rayTrace(player);
        if (!(result instanceof class_3965) || result.method_17783() != class_239.class_240.field_1332) {
            return EventResult.pass();
        }
        data.clearCache();
        data.updateBlocks(player, pos, ((class_3965)result).method_17780(), false, this.getMaxBlocks((class_1657)player));
        if (data.cachedBlocks == null || data.cachedBlocks.isEmpty()) {
            return EventResult.pass();
        }
        this.isBreakingBlock = true;
        this.tempBlockDropsList = new ItemCollection();
        this.tempBlockDroppedXp = 0;
        boolean hadItem = !player.method_6047().method_7960();
        for (class_2338 p : data.cachedBlocks) {
            if (!player.field_13974.method_14266(p) && ((Boolean)FTBUltimineCommonConfig.CANCEL_ON_BLOCK_BREAK_FAIL.get()).booleanValue()) break;
            if (!player.method_7337()) {
                player.method_7322((float)((Double)FTBUltimineServerConfig.EXHAUSTION_PER_BLOCK.get() * 0.005));
                if (player.method_7344().method_7586() <= 0) break;
            }
            class_1799 stack = player.method_6047();
            if (!(hadItem && stack.method_7960() || hadItem && stack.method_7985() && stack.method_7969().method_10577("tic_broken")) && (!hadItem || (Integer)FTBUltimineCommonConfig.PREVENT_TOOL_BREAK.get() <= 0 || !stack.method_7963() || stack.method_7919() < stack.method_7936() - (Integer)FTBUltimineCommonConfig.PREVENT_TOOL_BREAK.get())) continue;
            break;
        }
        this.isBreakingBlock = false;
        this.tempBlockDropsList.drop(player.field_6002, pos);
        if (this.tempBlockDroppedXp > 0) {
            player.field_6002.method_8649((class_1297)new class_1303(player.field_6002, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, this.tempBlockDroppedXp));
        }
        data.clearCache();
        new SendShapePacket(data.shape, Collections.emptyList()).sendTo(player);
        return EventResult.interruptFalse();
    }

    public EventResult blockRightClick(class_1657 player, class_1268 hand, class_2338 clickPos, class_2350 face) {
        if (!(player instanceof class_3222) || PlayerHooks.isFake((class_1657)player) || player.method_5667() == null) {
            return EventResult.pass();
        }
        class_3222 serverPlayer = (class_3222)player;
        if (player.method_7344().method_7586() <= 0 && !player.method_7337()) {
            return EventResult.pass();
        }
        class_239 result = FTBUltiminePlayerData.rayTrace(serverPlayer);
        if (!(result instanceof class_3965) || result.method_17783() != class_239.class_240.field_1332) {
            return EventResult.pass();
        }
        FTBUltiminePlayerData data = this.get(player);
        data.clearCache();
        ShapeContext shapeContext = data.updateBlocks(serverPlayer, clickPos, ((class_3965)result).method_17780(), false, this.getMaxBlocks(player));
        if (shapeContext == null || !data.pressed || data.cachedBlocks == null || data.cachedBlocks.isEmpty()) {
            return EventResult.pass();
        }
        if (player.method_5998(hand).method_7909() instanceof class_1794) {
            class_2960 dirtTag = new class_2960(MOD_ID, "farmland_tillable");
            if (!player.field_6002.method_8608()) {
                boolean playSound = false;
                BrokenItemHandler brokenItemHandler = new BrokenItemHandler();
                for (int i = 0; i < Math.min(data.cachedBlocks.size(), (Integer)FTBUltimineServerConfig.MAX_BLOCKS.get()); ++i) {
                    class_2338 p = data.cachedBlocks.get(i);
                    class_2680 state = player.field_6002.method_8320(p);
                    if (!class_3481.method_15073().method_30213(dirtTag).method_15141((Object)state.method_26204())) continue;
                    player.field_6002.method_8652(p, class_2246.field_10362.method_9564(), 11);
                    playSound = true;
                    if (player.method_7337()) continue;
                    player.method_6047().method_7956(1, (class_1309)serverPlayer, (Consumer)brokenItemHandler);
                    player.method_7322((float)((Double)FTBUltimineServerConfig.EXHAUSTION_PER_BLOCK.get() * 0.005));
                    if (brokenItemHandler.isBroken || player.method_7344().method_7586() <= 0) break;
                }
                if (playSound) {
                    player.field_6002.method_8396(player, clickPos, class_3417.field_14846, class_3419.field_15245, 1.0f, 1.0f);
                }
            }
            player.method_6104(hand);
            return EventResult.interruptFalse();
        }
        if (shapeContext.matcher == BlockMatcher.BUSH) {
            ItemCollection itemCollection = new ItemCollection();
            for (class_2338 pos : data.cachedBlocks) {
                class_2302 c;
                class_2680 state = player.field_6002.method_8320(pos);
                if (!(state.method_26204() instanceof class_2302) || !(c = (class_2302)state.method_26204()).method_9825(state)) continue;
                if (player.field_6002.method_8608()) {
                    player.method_6104(hand);
                    continue;
                }
                List drops = class_2248.method_9609((class_2680)state, (class_3218)((class_3218)player.field_6002), (class_2338)pos, (class_2586)(state.method_31709() ? player.field_6002.method_8321(pos) : null), (class_1297)player, (class_1799)class_1799.field_8037);
                for (class_1799 stack : drops) {
                    if (class_2248.method_9503((class_1792)stack.method_7909()) == c) {
                        stack.method_7934(1);
                    }
                    itemCollection.add(stack);
                }
                player.field_6002.method_8652(pos, c.method_9828(0), 3);
            }
            itemCollection.drop(player.field_6002, face == null ? clickPos : clickPos.method_10093(face));
            player.method_6104(hand);
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public void playerTick(class_1657 player) {
        if (!player.field_6002.method_8608()) {
            FTBUltiminePlayerData data = this.get(player);
            data.checkBlocks((class_3222)player, true, this.getMaxBlocks(player));
        }
    }

    public EventResult entityJoinedWorld(class_1297 entity, class_1937 level) {
        if (this.isBreakingBlock && entity instanceof class_1542) {
            this.tempBlockDropsList.add(((class_1542)entity).method_6983());
            return EventResult.interruptFalse();
        }
        if (this.isBreakingBlock && entity instanceof class_1303) {
            this.tempBlockDroppedXp += ((class_1303)entity).method_5919();
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public static class_2960 id(String path) {
        return new class_2960(MOD_ID, path);
    }

    static {
        LOGGER = LogManager.getLogger();
        DENY_TAG = TagHooks.optionalItem((class_2960)new class_2960(MOD_ID, "excluded_tools"));
        STRICT_DENY_TAG = TagHooks.optionalItem((class_2960)new class_2960(MOD_ID, "excluded_tools/strict"));
        ALLOW_TAG = TagHooks.optionalItem((class_2960)new class_2960(MOD_ID, "included_tools"));
        EXCLUDED_BLOCKS = TagHooks.optionalBlock((class_2960)new class_2960(MOD_ID, "excluded_blocks"));
        permissionOverride = player -> true;
    }
}

