/*
 * Decompiled with CFR 0.152.
 */
package com.hugman.dawn.api.creator.bundle.block;

import com.hugman.dawn.api.creator.BlockCreator;
import com.hugman.dawn.api.creator.bundle.block.PlantBundle;
import com.hugman.dawn.api.creator.bundle.block.WoodBundle;
import com.hugman.dawn.api.object.block.SaplingBlock;
import com.hugman.dawn.api.util.DefaultBlockBuilders;
import java.util.function.Predicate;
import net.minecraft.class_2248;
import net.minecraft.class_2647;
import net.minecraft.class_2680;
import net.minecraft.class_3620;
import net.minecraft.class_4970;

public class OverworldWoodBundle
extends WoodBundle {
    private final PlantBundle saplingPack;
    private final BlockCreator leaves;

    protected OverworldWoodBundle(String name, class_2647 saplingGenerator, Predicate<class_2680> saplingSoilPredicate, class_3620 planksColor, class_3620 insideColor, class_3620 barkColor) {
        super(name, planksColor, insideColor, barkColor, false);
        this.saplingPack = this.put(new PlantBundle(DefaultBlockBuilders.SAPLING.copy(name + "_sapling").provider(s -> new SaplingBlock(saplingGenerator, saplingSoilPredicate, (class_4970.class_2251)s))));
        this.leaves = this.put(DefaultBlockBuilders.LEAVES.copy(name + "_leaves").build());
    }

    public class_2248 getSapling() {
        return this.saplingPack.getPlant();
    }

    public class_2248 getPottedSapling() {
        return this.saplingPack.getPottedPlant();
    }

    public class_2248 getLeaves() {
        return (class_2248)this.leaves.getValue();
    }

    public static class Builder {
        private final String prefix;
        private final class_2647 saplingGenerator;
        private final class_3620 planksColor;
        private final class_3620 insideColor;
        private final class_3620 barkColor;
        private Predicate<class_2680> saplingSoilPredicate;

        public Builder(String prefix, class_2647 saplingGenerator, class_3620 woodColor, class_3620 barkColor) {
            this(prefix, saplingGenerator, woodColor, woodColor, barkColor);
        }

        public Builder(String prefix, class_2647 saplingGenerator, class_3620 planksColor, class_3620 insideColor, class_3620 barkColor) {
            this.prefix = prefix;
            this.saplingGenerator = saplingGenerator;
            this.planksColor = planksColor;
            this.insideColor = insideColor;
            this.barkColor = barkColor;
        }

        public Builder saplingSoil(Predicate<class_2680> predicate) {
            this.saplingSoilPredicate = predicate;
            return this;
        }

        public OverworldWoodBundle build() {
            return new OverworldWoodBundle(this.prefix, this.saplingGenerator, this.saplingSoilPredicate, this.planksColor, this.insideColor, this.barkColor);
        }
    }
}

