/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world;

import com.yungnickyoung.minecraft.yungsapi.YungsApi;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_2246;
import net.minecraft.class_2680;

public class BlockSetSelector {
    private Map<class_2680, Float> entries = new HashMap<class_2680, Float>();
    private class_2680 defaultBlockState = class_2246.field_10124.method_9564();

    public BlockSetSelector(class_2680 defaultBlockState) {
        this.defaultBlockState = defaultBlockState;
    }

    public BlockSetSelector() {
    }

    public static BlockSetSelector from(class_2680 ... blockStates) {
        BlockSetSelector selector = new BlockSetSelector();
        float chance = 1.0f / (float)blockStates.length;
        for (class_2680 state : blockStates) {
            selector.addBlock(state, chance);
        }
        return selector;
    }

    public BlockSetSelector addBlock(class_2680 blockState, float chance) {
        for (Map.Entry<class_2680, Float> entry : this.entries.entrySet()) {
            if (entry.getKey() != blockState) continue;
            YungsApi.LOGGER.warn(String.format("WARNING: duplicate block %s added to BlockSelector!", blockState.toString()));
            return this;
        }
        float currTotal = this.entries.values().stream().reduce(Float::sum).orElse(Float.valueOf(0.0f)).floatValue();
        float newTotal = currTotal + chance;
        if (newTotal > 1.0f) {
            YungsApi.LOGGER.warn(String.format("WARNING: block %s added to BlockSelector exceeds max probabiltiy of 1!", blockState.toString()));
            return this;
        }
        this.entries.put(blockState, Float.valueOf(chance));
        return this;
    }

    public class_2680 get(Random random) {
        float target = random.nextFloat();
        float currBottom = 0.0f;
        for (Map.Entry<class_2680, Float> entry : this.entries.entrySet()) {
            float chance = entry.getValue().floatValue();
            if (currBottom <= target && target < currBottom + chance) {
                return entry.getKey();
            }
            currBottom += chance;
        }
        return this.defaultBlockState;
    }

    public void setDefaultBlockState(class_2680 blockState) {
        this.defaultBlockState = blockState;
    }

    public Map<class_2680, Float> getEntries() {
        return this.entries;
    }

    public class_2680 getDefaultBlockState() {
        return this.defaultBlockState;
    }
}

