/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.campanion.entity;

import com.terraformersmc.campanion.entity.AdditionalSpawnDataEntity;
import com.terraformersmc.campanion.entity.CampanionEntities;
import com.terraformersmc.campanion.entity.GrapplingHookUser;
import com.terraformersmc.campanion.item.CampanionItems;
import com.terraformersmc.campanion.network.S2CEntitySpawnPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_265;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;

public class GrapplingHookEntity
extends class_1297
implements AdditionalSpawnDataEntity {
    private static final class_2940<Boolean> IS_IN_BLOCK = class_2945.method_12791(GrapplingHookEntity.class, (class_2941)class_2943.field_13323);
    private class_1657 player;
    private int grappleTicks = -1;
    private class_243 previousPlayerPos;

    public GrapplingHookEntity(class_1937 world) {
        super(CampanionEntities.GRAPPLING_HOOK, world);
    }

    public GrapplingHookEntity(class_1657 player, class_1937 world) {
        this(world);
        this.player = player;
        float playerPitch = this.player.method_36455();
        float playerYaw = this.player.method_36454();
        float velX = -class_3532.method_15374((float)(playerYaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(playerPitch * ((float)Math.PI / 180)));
        float velY = -class_3532.method_15374((float)(playerPitch * ((float)Math.PI / 180)));
        float velZ = class_3532.method_15362((float)(playerYaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(playerPitch * ((float)Math.PI / 180)));
        this.method_18799(new class_243((double)velX, (double)velY, (double)velZ).method_1021(1.5));
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
        this.method_5808(this.player.method_23317(), this.player.method_23320() - 0.1, this.player.method_23321(), this.method_36454(), this.method_36455());
    }

    protected void method_5693() {
        this.field_6011.method_12784(IS_IN_BLOCK, (Object)false);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_5640(double distance) {
        return distance < 16384.0;
    }

    public void method_5773() {
        super.method_5773();
        class_243 vec3d = this.method_18798();
        if (!((Boolean)this.field_6011.method_12789(IS_IN_BLOCK)).booleanValue() && this.field_6004 == 0.0f && this.field_5982 == 0.0f) {
            float f = class_3532.method_15355((float)((float)vec3d.method_37268()));
            this.method_36456((float)(class_3532.method_15349((double)vec3d.field_1352, (double)vec3d.field_1350) * 57.2957763671875));
            this.method_36457((float)(class_3532.method_15349((double)vec3d.field_1351, (double)f) * 57.2957763671875));
            this.field_5982 = this.method_36454();
            this.field_6004 = this.method_36455();
        }
        if (this.player == null) {
            this.method_5650(class_1297.class_5529.field_26999);
        } else if (this.field_6002.field_9236 || this.removeIfInvalid()) {
            if (!this.field_6002.field_9236) {
                this.checkForCollision();
            }
            if (!((Boolean)this.field_6011.method_12789(IS_IN_BLOCK)).booleanValue()) {
                this.method_5784(class_1313.field_6308, this.method_18798());
                this.method_18799(this.method_18798().method_1031(0.0, -0.02, 0.0));
                this.method_23311();
            } else {
                this.method_18799(class_243.field_1353);
                ++this.grappleTicks;
                this.ensureEntityVelocity();
            }
        }
        if (!((Boolean)this.field_6011.method_12789(IS_IN_BLOCK)).booleanValue()) {
            this.smoothMovement();
        }
    }

    private void smoothMovement() {
        class_243 vec3d = this.method_18798();
        double d = vec3d.field_1352;
        double e = vec3d.field_1351;
        double g = vec3d.field_1350;
        float l = class_3532.method_15355((float)((float)vec3d.method_37268()));
        this.method_36456((float)(class_3532.method_15349((double)d, (double)g) * 57.2957763671875));
        this.method_36457((float)(class_3532.method_15349((double)e, (double)l) * 57.2957763671875));
        while (this.method_36455() - this.field_6004 < -180.0f) {
            this.field_6004 -= 360.0f;
        }
        while (this.method_36455() - this.field_6004 >= 180.0f) {
            this.field_6004 += 360.0f;
        }
        while (this.method_36454() - this.field_5982 < -180.0f) {
            this.field_5982 -= 360.0f;
        }
        while (this.method_36454() - this.field_5982 >= 180.0f) {
            this.field_5982 += 360.0f;
        }
        this.method_36457(class_3532.method_16439((float)0.2f, (float)this.field_6004, (float)this.method_36455()));
        this.method_36456(class_3532.method_16439((float)0.2f, (float)this.field_5982, (float)this.method_36454()));
    }

    private boolean removeIfInvalid() {
        class_1799 mainHandStack = this.player.method_6047();
        class_1799 offHandStack = this.player.method_6079();
        boolean inMainHand = mainHandStack.method_7909() == CampanionItems.GRAPPLING_HOOK;
        boolean inOffHand = offHandStack.method_7909() == CampanionItems.GRAPPLING_HOOK;
        boolean isHookedEntity = ((GrapplingHookUser)this.player).getGrapplingHook() == this;
        double dist = this.method_5858((class_1297)this.player);
        if (this.player.method_31481() || !this.player.method_5805() || !isHookedEntity || !inMainHand && !inOffHand || dist > 16384.0 || ((Boolean)this.field_6011.method_12789(IS_IN_BLOCK)).booleanValue() && dist < 2.0) {
            this.method_5650(class_1297.class_5529.field_26999);
            return false;
        }
        return true;
    }

    private void checkForCollision() {
        class_239 hitResult = class_1675.method_18074((class_1297)this, entity -> false);
        if (hitResult.method_17783() == class_239.class_240.field_1332 && this.grappleTicks == -1) {
            this.previousPlayerPos = this.player.method_19538();
            this.field_6011.method_12778(IS_IN_BLOCK, (Object)true);
            this.grappleTicks = 0;
        }
    }

    public class_1657 getPlayer() {
        return this.player;
    }

    public void method_5650(class_1297.class_5529 reason) {
        if (this.player != null) {
            ((GrapplingHookUser)this.player).setGrapplingHook(null);
        }
        super.method_5650(class_1297.class_5529.field_26999);
    }

    public void method_5652(class_2487 tag) {
    }

    public void method_5749(class_2487 tag) {
    }

    protected void ensureEntityVelocity() {
        if (this.player != null) {
            double dx = this.method_23317() - this.player.method_23317();
            double dy = this.method_23318() - this.player.method_23318() + 1.0;
            double dz = this.method_23321() - this.player.method_23321();
            double xzDist = class_3532.method_15355((float)((float)(dx * dx + dz * dz)));
            double theta = Math.atan2(dy, xzDist);
            double xzTheta = Math.atan2(dz, dx);
            double xzAmount = Math.cos(theta);
            class_243 movement = new class_243(xzAmount * Math.cos(xzTheta), Math.sin(theta), xzAmount * Math.sin(xzTheta));
            boolean xCollide = false;
            boolean zCollide = false;
            class_238 box = this.player.method_5829().method_1012(movement.method_1029().field_1352, 0.0, movement.method_1029().field_1350);
            for (class_265 shape : this.field_6002.method_20812((class_1297)this.player, box)) {
                xCollide |= box.method_1008(shape.method_1105(class_2350.class_2351.field_11048), box.field_1322, box.field_1321) || box.method_1008(shape.method_1105(class_2350.class_2351.field_11048), box.field_1322, box.field_1321);
                zCollide |= box.method_1008(box.field_1323, box.field_1322, shape.method_1091(class_2350.class_2351.field_11051)) || box.method_1008(box.field_1323, box.field_1322, shape.method_1105(class_2350.class_2351.field_11051));
            }
            if (xCollide && zCollide) {
                movement = new class_243(0.0, movement.field_1351, 0.0);
            } else if (xCollide) {
                movement = new class_243(0.0, movement.field_1351, xzAmount * Math.signum(movement.field_1350));
            } else if (zCollide) {
                movement = new class_243(xzAmount * Math.signum(movement.field_1352), movement.field_1351, 0.0);
            }
            movement = movement.method_1029();
            class_243 playerVelocity = this.player.method_18798();
            class_243 velocity = movement.method_1020(movement.method_1020(playerVelocity).method_1021(0.5));
            this.player.method_18799(velocity);
            this.player.field_6037 = true;
        }
    }

    protected boolean canClimb() {
        return false;
    }

    public boolean method_5822() {
        return false;
    }

    public class_2596<?> method_18002() {
        return S2CEntitySpawnPacket.createPacket(this);
    }

    @Override
    public void writeToBuffer(class_2540 buffer) {
        if (this.player != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(this.player.method_5628());
        } else {
            buffer.writeBoolean(false);
        }
    }

    @Override
    public void readFromBuffer(class_2540 buffer) {
        int i;
        class_1297 entity;
        if (buffer.readBoolean() && (entity = this.field_6002.method_8469(i = buffer.readInt())) instanceof class_1657) {
            this.player = (class_1657)entity;
            ((GrapplingHookUser)this.player).setGrapplingHook(this);
        }
    }
}

