/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.campanion.config;

import com.terraformersmc.campanion.Campanion;
import com.terraformersmc.campanion.config.CampanionConfig;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.TrinketsApi;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_3494;

public class CampanionConfigManager {
    private static File file;
    private static CampanionConfig config;

    private static void prepareBiomeConfigFile() {
        if (file != null) {
            return;
        }
        file = new File(FabricLoader.getInstance().getConfigDirectory(), "campanion.json");
    }

    public static CampanionConfig initializeConfig() {
        if (config != null) {
            return config;
        }
        config = new CampanionConfig();
        CampanionConfigManager.load();
        return config;
    }

    private static void load() {
        CampanionConfigManager.prepareBiomeConfigFile();
        try {
            if (!file.exists()) {
                CampanionConfigManager.save();
            }
            if (file.exists()) {
                BufferedReader br = new BufferedReader(new FileReader(file));
                config = (CampanionConfig)Campanion.GSON.fromJson((Reader)br, CampanionConfig.class);
            }
            if (FabricLoader.getInstance().isModLoaded("trinkets")) {
                TrinketsApi.registerTrinketPredicate((class_2960)new class_2960("campanion", "backpacks"), (stack, ref, entity) -> {
                    SlotType slot = ref.inventory().getSlotType();
                    class_3494 tag = class_3489.method_15106().method_30213(new class_2960("campanion", "backpacks"));
                    if (tag.method_15141((Object)stack.method_7909())) {
                        return config.isTrinketsBackpacksEnabled() ? TriState.TRUE : TriState.FALSE;
                    }
                    return TriState.DEFAULT;
                });
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Couldn't load Campanion configuration file; reverting to defaults");
            e.printStackTrace();
        }
    }

    public static void save() {
        CampanionConfigManager.prepareBiomeConfigFile();
        String jsonString = Campanion.GSON.toJson((Object)config);
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write(jsonString);
        }
        catch (IOException e) {
            System.err.println("Couldn't save Campanion configuration file");
            e.printStackTrace();
        }
    }

    public static CampanionConfig getConfig() {
        return config;
    }
}

