/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.mannequins.common.entity;

import com.google.common.collect.ImmutableList;
import gg.moonflower.mannequins.client.screen.AbstractMannequinScreen;
import gg.moonflower.mannequins.common.menu.MannequinInventoryMenu;
import gg.moonflower.mannequins.common.network.MannequinsMessages;
import gg.moonflower.mannequins.common.network.play.ClientboundAttackMannequin;
import gg.moonflower.mannequins.common.network.play.ClientboundOpenMannequinScreen;
import gg.moonflower.mannequins.core.mixin.ServerPlayerAccessor;
import gg.moonflower.pollen.api.event.events.entity.player.ContainerEvents;
import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1688;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2379;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMannequin
extends class_1309 {
    public static final class_2940<class_2379> DATA_HEAD_POSE = class_2945.method_12791(AbstractMannequin.class, (class_2941)class_2943.field_13316);
    public static final class_2940<class_2379> DATA_BODY_POSE = class_2945.method_12791(AbstractMannequin.class, (class_2941)class_2943.field_13316);
    public static final class_2940<class_2379> DATA_LEFT_ARM_POSE = class_2945.method_12791(AbstractMannequin.class, (class_2941)class_2943.field_13316);
    public static final class_2940<class_2379> DATA_RIGHT_ARM_POSE = class_2945.method_12791(AbstractMannequin.class, (class_2941)class_2943.field_13316);
    public static final class_2940<Boolean> DATA_DISABLED = class_2945.method_12791(AbstractMannequin.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> DATA_TROLLED = class_2945.method_12791(AbstractMannequin.class, (class_2941)class_2943.field_13323);
    public static final class_2940<OptionalInt> DATA_EXPRESSION = class_2945.method_12791(AbstractMannequin.class, (class_2941)class_2943.field_17910);
    private static final Predicate<class_1297> MINECART = entity -> entity instanceof class_1688 && ((class_1688)entity).method_7518() == class_1688.class_1689.field_7674;
    private static final class_2379 DEFAULT_HEAD_POSE = new class_2379(0.0f, 0.0f, 0.0f);
    private static final class_2379 DEFAULT_BODY_POSE = new class_2379(0.0f, 0.0f, 0.0f);
    private static final class_2379 DEFAULT_LEFT_ARM_POSE = new class_2379(-10.0f, 0.0f, -10.0f);
    private static final class_2379 DEFAULT_RIGHT_ARM_POSE = new class_2379(-10.0f, 0.0f, 10.0f);
    private final class_1277 inventory = new class_1277(4);
    private class_2379 headPose = DEFAULT_HEAD_POSE;
    private class_2379 bodyPose = DEFAULT_BODY_POSE;
    private class_2379 leftArmPose = DEFAULT_LEFT_ARM_POSE;
    private class_2379 rightArmPose = DEFAULT_RIGHT_ARM_POSE;
    public long lastHit;

    public AbstractMannequin(class_1299<? extends AbstractMannequin> type, class_1937 level) {
        super(type, level);
        this.field_6013 = 0.0f;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_HEAD_POSE, (Object)DEFAULT_HEAD_POSE);
        this.field_6011.method_12784(DATA_BODY_POSE, (Object)DEFAULT_BODY_POSE);
        this.field_6011.method_12784(DATA_LEFT_ARM_POSE, (Object)DEFAULT_LEFT_ARM_POSE);
        this.field_6011.method_12784(DATA_RIGHT_ARM_POSE, (Object)DEFAULT_RIGHT_ARM_POSE);
        this.field_6011.method_12784(DATA_EXPRESSION, (Object)OptionalInt.empty());
        this.field_6011.method_12784(DATA_DISABLED, (Object)false);
        this.field_6011.method_12784(DATA_TROLLED, (Object)false);
    }

    public Iterable<class_1799> method_5877() {
        return ImmutableList.of((Object)this.inventory.method_5438(2), (Object)this.inventory.method_5438(3));
    }

    public Iterable<class_1799> method_5661() {
        return ImmutableList.of((Object)this.inventory.method_5438(0), (Object)this.inventory.method_5438(1));
    }

    public class_1799 method_6118(class_1304 slot) {
        if (slot == null) {
            return class_1799.field_8037;
        }
        switch (slot) {
            case field_6169: {
                return this.inventory.method_5438(0);
            }
            case field_6174: {
                return this.inventory.method_5438(1);
            }
            case field_6173: {
                return this.inventory.method_5438(2);
            }
            case field_6171: {
                return this.inventory.method_5438(3);
            }
        }
        return class_1799.field_8037;
    }

    public void method_5673(class_1304 slot, class_1799 stack) {
        if (slot == null) {
            return;
        }
        switch (slot) {
            case field_6169: {
                this.inventory.method_5447(0, stack);
                break;
            }
            case field_6174: {
                this.inventory.method_5447(1, stack);
                break;
            }
            case field_6173: {
                this.inventory.method_5447(2, stack);
                break;
            }
            case field_6171: {
                this.inventory.method_5447(3, stack);
            }
        }
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10566("Pose", (class_2520)this.writePose());
        this.getExpression().ifPresent(expression -> tag.method_10569("Expression", expression.ordinal()));
        tag.method_10556("Trolled", this.isTrolled());
        tag.method_10556("Disabled", this.isDisabled());
        class_2499 listTag = new class_2499();
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            class_1799 itemStack = this.inventory.method_5438(i);
            if (itemStack.method_7960()) continue;
            class_2487 compoundTag2 = new class_2487();
            compoundTag2.method_10567("Slot", (byte)i);
            itemStack.method_7953(compoundTag2);
            listTag.add((Object)compoundTag2);
        }
        tag.method_10566("Items", (class_2520)listTag);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.readPose(tag.method_10562("Pose"));
        if (tag.method_10573("Expression", 3)) {
            this.setExpression(Expression.byId(tag.method_10550("Expression")));
        }
        this.setTrolled(tag.method_10577("Trolled"));
        this.field_6011.method_12778(DATA_DISABLED, (Object)tag.method_10577("Disabled"));
        if (tag.method_10573("Items", 9)) {
            class_2499 listTag = tag.method_10554("Items", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                class_2487 compoundTag2 = listTag.method_10602(i);
                int j = compoundTag2.method_10571("Slot") & 0xFF;
                if (j >= this.inventory.method_5439()) continue;
                this.inventory.method_5447(j, class_1799.method_7915((class_2487)compoundTag2));
            }
        }
    }

    private void readPose(class_2487 tag) {
        class_2499 headPose = tag.method_10554("Head", 5);
        this.setHeadPose(headPose.isEmpty() ? DEFAULT_HEAD_POSE : new class_2379(headPose));
        class_2499 bodyPose = tag.method_10554("Body", 5);
        this.setBodyPose(bodyPose.isEmpty() ? DEFAULT_BODY_POSE : new class_2379(bodyPose));
        class_2499 leftArmPose = tag.method_10554("LeftArm", 5);
        this.setLeftArmPose(leftArmPose.isEmpty() ? DEFAULT_LEFT_ARM_POSE : new class_2379(leftArmPose));
        class_2499 rightArmPose = tag.method_10554("RightArm", 5);
        this.setRightArmPose(rightArmPose.isEmpty() ? DEFAULT_RIGHT_ARM_POSE : new class_2379(rightArmPose));
    }

    private class_2487 writePose() {
        class_2487 pose = new class_2487();
        if (!DEFAULT_HEAD_POSE.equals((Object)this.headPose)) {
            pose.method_10566("Head", (class_2520)this.headPose.method_10255());
        }
        if (!DEFAULT_BODY_POSE.equals((Object)this.bodyPose)) {
            pose.method_10566("Body", (class_2520)this.bodyPose.method_10255());
        }
        if (!DEFAULT_LEFT_ARM_POSE.equals((Object)this.leftArmPose)) {
            pose.method_10566("LeftArm", (class_2520)this.leftArmPose.method_10255());
        }
        if (!DEFAULT_RIGHT_ARM_POSE.equals((Object)this.rightArmPose)) {
            pose.method_10566("RightArm", (class_2520)this.rightArmPose.method_10255());
        }
        return pose;
    }

    public boolean method_5810() {
        return false;
    }

    protected void method_6087(class_1297 entity) {
    }

    protected void method_6070() {
        List list = this.field_6002.method_8333((class_1297)this, this.method_5829(), MINECART);
        for (class_1297 entity : list) {
            if (!(this.method_5858(entity) <= 0.2)) continue;
            entity.method_5697((class_1297)this);
        }
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (this.isDisabled()) {
            return class_1269.field_5814;
        }
        if (!player.method_5998(hand).method_7960() && !player.method_21823()) {
            return class_1269.field_5811;
        }
        if (this.field_6002.method_8608()) {
            return class_1269.field_5812;
        }
        if (this.canChangeExpression(player, hand)) {
            if ("Trolled".equals(player.method_5998(hand).method_7964().getString())) {
                if (!this.isTrolled()) {
                    this.setExpression(null);
                    this.setTrolled(true);
                    this.field_6002.method_8465(null, this.method_23317(), this.method_23318(), this.method_23321(), this.getHitSound(), this.method_5634(), 1.0f, 1.0f);
                    return class_1269.field_21466;
                }
            } else {
                this.setTrolled(false);
                this.cycleExpression();
                this.field_6002.method_8465(null, this.method_23317(), this.method_23318(), this.method_23321(), this.getHitSound(), this.method_5634(), 1.0f, 1.0f);
                return class_1269.field_21466;
            }
        }
        class_3222 serverPlayer = (class_3222)player;
        if (serverPlayer.field_7512 != serverPlayer.field_7498) {
            serverPlayer.method_7346();
        }
        ServerPlayerAccessor access = (ServerPlayerAccessor)serverPlayer;
        access.callNextContainerCounter();
        MannequinsMessages.PLAY.sendTo(serverPlayer, (PollinatedPacket)new ClientboundOpenMannequinScreen(access.getContainerCounter(), this.method_5628()));
        serverPlayer.field_7512 = new MannequinInventoryMenu(access.getContainerCounter(), serverPlayer.method_31548(), (class_1263)this.inventory, this);
        access.callInitMenu(serverPlayer.field_7512);
        ((ContainerEvents.Open)ContainerEvents.OPEN.invoker()).open((class_1657)serverPlayer, serverPlayer.field_7512);
        return class_1269.field_21466;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.field_6002.method_8608() || !this.method_5805()) {
            return false;
        }
        if (class_1282.field_5849.equals(source)) {
            this.method_5650(class_1297.class_5529.field_26998);
            return false;
        }
        if (this.method_5679(source)) {
            return false;
        }
        boolean hurt = this.hurtBySource(source);
        if (hurt) {
            return true;
        }
        class_1297 entity = source.method_5529();
        if (!this.canBreak(source, entity)) {
            class_243 pos = source.method_5510();
            if (pos == null) {
                return false;
            }
            this.field_6271 = (float)(-class_3532.method_15349((double)(pos.method_10216() - this.method_23317()), (double)(pos.method_10215() - this.method_23321())));
            this.field_6002.method_8421((class_1297)this, (byte)32);
            MannequinsMessages.PLAY.sendToTracking((class_1297)this, (PollinatedPacket)new ClientboundAttackMannequin(this.method_5628(), this.field_6271));
            if (amount > 0.0f) {
                ((class_3218)this.field_6002).method_14199((class_2394)class_2398.field_11209, this.method_23317(), this.method_23320(), this.method_23321(), (int)((double)amount * 0.5), 0.1, 0.0, 0.1, 0.2);
            }
            return false;
        }
        if (source.method_5530()) {
            this.playBrokenSound();
            this.showBreakingParticles();
            this.method_5650(class_1297.class_5529.field_26998);
            return true;
        }
        long time = this.field_6002.method_8510();
        if (time - this.lastHit > 5L) {
            this.field_6002.method_8421((class_1297)this, (byte)32);
            this.lastHit = time;
        } else {
            class_2248.method_9577((class_1937)this.field_6002, (class_2338)this.method_24515(), (class_1799)this.getItem());
            this.breakMannequin(source);
            this.showBreakingParticles();
            this.method_5650(class_1297.class_5529.field_26998);
        }
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_5711(byte event) {
        if (event == 32) {
            if (this.field_6002.field_9236) {
                this.field_6002.method_8486(this.method_23317(), this.method_23318(), this.method_23321(), this.getHitSound(), this.method_5634(), 0.3f, 1.0f, false);
                this.lastHit = this.field_6002.method_8510();
            }
        } else {
            super.method_5711(event);
        }
    }

    protected float method_6031(float p_110146_1_, float p_110146_2_) {
        this.field_6220 = this.field_5982;
        this.field_6283 = this.method_36454();
        return 0.0f;
    }

    public double method_5678() {
        return 0.1f;
    }

    public void method_5636(float rot) {
        this.field_6220 = this.field_5982 = rot;
        this.field_6259 = this.field_6241 = rot;
    }

    public void method_5847(float rot) {
        this.field_6220 = this.field_5982 = rot;
        this.field_6259 = this.field_6241 = rot;
    }

    public void method_5773() {
        class_2379 rightArmPose;
        class_2379 leftArmPose;
        class_2379 bodyPose;
        super.method_5773();
        class_2379 headPose = (class_2379)this.field_6011.method_12789(DATA_HEAD_POSE);
        if (!this.headPose.equals((Object)headPose)) {
            this.setHeadPose(headPose);
        }
        if (!this.bodyPose.equals((Object)(bodyPose = (class_2379)this.field_6011.method_12789(DATA_BODY_POSE)))) {
            this.setBodyPose(bodyPose);
        }
        if (!this.leftArmPose.equals((Object)(leftArmPose = (class_2379)this.field_6011.method_12789(DATA_LEFT_ARM_POSE)))) {
            this.setLeftArmPose(leftArmPose);
        }
        if (!this.rightArmPose.equals((Object)(rightArmPose = (class_2379)this.field_6011.method_12789(DATA_RIGHT_ARM_POSE)))) {
            this.setRightArmPose(rightArmPose);
        }
    }

    public void method_5768() {
        this.method_5650(class_1297.class_5529.field_26998);
    }

    public boolean method_5698(class_1297 entity) {
        return entity instanceof class_1657 && !this.field_6002.method_8505((class_1657)entity, this.method_24515());
    }

    public class_1306 method_6068() {
        return class_1306.field_6183;
    }

    public void method_5800(class_3218 level, class_1538 lightning) {
    }

    public boolean method_6086() {
        return false;
    }

    public boolean method_6102() {
        return false;
    }

    public Optional<Expression> getExpression() {
        OptionalInt id = (OptionalInt)this.field_6011.method_12789(DATA_EXPRESSION);
        if (!id.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(Expression.byId(id.getAsInt()));
    }

    public void setExpression(@Nullable Expression expression) {
        this.field_6011.method_12778(DATA_EXPRESSION, (Object)(expression == null ? OptionalInt.empty() : OptionalInt.of(expression.ordinal())));
    }

    public boolean isTrolled() {
        return (Boolean)this.field_6011.method_12789(DATA_TROLLED);
    }

    public void setTrolled(boolean trolled) {
        this.field_6011.method_12778(DATA_TROLLED, (Object)trolled);
    }

    public boolean isDisabled() {
        return (Boolean)this.field_6011.method_12789(DATA_DISABLED);
    }

    public class_2379 getHeadPose() {
        return this.headPose;
    }

    public void setHeadPose(class_2379 pose) {
        this.headPose = pose;
        this.field_6011.method_12778(DATA_HEAD_POSE, (Object)pose);
    }

    public class_2379 getBodyPose() {
        return this.bodyPose;
    }

    public void setBodyPose(class_2379 pose) {
        this.bodyPose = pose;
        this.field_6011.method_12778(DATA_BODY_POSE, (Object)pose);
    }

    public class_2379 getLeftArmPose() {
        return this.leftArmPose;
    }

    public void setLeftArmPose(class_2379 pose) {
        this.leftArmPose = pose;
        this.field_6011.method_12778(DATA_LEFT_ARM_POSE, (Object)pose);
    }

    public class_2379 getRightArmPose() {
        return this.rightArmPose;
    }

    public void setRightArmPose(class_2379 pose) {
        this.rightArmPose = pose;
        this.field_6011.method_12778(DATA_RIGHT_ARM_POSE, (Object)pose);
    }

    public class_1799 getPickedResult(class_239 target) {
        return this.getItem();
    }

    private void showBreakingParticles() {
        if (this.field_6002 instanceof class_3218) {
            ((class_3218)this.field_6002).method_14199(this.getParticle(), this.method_23317(), this.method_23323(0.6666666666666666), this.method_23321(), 10, (double)(this.method_17681() / 4.0f), (double)(this.method_17682() / 4.0f), (double)(this.method_17681() / 4.0f), 0.05);
        }
    }

    private void causeDamage(class_1282 source, float damage) {
        float f = this.method_6032();
        if ((f -= damage) <= 0.5f) {
            this.breakMannequin(source);
            this.method_5650(class_1297.class_5529.field_26998);
        } else {
            this.method_6033(f);
        }
    }

    private void breakMannequin(class_1282 source) {
        this.playBrokenSound();
        this.method_16080(source);
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            class_1799 stack = this.inventory.method_5438(i);
            if (stack.method_7960()) continue;
            class_2248.method_9577((class_1937)this.field_6002, (class_2338)this.method_24515().method_10084(), (class_1799)stack);
            this.inventory.method_5447(i, class_1799.field_8037);
        }
    }

    private void playBrokenSound() {
        this.field_6002.method_8465(null, this.method_23317(), this.method_23318(), this.method_23321(), this.getBrokenSound(), this.method_5634(), 1.0f, 1.0f);
    }

    public boolean hurtBySource(class_1282 source) {
        if (source.method_5535()) {
            this.breakMannequin(source);
            this.method_5650(class_1297.class_5529.field_26998);
            return true;
        }
        if (class_1282.field_5867.equals(source)) {
            if (this.method_5809()) {
                this.causeDamage(source, 0.15f);
            } else {
                this.method_5639(5);
            }
            return true;
        }
        if (class_1282.field_5854.equals(source) && this.method_6032() > 0.5f) {
            this.causeDamage(source, 4.0f);
            return true;
        }
        return false;
    }

    public void cycleExpression() {
        Optional<Expression> expressionOptional = this.getExpression();
        if (!expressionOptional.isPresent()) {
            this.setExpression(Expression.byId(0));
            return;
        }
        Expression current = expressionOptional.get();
        if (current.ordinal() == Expression.values().length - 1) {
            this.setExpression(null);
            return;
        }
        this.setExpression(Expression.byId(current.ordinal() + 1));
    }

    public void onAttack(float attackYaw) {
    }

    public boolean canBreak(class_1282 source, class_1297 entity) {
        return entity != null && entity.method_5715() && source.method_5526() instanceof class_1657 && ((class_1657)source.method_5526()).method_31549().field_7476;
    }

    public abstract boolean canChangeExpression(class_1657 var1, class_1268 var2);

    public abstract class_1799 getItem();

    public abstract class_2394 getParticle();

    public abstract class_3414 getHitSound();

    public abstract class_3414 getBrokenSound();

    public abstract class_3414 getPlaceSound();

    @Environment(value=EnvType.CLIENT)
    public abstract AbstractMannequinScreen getScreen(MannequinInventoryMenu var1, class_1661 var2);

    public static enum Expression {
        NEUTRAL("neutral"),
        HAPPY("happy"),
        SURPRISED("surprised"),
        UPSET("upset");

        private final String name;

        private Expression(String name, boolean available) {
            this.name = name;
        }

        private Expression(String name) {
            this(name, true);
        }

        public String getName() {
            return this.name;
        }

        public static Expression byId(int id) {
            Expression[] expressions = Expression.values();
            if (id < 0 || id >= expressions.length) {
                id = 0;
            }
            return expressions[id];
        }
    }
}

