/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.mannequins.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import gg.moonflower.mannequins.client.screen.component.ScrollBar;
import gg.moonflower.mannequins.common.entity.AbstractMannequin;
import gg.moonflower.mannequins.common.menu.MannequinInventoryMenu;
import gg.moonflower.mannequins.common.network.MannequinsMessages;
import gg.moonflower.mannequins.common.network.play.ServerboundSetMannequinPose;
import gg.moonflower.pollen.api.client.util.ScissorHelper;
import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2379;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_490;

public abstract class AbstractMannequinScreen
extends class_465<MannequinInventoryMenu> {
    private static MannequinPart selectedPart = MannequinPart.HEAD;
    private final AbstractMannequin mannequin;
    private ScrollBar xScroll;
    private ScrollBar yScroll;
    private ScrollBar zScroll;

    public AbstractMannequinScreen(MannequinInventoryMenu menu, class_1661 inventory, AbstractMannequin mannequin) {
        super((class_1703)menu, inventory, mannequin.method_5476());
        this.mannequin = mannequin;
        this.field_22792 = false;
        this.field_2779 = 185;
        this.field_25270 += 20;
    }

    protected void method_25426() {
        super.method_25426();
        this.xScroll = new ScrollBar(this.field_2776 + 136, this.field_2800 + 20, 8, 65, 360, (class_2561)new class_2585("X"));
        this.method_37063((class_364)this.xScroll);
        this.yScroll = new ScrollBar(this.field_2776 + 147, this.field_2800 + 20, 8, 65, 360, (class_2561)new class_2585("Y"));
        this.method_37063((class_364)this.yScroll);
        this.zScroll = new ScrollBar(this.field_2776 + 158, this.field_2800 + 20, 8, 65, 360, (class_2561)new class_2585("Z"));
        this.method_37063((class_364)this.zScroll);
        this.xScroll.setScrollSpeed(1.0f);
        this.yScroll.setScrollSpeed(1.0f);
        this.zScroll.setScrollSpeed(1.0f);
        this.updateSliders();
    }

    private void updateSliders() {
        class_2379 rotations = selectedPart.getRotation(this.mannequin);
        float rotationX = class_3532.method_15393((float)rotations.method_10256()) + 180.0f;
        float rotationY = class_3532.method_15393((float)rotations.method_10257()) + 180.0f;
        float rotationZ = class_3532.method_15393((float)rotations.method_10258()) + 180.0f;
        if (selectedPart == MannequinPart.LEFT_ARM) {
            rotationZ = 360.0f - rotationZ;
        }
        this.xScroll.setScroll(rotationX % 360.0f / 360.0f * (float)this.xScroll.getMaxScroll());
        this.yScroll.setScroll(rotationY % 360.0f / 360.0f * (float)this.yScroll.getMaxScroll());
        this.zScroll.setScroll(rotationZ % 360.0f / 360.0f * (float)this.zScroll.getMaxScroll());
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (MannequinPart part : MannequinPart.values()) {
            if (selectedPart == part || !part.isHovered(mouseX - (double)this.field_2776, mouseY - (double)this.field_2800)) continue;
            selectedPart = part;
            this.updateSliders();
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
        return this.xScroll.method_25406(mouseX, mouseY, mouseButton) || this.yScroll.method_25406(mouseX, mouseY, mouseButton) || this.zScroll.method_25406(mouseX, mouseY, mouseButton) || super.method_25406(mouseX, mouseY, mouseButton);
    }

    protected void method_37432() {
        this.xScroll.tick();
        this.yScroll.tick();
        this.zScroll.tick();
    }

    protected void method_2389(class_4587 poseStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.getTexture());
        this.method_25302(poseStack, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
        for (MannequinPart part : MannequinPart.values()) {
            if (selectedPart == part) continue;
            this.method_25302(poseStack, this.field_2776 + part.xOffset, this.field_2800 + part.yOffset, part.isHovered(mouseX - this.field_2776, mouseY - this.field_2800) ? part.buttonU + part.buttonWidth : part.buttonU, part.buttonV, part.buttonWidth, part.buttonHeight);
        }
        ScissorHelper.push((float)(this.field_2776 + 26), (float)(this.field_2800 + 18), (float)49.0f, (float)70.0f);
        class_490.method_2486((int)(this.field_2776 + 51), (int)(this.field_2800 + 80), (int)28, (float)0.0f, (float)-30.0f, (class_1309)this.mannequin);
        ScissorHelper.pop();
    }

    public void method_25394(class_4587 arg, int mouseX, int mouseY, float partialTicks) {
        partialTicks = class_310.method_1551().method_1488();
        this.method_25420(arg);
        super.method_25394(arg, mouseX, mouseY, partialTicks);
        this.method_2380(arg, mouseX, mouseY);
        class_2379 rotations = selectedPart.getRotation(this.mannequin);
        float x = this.xScroll.getInterpolatedScrollPercentage(partialTicks) * 360.0f - 180.0f;
        float y = this.yScroll.getInterpolatedScrollPercentage(partialTicks) * 360.0f - 180.0f;
        float z = this.zScroll.getInterpolatedScrollPercentage(partialTicks) * 360.0f - 180.0f;
        if (selectedPart == MannequinPart.LEFT_ARM) {
            z *= -1.0f;
        }
        if (rotations.method_10256() != x || rotations.method_10257() != y || rotations.method_10258() != z) {
            selectedPart.setRotation(this.mannequin, new class_2379(x, y, z));
        }
    }

    public void method_25419() {
        MannequinsMessages.PLAY.sendToServer((PollinatedPacket)new ServerboundSetMannequinPose(((MannequinInventoryMenu)this.field_2797).field_7763, this.mannequin.getHeadPose(), this.mannequin.getBodyPose(), this.mannequin.getLeftArmPose(), this.mannequin.getRightArmPose()));
        super.method_25419();
    }

    public abstract class_2960 getTexture();

    static enum MannequinPart {
        HEAD(AbstractMannequin::setHeadPose, AbstractMannequin::getHeadPose, 98, 21, 176, 59, 16, 16),
        CHEST(AbstractMannequin::setBodyPose, AbstractMannequin::getBodyPose, 98, 37, 176, 39, 16, 20),
        LEFT_ARM(AbstractMannequin::setLeftArmPose, AbstractMannequin::getLeftArmPose, 114, 37, 176, 15, 8, 24),
        RIGHT_ARM(AbstractMannequin::setRightArmPose, AbstractMannequin::getRightArmPose, 90, 37, 176, 15, 8, 24);

        private final BiConsumer<AbstractMannequin, class_2379> rotationSetter;
        private final Function<AbstractMannequin, class_2379> rotationGetter;
        private final int xOffset;
        private final int yOffset;
        private final int buttonU;
        private final int buttonV;
        private final int buttonWidth;
        private final int buttonHeight;

        private MannequinPart(BiConsumer<AbstractMannequin, class_2379> rotationSetter, Function<AbstractMannequin, class_2379> rotationGetter, int xOffset, int yOffset, int buttonU, int buttonV, int buttonWidth, int buttonHeight) {
            this.rotationSetter = rotationSetter;
            this.rotationGetter = rotationGetter;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.buttonU = buttonU;
            this.buttonV = buttonV;
            this.buttonWidth = buttonWidth;
            this.buttonHeight = buttonHeight;
        }

        public boolean isHovered(double mouseX, double mouseY) {
            return mouseX >= (double)this.xOffset && mouseX < (double)(this.xOffset + this.buttonWidth) && mouseY >= (double)this.yOffset && mouseY < (double)(this.yOffset + this.buttonHeight);
        }

        public class_2379 getRotation(AbstractMannequin mannequin) {
            return this.rotationGetter.apply(mannequin);
        }

        public void setRotation(AbstractMannequin mannequin, class_2379 rot) {
            this.rotationSetter.accept(mannequin, rot);
        }
    }
}

