/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.util.unit;

import dev.latvian.mods.rhino.util.unit.Unit;

public class IfUnit
extends Unit {
    private final Unit statement;
    private final Unit trueUnit;
    private final Unit falseUnit;

    public IfUnit(Unit s, Unit t, Unit f) {
        this.statement = s;
        this.trueUnit = t;
        this.falseUnit = f;
    }

    @Override
    public float get() {
        return this.statement.getAsBoolean() ? this.trueUnit.get() : this.falseUnit.get();
    }

    @Override
    public int getAsInt() {
        return this.statement.getAsBoolean() ? this.trueUnit.getAsInt() : this.falseUnit.getAsInt();
    }

    @Override
    public boolean getAsBoolean() {
        return this.statement.getAsBoolean();
    }

    @Override
    public void append(StringBuilder sb) {
        sb.append("if(");
        this.statement.append(sb);
        sb.append(',');
        sb.append(' ');
        this.trueUnit.append(sb);
        sb.append(',');
        sb.append(' ');
        this.falseUnit.append(sb);
        sb.append(')');
    }
}

