/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.util.unit;

import dev.latvian.mods.rhino.util.unit.FuncUnit;
import dev.latvian.mods.rhino.util.unit.Unit;
import org.jetbrains.annotations.Nullable;

public class ColorUnit
extends FuncUnit {
    public final Unit r;
    public final Unit g;
    public final Unit b;
    public final Unit a;
    private final Integer fixed;

    private static int c(Unit u) {
        return Math.min(Math.max(0, u.getAsInt()), 255);
    }

    public ColorUnit(Unit _r, Unit _g, Unit _b, @Nullable Unit _a) {
        this.r = _r;
        this.g = _g;
        this.b = _b;
        this.a = _a;
        this.fixed = this.r.isFixed() && this.g.isFixed() && this.b.isFixed() && (this.a == null || this.a.isFixed()) ? Integer.valueOf(ColorUnit.c(this.r) << 16 | ColorUnit.c(this.g) << 8 | ColorUnit.c(this.b) | (this.a == null ? -16777216 : ColorUnit.c(this.a) << 24)) : null;
    }

    @Override
    public String getFuncName() {
        return "color";
    }

    @Override
    public float get() {
        return this.getAsInt();
    }

    @Override
    public int getAsInt() {
        if (this.fixed != null) {
            return this.fixed;
        }
        return ColorUnit.c(this.r) << 16 | ColorUnit.c(this.g) << 8 | ColorUnit.c(this.b) | (this.a == null ? -16777216 : ColorUnit.c(this.a) << 24);
    }

    @Override
    public boolean getAsBoolean() {
        return this.getAsInt() != 0;
    }

    @Override
    public void append(StringBuilder sb) {
        if (this.fixed != null) {
            sb.append('#');
            if (this.a == null) {
                sb.append(String.format("%06X", this.fixed & 0xFFFFFF));
            } else {
                sb.append(String.format("%08X", this.fixed));
            }
            return;
        }
        sb.append("color(");
        this.r.append(sb);
        sb.append(',');
        sb.append(' ');
        this.g.append(sb);
        sb.append(',');
        sb.append(' ');
        this.b.append(sb);
        if (this.a != null) {
            sb.append(',');
            sb.append(' ');
            this.a.append(sb);
        }
        sb.append(')');
    }
}

