/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.NativeJavaArray;
import dev.latvian.mods.rhino.NativeJavaClass;
import dev.latvian.mods.rhino.NativeJavaList;
import dev.latvian.mods.rhino.NativeJavaMap;
import dev.latvian.mods.rhino.NativeJavaObject;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.Undefined;
import dev.latvian.mods.rhino.util.CustomJavaObjectWrapper;
import dev.latvian.mods.rhino.util.JavaSetWrapper;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WrapFactory {
    private boolean javaPrimitiveWrap = true;

    public Object wrap(Context cx, Scriptable scope, Object obj, Class<?> staticType) {
        Class<?> cls;
        if (obj == null || obj == Undefined.instance || obj instanceof Scriptable) {
            return obj;
        }
        if (staticType == Void.TYPE) {
            return Undefined.instance;
        }
        if (staticType == Character.TYPE) {
            return (int)((Character)obj).charValue();
        }
        if (staticType != null && staticType.isPrimitive()) {
            return obj;
        }
        if (!this.isJavaPrimitiveWrap()) {
            if (obj instanceof String || obj instanceof Boolean || obj instanceof Integer || obj instanceof Short || obj instanceof Long || obj instanceof Float || obj instanceof Double) {
                return obj;
            }
            if (obj instanceof Character) {
                return String.valueOf(((Character)obj).charValue());
            }
        }
        if ((cls = obj.getClass()).isArray()) {
            return NativeJavaArray.wrap(scope, obj);
        }
        return this.wrapAsJavaObject(cx, scope, obj, staticType);
    }

    public Scriptable wrapNewObject(Context cx, Scriptable scope, Object obj) {
        if (obj instanceof Scriptable) {
            return (Scriptable)obj;
        }
        Class<?> cls = obj.getClass();
        if (cls.isArray()) {
            return NativeJavaArray.wrap(scope, obj);
        }
        return this.wrapAsJavaObject(cx, scope, obj, null);
    }

    public Scriptable wrapAsJavaObject(Context cx, Scriptable scope, Object javaObject, Class<?> staticType) {
        if (javaObject instanceof CustomJavaObjectWrapper) {
            CustomJavaObjectWrapper w = (CustomJavaObjectWrapper)javaObject;
            return w.wrapAsJavaObject(cx, scope, staticType);
        }
        if (javaObject instanceof Map) {
            Map map = (Map)javaObject;
            return new NativeJavaMap(scope, (Object)map, map);
        }
        if (javaObject instanceof List) {
            List list = (List)javaObject;
            return new NativeJavaList(scope, (Object)list, list);
        }
        if (javaObject instanceof Set) {
            Set set = (Set)javaObject;
            return new NativeJavaList(scope, (Object)set, new JavaSetWrapper(set));
        }
        return new NativeJavaObject(scope, javaObject, staticType);
    }

    public Scriptable wrapJavaClass(Context cx, Scriptable scope, Class<?> javaClass) {
        return new NativeJavaClass(scope, javaClass);
    }

    public final boolean isJavaPrimitiveWrap() {
        return this.javaPrimitiveWrap;
    }

    public final void setJavaPrimitiveWrap(boolean value) {
        Context cx = Context.getCurrentContext();
        if (cx != null && cx.isSealed()) {
            Context.onSealedMutation();
        }
        this.javaPrimitiveWrap = value;
    }
}

