/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.IdFunctionObject;
import dev.latvian.mods.rhino.IdScriptableObject;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Scriptable;

final class NativeMath
extends IdScriptableObject {
    private static final long serialVersionUID = -8838847185801131569L;
    private static final Object MATH_TAG = "Math";
    private static final double LOG2E = 1.4426950408889634;
    private static final Double Double32 = 32.0;
    private static final int Id_toSource = 1;
    private static final int Id_abs = 2;
    private static final int Id_acos = 3;
    private static final int Id_asin = 4;
    private static final int Id_atan = 5;
    private static final int Id_atan2 = 6;
    private static final int Id_ceil = 7;
    private static final int Id_cos = 8;
    private static final int Id_exp = 9;
    private static final int Id_floor = 10;
    private static final int Id_log = 11;
    private static final int Id_max = 12;
    private static final int Id_min = 13;
    private static final int Id_pow = 14;
    private static final int Id_random = 15;
    private static final int Id_round = 16;
    private static final int Id_sin = 17;
    private static final int Id_sqrt = 18;
    private static final int Id_tan = 19;
    private static final int Id_cbrt = 20;
    private static final int Id_cosh = 21;
    private static final int Id_expm1 = 22;
    private static final int Id_hypot = 23;
    private static final int Id_log1p = 24;
    private static final int Id_log10 = 25;
    private static final int Id_sinh = 26;
    private static final int Id_tanh = 27;
    private static final int Id_imul = 28;
    private static final int Id_trunc = 29;
    private static final int Id_acosh = 30;
    private static final int Id_asinh = 31;
    private static final int Id_atanh = 32;
    private static final int Id_sign = 33;
    private static final int Id_log2 = 34;
    private static final int Id_fround = 35;
    private static final int Id_clz32 = 36;
    private static final int LAST_METHOD_ID = 36;
    private static final int Id_E = 37;
    private static final int Id_PI = 38;
    private static final int Id_LN10 = 39;
    private static final int Id_LN2 = 40;
    private static final int Id_LOG2E = 41;
    private static final int Id_LOG10E = 42;
    private static final int Id_SQRT1_2 = 43;
    private static final int Id_SQRT2 = 44;
    private static final int MAX_ID = 44;

    static void init(Scriptable scope, boolean sealed) {
        NativeMath obj = new NativeMath();
        obj.activatePrototypeMap(44);
        obj.setPrototype(NativeMath.getObjectPrototype(scope));
        obj.setParentScope(scope);
        if (sealed) {
            obj.sealObject();
        }
        NativeMath.defineProperty(scope, "Math", obj, 2);
    }

    private NativeMath() {
    }

    @Override
    public String getClassName() {
        return "Math";
    }

    @Override
    protected void initPrototypeId(int id) {
        if (id <= 36) {
            int arity;
            this.initPrototypeMethod(MATH_TAG, id, switch (id) {
                case 1 -> {
                    arity = 0;
                    yield "toSource";
                }
                case 2 -> {
                    arity = 1;
                    yield "abs";
                }
                case 3 -> {
                    arity = 1;
                    yield "acos";
                }
                case 30 -> {
                    arity = 1;
                    yield "acosh";
                }
                case 4 -> {
                    arity = 1;
                    yield "asin";
                }
                case 31 -> {
                    arity = 1;
                    yield "asinh";
                }
                case 5 -> {
                    arity = 1;
                    yield "atan";
                }
                case 32 -> {
                    arity = 1;
                    yield "atanh";
                }
                case 6 -> {
                    arity = 2;
                    yield "atan2";
                }
                case 20 -> {
                    arity = 1;
                    yield "cbrt";
                }
                case 7 -> {
                    arity = 1;
                    yield "ceil";
                }
                case 36 -> {
                    arity = 1;
                    yield "clz32";
                }
                case 8 -> {
                    arity = 1;
                    yield "cos";
                }
                case 21 -> {
                    arity = 1;
                    yield "cosh";
                }
                case 9 -> {
                    arity = 1;
                    yield "exp";
                }
                case 22 -> {
                    arity = 1;
                    yield "expm1";
                }
                case 10 -> {
                    arity = 1;
                    yield "floor";
                }
                case 35 -> {
                    arity = 1;
                    yield "fround";
                }
                case 23 -> {
                    arity = 2;
                    yield "hypot";
                }
                case 28 -> {
                    arity = 2;
                    yield "imul";
                }
                case 11 -> {
                    arity = 1;
                    yield "log";
                }
                case 24 -> {
                    arity = 1;
                    yield "log1p";
                }
                case 25 -> {
                    arity = 1;
                    yield "log10";
                }
                case 34 -> {
                    arity = 1;
                    yield "log2";
                }
                case 12 -> {
                    arity = 2;
                    yield "max";
                }
                case 13 -> {
                    arity = 2;
                    yield "min";
                }
                case 14 -> {
                    arity = 2;
                    yield "pow";
                }
                case 15 -> {
                    arity = 0;
                    yield "random";
                }
                case 16 -> {
                    arity = 1;
                    yield "round";
                }
                case 33 -> {
                    arity = 1;
                    yield "sign";
                }
                case 17 -> {
                    arity = 1;
                    yield "sin";
                }
                case 26 -> {
                    arity = 1;
                    yield "sinh";
                }
                case 18 -> {
                    arity = 1;
                    yield "sqrt";
                }
                case 19 -> {
                    arity = 1;
                    yield "tan";
                }
                case 27 -> {
                    arity = 1;
                    yield "tanh";
                }
                case 29 -> {
                    arity = 1;
                    yield "trunc";
                }
                default -> throw new IllegalStateException(String.valueOf(id));
            }, arity);
        } else {
            double x;
            this.initPrototypeValue(id, switch (id) {
                case 37 -> {
                    x = Math.E;
                    yield "E";
                }
                case 38 -> {
                    x = Math.PI;
                    yield "PI";
                }
                case 39 -> {
                    x = 2.302585092994046;
                    yield "LN10";
                }
                case 40 -> {
                    x = 0.6931471805599453;
                    yield "LN2";
                }
                case 41 -> {
                    x = 1.4426950408889634;
                    yield "LOG2E";
                }
                case 42 -> {
                    x = 0.4342944819032518;
                    yield "LOG10E";
                }
                case 43 -> {
                    x = 0.7071067811865476;
                    yield "SQRT1_2";
                }
                case 44 -> {
                    x = 1.4142135623730951;
                    yield "SQRT2";
                }
                default -> throw new IllegalStateException(String.valueOf(id));
            }, (Object)ScriptRuntime.wrapNumber(x), 7);
        }
    }

    @Override
    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x;
        if (!f.hasTag(MATH_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int methodId = f.methodId();
        block0 : switch (methodId) {
            case 1: {
                return "Math";
            }
            case 2: {
                x = ScriptRuntime.toNumber(args, 0);
                x = x == 0.0 ? 0.0 : (x < 0.0 ? -x : x);
                break;
            }
            case 3: 
            case 4: {
                x = ScriptRuntime.toNumber(args, 0);
                if (!Double.isNaN(x) && -1.0 <= x && x <= 1.0) {
                    x = methodId == 3 ? Math.acos(x) : Math.asin(x);
                    break;
                }
                x = Double.NaN;
                break;
            }
            case 30: {
                double x2 = ScriptRuntime.toNumber(args, 0);
                if (!Double.isNaN(x2)) {
                    return Math.log(x2 + Math.sqrt(x2 * x2 - 1.0));
                }
                return ScriptRuntime.NaNobj;
            }
            case 31: {
                double x3 = ScriptRuntime.toNumber(args, 0);
                if (Double.isInfinite(x3)) {
                    return x3;
                }
                if (!Double.isNaN(x3)) {
                    if (x3 == 0.0) {
                        if (1.0 / x3 > 0.0) {
                            return ScriptRuntime.zeroObj;
                        }
                        return ScriptRuntime.negativeZeroObj;
                    }
                    return Math.log(x3 + Math.sqrt(x3 * x3 + 1.0));
                }
                return ScriptRuntime.NaNobj;
            }
            case 5: {
                x = ScriptRuntime.toNumber(args, 0);
                x = Math.atan(x);
                break;
            }
            case 32: {
                double x4 = ScriptRuntime.toNumber(args, 0);
                if (!Double.isNaN(x4) && -1.0 <= x4 && x4 <= 1.0) {
                    if (x4 == 0.0) {
                        if (1.0 / x4 > 0.0) {
                            return ScriptRuntime.zeroObj;
                        }
                        return ScriptRuntime.negativeZeroObj;
                    }
                    return 0.5 * Math.log((x4 + 1.0) / (x4 - 1.0));
                }
                return ScriptRuntime.NaNobj;
            }
            case 6: {
                x = ScriptRuntime.toNumber(args, 0);
                x = Math.atan2(x, ScriptRuntime.toNumber(args, 1));
                break;
            }
            case 20: {
                x = ScriptRuntime.toNumber(args, 0);
                x = Math.cbrt(x);
                break;
            }
            case 7: {
                x = ScriptRuntime.toNumber(args, 0);
                x = Math.ceil(x);
                break;
            }
            case 36: {
                double x5 = ScriptRuntime.toNumber(args, 0);
                if (x5 == 0.0 || Double.isNaN(x5) || Double.isInfinite(x5)) {
                    return Double32;
                }
                long n = ScriptRuntime.toUint32(x5);
                if (n == 0L) {
                    return Double32;
                }
                return 31.0 - Math.floor(Math.log(n >>> 0) * 1.4426950408889634);
            }
            case 8: {
                x = ScriptRuntime.toNumber(args, 0);
                x = Double.isInfinite(x) ? Double.NaN : Math.cos(x);
                break;
            }
            case 21: {
                x = ScriptRuntime.toNumber(args, 0);
                x = Math.cosh(x);
                break;
            }
            case 23: {
                x = NativeMath.js_hypot(args);
                break;
            }
            case 9: {
                x = ScriptRuntime.toNumber(args, 0);
                x = x == Double.POSITIVE_INFINITY ? x : (x == Double.NEGATIVE_INFINITY ? 0.0 : Math.exp(x));
                break;
            }
            case 22: {
                x = ScriptRuntime.toNumber(args, 0);
                x = Math.expm1(x);
                break;
            }
            case 10: {
                x = ScriptRuntime.toNumber(args, 0);
                x = Math.floor(x);
                break;
            }
            case 35: {
                x = ScriptRuntime.toNumber(args, 0);
                x = (float)x;
                break;
            }
            case 28: {
                x = NativeMath.js_imul(args);
                break;
            }
            case 11: {
                x = ScriptRuntime.toNumber(args, 0);
                x = x < 0.0 ? Double.NaN : Math.log(x);
                break;
            }
            case 24: {
                x = ScriptRuntime.toNumber(args, 0);
                x = Math.log1p(x);
                break;
            }
            case 25: {
                x = ScriptRuntime.toNumber(args, 0);
                x = Math.log10(x);
                break;
            }
            case 34: {
                x = ScriptRuntime.toNumber(args, 0);
                x = x < 0.0 ? Double.NaN : Math.log(x) * 1.4426950408889634;
                break;
            }
            case 12: 
            case 13: {
                x = methodId == 12 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                for (int i = 0; i != args.length; ++i) {
                    double d = ScriptRuntime.toNumber(args[i]);
                    if (Double.isNaN(d)) {
                        x = d;
                        break block0;
                    }
                    x = methodId == 12 ? Math.max(x, d) : Math.min(x, d);
                }
                break;
            }
            case 14: {
                x = ScriptRuntime.toNumber(args, 0);
                x = NativeMath.js_pow(x, ScriptRuntime.toNumber(args, 1));
                break;
            }
            case 15: {
                x = Math.random();
                break;
            }
            case 16: {
                x = ScriptRuntime.toNumber(args, 0);
                if (Double.isNaN(x) || Double.isInfinite(x)) break;
                long l = Math.round(x);
                if (l != 0L) {
                    x = l;
                    break;
                }
                if (x < 0.0) {
                    x = ScriptRuntime.negativeZero;
                    break;
                }
                if (x == 0.0) break;
                x = 0.0;
                break;
            }
            case 33: {
                double x6 = ScriptRuntime.toNumber(args, 0);
                if (!Double.isNaN(x6)) {
                    if (x6 == 0.0) {
                        if (1.0 / x6 > 0.0) {
                            return ScriptRuntime.zeroObj;
                        }
                        return ScriptRuntime.negativeZeroObj;
                    }
                    return Math.signum(x6);
                }
                return ScriptRuntime.NaNobj;
            }
            case 17: {
                x = ScriptRuntime.toNumber(args, 0);
                x = Double.isInfinite(x) ? Double.NaN : Math.sin(x);
                break;
            }
            case 26: {
                x = ScriptRuntime.toNumber(args, 0);
                x = Math.sinh(x);
                break;
            }
            case 18: {
                x = ScriptRuntime.toNumber(args, 0);
                x = Math.sqrt(x);
                break;
            }
            case 19: {
                x = ScriptRuntime.toNumber(args, 0);
                x = Math.tan(x);
                break;
            }
            case 27: {
                x = ScriptRuntime.toNumber(args, 0);
                x = Math.tanh(x);
                break;
            }
            case 29: {
                x = ScriptRuntime.toNumber(args, 0);
                x = NativeMath.js_trunc(x);
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf(methodId));
            }
        }
        return ScriptRuntime.wrapNumber(x);
    }

    private static double js_pow(double x, double y) {
        double result;
        if (Double.isNaN(y)) {
            result = y;
        } else if (y == 0.0) {
            result = 1.0;
        } else if (x == 0.0) {
            long y_long;
            result = 1.0 / x > 0.0 ? (y > 0.0 ? 0.0 : Double.POSITIVE_INFINITY) : ((double)(y_long = (long)y) == y && (y_long & 1L) != 0L ? (y > 0.0 ? -0.0 : Double.NEGATIVE_INFINITY) : (y > 0.0 ? 0.0 : Double.POSITIVE_INFINITY));
        } else {
            result = Math.pow(x, y);
            if (Double.isNaN(result)) {
                if (y == Double.POSITIVE_INFINITY) {
                    if (x < -1.0 || 1.0 < x) {
                        result = Double.POSITIVE_INFINITY;
                    } else if (-1.0 < x && x < 1.0) {
                        result = 0.0;
                    }
                } else if (y == Double.NEGATIVE_INFINITY) {
                    if (x < -1.0 || 1.0 < x) {
                        result = 0.0;
                    } else if (-1.0 < x && x < 1.0) {
                        result = Double.POSITIVE_INFINITY;
                    }
                } else if (x == Double.POSITIVE_INFINITY) {
                    result = y > 0.0 ? Double.POSITIVE_INFINITY : 0.0;
                } else if (x == Double.NEGATIVE_INFINITY) {
                    long y_long = (long)y;
                    result = (double)y_long == y && (y_long & 1L) != 0L ? (y > 0.0 ? Double.NEGATIVE_INFINITY : -0.0) : (y > 0.0 ? Double.POSITIVE_INFINITY : 0.0);
                }
            }
        }
        return result;
    }

    private static double js_hypot(Object[] args) {
        if (args == null) {
            return 0.0;
        }
        double y = 0.0;
        boolean hasNaN = false;
        boolean hasInfinity = false;
        for (Object o : args) {
            double d = ScriptRuntime.toNumber(o);
            if (Double.isNaN(d)) {
                hasNaN = true;
                continue;
            }
            if (Double.isInfinite(d)) {
                hasInfinity = true;
                continue;
            }
            y += d * d;
        }
        if (hasInfinity) {
            return Double.POSITIVE_INFINITY;
        }
        if (hasNaN) {
            return Double.NaN;
        }
        return Math.sqrt(y);
    }

    private static double js_trunc(double d) {
        return d < 0.0 ? Math.ceil(d) : Math.floor(d);
    }

    private static int js_imul(Object[] args) {
        if (args == null) {
            return 0;
        }
        int x = ScriptRuntime.toInt32(args, 0);
        int y = ScriptRuntime.toInt32(args, 1);
        return x * y;
    }

    @Override
    protected int findPrototypeId(String s) {
        return switch (s) {
            case "toSource" -> 1;
            case "abs" -> 2;
            case "acos" -> 3;
            case "asin" -> 4;
            case "atan" -> 5;
            case "atan2" -> 6;
            case "ceil" -> 7;
            case "cos" -> 8;
            case "exp" -> 9;
            case "floor" -> 10;
            case "log" -> 11;
            case "max" -> 12;
            case "min" -> 13;
            case "pow" -> 14;
            case "random" -> 15;
            case "round" -> 16;
            case "sin" -> 17;
            case "sqrt" -> 18;
            case "tan" -> 19;
            case "cbrt" -> 20;
            case "cosh" -> 21;
            case "expm1" -> 22;
            case "hypot" -> 23;
            case "log1p" -> 24;
            case "log10" -> 25;
            case "sinh" -> 26;
            case "tanh" -> 27;
            case "imul" -> 28;
            case "trunc" -> 29;
            case "acosh" -> 30;
            case "asinh" -> 31;
            case "atanh" -> 32;
            case "sign" -> 33;
            case "log2" -> 34;
            case "fround" -> 35;
            case "clz32" -> 36;
            default -> 0;
        };
    }
}

