/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.NativeJavaObject;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.Symbol;
import dev.latvian.mods.rhino.SymbolKey;
import dev.latvian.mods.rhino.Undefined;
import dev.latvian.mods.rhino.util.Deletable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;

public class NativeJavaList
extends NativeJavaObject {
    private final List list;

    public NativeJavaList(Scriptable scope, Object jo, List list) {
        super(scope, jo, jo.getClass());
        this.list = list;
    }

    @Override
    public String getClassName() {
        return "JavaList";
    }

    @Override
    public boolean has(int index, Scriptable start) {
        if (this.isWithValidIndex(index)) {
            return true;
        }
        return super.has(index, start);
    }

    @Override
    public boolean has(Symbol key, Scriptable start) {
        if (SymbolKey.IS_CONCAT_SPREADABLE.equals(key)) {
            return true;
        }
        return super.has(key, start);
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (this.isWithValidIndex(index)) {
            Context cx = Context.getContext();
            Object obj = this.list.get(index);
            return cx.getWrapFactory().wrap(cx, this, obj, obj.getClass());
        }
        return Undefined.instance;
    }

    @Override
    public Object get(Symbol key, Scriptable start) {
        if (SymbolKey.IS_CONCAT_SPREADABLE.equals(key)) {
            return Boolean.TRUE;
        }
        return super.get(key, start);
    }

    @Override
    public void put(int index, Scriptable start, Object value) {
        if (this.isWithValidIndex(index)) {
            this.list.set(index, Context.jsToJava(value, Object.class));
            return;
        }
        super.put(index, start, value);
    }

    @Override
    public Object[] getIds() {
        List list = (List)this.javaObject;
        Object[] result = new Object[list.size()];
        int i = list.size();
        while (--i >= 0) {
            result[i] = i;
        }
        return result;
    }

    private boolean isWithValidIndex(int index) {
        return index >= 0 && index < this.list.size();
    }

    @Override
    public void delete(int index) {
        if (this.isWithValidIndex(index)) {
            Deletable.deleteObject(this.list.remove(index));
        }
    }

    @Override
    protected void initMembers() {
        super.initMembers();
        this.addCustomProperty("length", this::getLength);
        this.addCustomFunction("push", this::push, Object.class);
        this.addCustomFunction("pop", this::pop);
        this.addCustomFunction("shift", this::shift);
        this.addCustomFunction("unshift", this::unshift, Object.class);
        this.addCustomFunction("concat", this::concat, List.class);
        this.addCustomFunction("join", this::join, String.class);
        this.addCustomFunction("reverse", this::reverse);
        this.addCustomFunction("slice", this::slice, Object.class);
        this.addCustomFunction("splice", this::splice, Object.class);
        this.addCustomFunction("every", this::every, Predicate.class);
        this.addCustomFunction("some", this::some, Predicate.class);
        this.addCustomFunction("filter", this::filter, Predicate.class);
        this.addCustomFunction("map", this::map, Function.class);
        this.addCustomFunction("reduce", this::reduce, BinaryOperator.class);
        this.addCustomFunction("reduceRight", this::reduceRight, BinaryOperator.class);
    }

    private int getLength() {
        return this.list.size();
    }

    private int push(Object[] args) {
        if (args.length == 1) {
            this.list.add(args[0]);
        } else if (args.length > 1) {
            this.list.addAll(Arrays.asList(args));
        }
        return this.list.size();
    }

    private Object pop() {
        if (this.list.isEmpty()) {
            return Undefined.instance;
        }
        return this.list.remove(this.list.size() - 1);
    }

    private Object shift() {
        if (this.list.isEmpty()) {
            return Undefined.instance;
        }
        return this.list.remove(0);
    }

    private int unshift(Object[] args) {
        for (int i = args.length - 1; i >= 0; --i) {
            this.list.add(0, args[i]);
        }
        return this.list.size();
    }

    private Object concat(Object[] args) {
        ArrayList list1 = new ArrayList(this.list);
        if (args.length > 0 && args[0] instanceof List) {
            list1.addAll((List)args[0]);
        }
        return list1;
    }

    private String join(Object[] args) {
        if (this.list.isEmpty()) {
            return "";
        }
        if (this.list.size() == 1) {
            return ScriptRuntime.toString(this.list.get(0));
        }
        String j = ScriptRuntime.toString(args[0]);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.list.size(); ++i) {
            if (i > 0) {
                sb.append(j);
            }
            sb.append(ScriptRuntime.toString(this.list.get(i)));
        }
        return sb.toString();
    }

    private NativeJavaList reverse() {
        if (this.list.size() > 1) {
            Collections.reverse(this.list);
        }
        return this;
    }

    private Object slice(Object[] args) {
        throw new IllegalStateException("Not implemented yet!");
    }

    private Object splice(Object[] args) {
        throw new IllegalStateException("Not implemented yet!");
    }

    private Object every(Object[] args) {
        Predicate predicate = (Predicate)args[0];
        for (Object o : this.list) {
            if (predicate.test(o)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Object some(Object[] args) {
        Predicate predicate = (Predicate)args[0];
        for (Object o : this.list) {
            if (!predicate.test(o)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Object filter(Object[] args) {
        if (this.list.isEmpty()) {
            return this;
        }
        Predicate predicate = (Predicate)args[0];
        ArrayList list1 = new ArrayList();
        for (Object o : this.list) {
            if (!predicate.test(o)) continue;
            list1.add(o);
        }
        return list1;
    }

    private Object map(Object[] args) {
        if (this.list.isEmpty()) {
            return this;
        }
        Function function = (Function)args[0];
        ArrayList list1 = new ArrayList();
        for (Object o : this.list) {
            list1.add(function.apply(o));
        }
        return list1;
    }

    private Object reduce(Object[] args) {
        if (this.list.isEmpty()) {
            return Undefined.instance;
        }
        if (this.list.size() == 1) {
            return this.list.get(0);
        }
        BinaryOperator operator = (BinaryOperator)args[0];
        Object o = this.list.get(0);
        for (int i = 1; i < this.list.size(); ++i) {
            o = operator.apply(o, this.list.get(i));
        }
        return o;
    }

    private Object reduceRight(Object[] args) {
        if (this.list.isEmpty()) {
            return Undefined.instance;
        }
        if (this.list.size() == 1) {
            return this.list.get(0);
        }
        BinaryOperator operator = (BinaryOperator)args[0];
        Object o = this.list.get(0);
        for (int i = this.list.size() - 1; i >= 1; --i) {
            o = operator.apply(o, this.list.get(i));
        }
        return o;
    }
}

