/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.util;

import io.wispforest.owo.registration.annotations.AssignedName;
import io.wispforest.owo.registration.annotations.IterationIgnored;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class ReflectionUtils {
    public static <C> C tryInstantiateWithNoArgs(Class<C> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException((e instanceof NoSuchMethodException ? "No zero-args constructor defined on class " : "Could not instantiate class ") + clazz, e);
        }
    }

    public static <C> C instantiate(Constructor<C> constructor, Object ... args) {
        try {
            return constructor.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Wrapped object creation failure, look below for reason", e);
        }
    }

    public static <C> Constructor<C> getNoArgsConstructor(Class<C> clazz) {
        try {
            return clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Class " + clazz.getName() + " does not declare a zero-args constructor", e);
        }
    }

    @Deprecated(forRemoval=true, since="0.3.13")
    @ApiStatus.ScheduledForRemoval
    public static <C, F> void iterateAccessibleStaticFields(Class<C> clazz, Class<F> targetFieldType, BiConsumer<F, String> fieldConsumer) {
        ReflectionUtils.iterateAccessibleStaticFields(clazz, targetFieldType, (f, s, field) -> fieldConsumer.accept((Object)f, (String)s));
    }

    public static <C, F> void iterateAccessibleStaticFields(Class<C> clazz, Class<F> targetFieldType, TriConsumer<F, String, Field> fieldConsumer) {
        for (Field field : clazz.getDeclaredFields()) {
            Object value;
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                value = field.get(null);
            }
            catch (IllegalAccessException e) {
                continue;
            }
            if (value == null || !targetFieldType.isAssignableFrom(value.getClass()) || field.isAnnotationPresent(IterationIgnored.class)) continue;
            fieldConsumer.accept(value, (Object)ReflectionUtils.getFieldName(field), (Object)field);
        }
    }

    public static String getFieldName(Field field) {
        String fieldId = field.getName().toLowerCase();
        if (field.isAnnotationPresent(AssignedName.class)) {
            fieldId = field.getAnnotation(AssignedName.class).value();
        }
        return fieldId;
    }

    public static void forApplicableSubclasses(Class<?> parent, Class<?> targetType, Consumer<Class<?>> action) {
        for (Class<?> subclass : parent.getDeclaredClasses()) {
            if (!targetType.isAssignableFrom(subclass)) continue;
            action.accept(subclass);
        }
    }

    public static void requireZeroArgsConstructor(Class<?> clazz, Function<String, String> reasonFormatter) {
        boolean found = false;
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalStateException(reasonFormatter.apply(clazz.getName()));
        }
    }

    public static String getCallingClassName(int depth) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        if (++depth > trace.length - 1) {
            return "<unknown>";
        }
        return trace[depth].getClassName();
    }
}

