/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.particles.systems;

import io.wispforest.owo.network.serialization.PacketBufSerializer;
import io.wispforest.owo.particles.systems.ParticleSystemController;
import io.wispforest.owo.particles.systems.ParticleSystemExecutor;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class ParticleSystem<T> {
    private final ParticleSystemController manager;
    final int index;
    final PacketBufSerializer<T> adapter;
    final ParticleSystemExecutor<T> handler;
    private final boolean permitsContextlessExecution;

    ParticleSystem(ParticleSystemController manager, Class<T> dataClass, int index, PacketBufSerializer<T> adapter, ParticleSystemExecutor<T> handler) {
        this.manager = manager;
        this.index = index;
        this.adapter = adapter;
        this.handler = handler;
        this.permitsContextlessExecution = dataClass == Void.class;
    }

    public void spawn(class_1937 world, class_243 pos, @Nullable T data) {
        if (data == null && !this.permitsContextlessExecution) {
            throw new IllegalStateException("This particle system does not permit 'null' data");
        }
        if (world.field_9236) {
            this.handler.executeParticleSystem(world, pos, data);
        } else {
            this.manager.sendPacket(this, (class_3218)world, pos, data);
        }
    }

    public void spawn(class_1937 world, class_243 pos) {
        this.spawn(world, pos, null);
    }
}

