/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.network.serialization;

import com.google.common.collect.ImmutableMap;
import io.wispforest.owo.Owo;
import io.wispforest.owo.network.serialization.PacketBufSerializer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.RecordComponent;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.minecraft.class_2540;

public class RecordSerializer<R extends Record> {
    private static final Map<Class<?>, RecordSerializer<?>> SERIALIZERS = new HashMap();
    private final Map<Function<R, ?>, PacketBufSerializer> adapters;
    private final Class<R> recordClass;
    private final Constructor<R> instanceCreator;
    private final int fieldCount;

    private RecordSerializer(Class<R> recordClass, Constructor<R> instanceCreator, ImmutableMap<Function<R, ?>, PacketBufSerializer> adapters) {
        this.recordClass = recordClass;
        this.instanceCreator = instanceCreator;
        this.adapters = adapters;
        this.fieldCount = recordClass.getRecordComponents().length;
    }

    public static <R extends Record> RecordSerializer<R> create(Class<R> recordClass) {
        if (SERIALIZERS.containsKey(recordClass)) {
            return SERIALIZERS.get(recordClass);
        }
        ImmutableMap.Builder adapters = new ImmutableMap.Builder();
        Class[] canonicalConstructorArgs = new Class[recordClass.getRecordComponents().length];
        for (int i = 0; i < recordClass.getRecordComponents().length; ++i) {
            RecordComponent component = recordClass.getRecordComponents()[i];
            adapters.put(r -> RecordSerializer.getRecordEntry(r, component.getAccessor()), PacketBufSerializer.getWithAnnotations(component.getType(), component));
            canonicalConstructorArgs[i] = component.getType();
        }
        try {
            RecordSerializer<R> serializer = new RecordSerializer<R>(recordClass, recordClass.getConstructor(canonicalConstructorArgs), adapters.build());
            SERIALIZERS.put(recordClass, serializer);
            return serializer;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Could not locate canonical record constructor");
        }
    }

    public R read(class_2540 buffer) {
        Object[] messageContents = new Object[this.fieldCount];
        AtomicInteger index = new AtomicInteger();
        this.adapters.forEach((rFunction, typeAdapter) -> {
            messageContents[index.getAndIncrement()] = typeAdapter.deserializer().apply(buffer);
        });
        try {
            return (R)((Record)this.instanceCreator.newInstance(messageContents));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            Owo.LOGGER.error("Error while deserializing record", (Throwable)e);
            return null;
        }
    }

    public RecordSerializer<R> write(class_2540 buffer, R instance) {
        this.adapters.forEach((rFunction, typeAdapter) -> typeAdapter.serializer().accept(buffer, (class_2540)rFunction.apply(instance)));
        return this;
    }

    public Class<R> getRecordClass() {
        return this.recordClass;
    }

    private static <R extends Record> Object getRecordEntry(R instance, Method accessor) {
        try {
            return accessor.invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to get record entry", e);
        }
    }
}

