/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.network;

import io.wispforest.owo.Owo;
import io.wispforest.owo.network.ClientAccess;
import io.wispforest.owo.network.NetworkException;
import io.wispforest.owo.network.OwoHandshake;
import io.wispforest.owo.network.ServerAccess;
import io.wispforest.owo.network.serialization.RecordSerializer;
import io.wispforest.owo.util.ReflectionUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;

public class OwoNetChannel {
    private static boolean FROZEN = false;
    static final Map<class_2960, OwoNetChannel> REGISTERED_CHANNELS = new HashMap<class_2960, OwoNetChannel>();
    private final Map<Class<?>, IndexedSerializer<?>> serializersByClass = new HashMap();
    final Int2ObjectMap<IndexedSerializer<?>> serializersByIndex = new Int2ObjectOpenHashMap();
    private final List<ChannelHandler<Record, ClientAccess>> clientHandlers = new ArrayList<ChannelHandler<Record, ClientAccess>>();
    private final List<ChannelHandler<Record, ServerAccess>> serverHandlers = new ArrayList<ChannelHandler<Record, ServerAccess>>();
    final class_2960 packetId;
    private final String ownerClassName;
    private ClientHandle clientHandle = null;
    private ServerHandle serverHandle = null;

    public static OwoNetChannel create(class_2960 id) {
        return new OwoNetChannel(id, ReflectionUtils.getCallingClassName(2));
    }

    private OwoNetChannel(class_2960 id, String ownerClassName) {
        if (REGISTERED_CHANNELS.containsKey(id)) {
            throw new IllegalStateException("Channel with id '" + id + "' was already registered from class '" + OwoNetChannel.REGISTERED_CHANNELS.get((Object)id).ownerClassName + "'");
        }
        this.packetId = id;
        this.ownerClassName = ownerClassName;
        ServerPlayNetworking.registerGlobalReceiver((class_2960)this.packetId, (server, player, handler, buf, responseSender) -> {
            int handlerIndex = buf.method_10816();
            Object message = ((IndexedSerializer)this.serializersByIndex.get((int)handlerIndex)).serializer.read(buf);
            server.execute(() -> this.serverHandlers.get(handlerIndex).handle((Record)message, new ServerAccess(player)));
        });
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)this.packetId, (client, handler, buf, responseSender) -> {
                int handlerIndex = buf.method_10816();
                Object message = ((IndexedSerializer)this.serializersByIndex.get((int)(-handlerIndex))).serializer.read(buf);
                client.execute(() -> this.clientHandlers.get(handlerIndex).handle((Record)message, new ClientAccess(handler)));
            });
        }
        this.clientHandlers.add(null);
        this.serverHandlers.add(null);
        REGISTERED_CHANNELS.put(id, this);
    }

    public <R extends Record> void registerClientbound(Class<R> messageClass, ChannelHandler<R, ClientAccess> handler) {
        int index = this.clientHandlers.size();
        this.createSerializer(messageClass, index, EnvType.CLIENT);
        this.clientHandlers.add(handler);
    }

    public <R extends Record> void registerServerbound(Class<R> messageClass, ChannelHandler<R, ServerAccess> handler) {
        int index = this.serverHandlers.size();
        this.createSerializer(messageClass, index, EnvType.SERVER);
        this.serverHandlers.add(handler);
    }

    public ClientHandle clientHandle() {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            throw new NetworkException("Cannot obtain client handle in environment type '" + FabricLoader.getInstance().getEnvironmentType() + "'");
        }
        if (this.clientHandle == null) {
            this.clientHandle = new ClientHandle();
        }
        return this.clientHandle;
    }

    public ServerHandle serverHandle(MinecraftServer server) {
        ServerHandle handle = this.getServerHandle();
        handle.targets = PlayerLookup.all((MinecraftServer)server);
        return handle;
    }

    public ServerHandle serverHandle(Collection<class_3222> targets) {
        ServerHandle handle = this.getServerHandle();
        handle.targets = targets;
        return handle;
    }

    public ServerHandle serverHandle(class_1657 player) {
        if (!(player instanceof class_3222)) {
            throw new NetworkException("'player' must be a 'ServerPlayerEntity'");
        }
        class_3222 serverPlayer = (class_3222)player;
        ServerHandle handle = this.getServerHandle();
        handle.targets = Collections.singleton(serverPlayer);
        return handle;
    }

    public ServerHandle serverHandle(class_2586 entity) {
        if (entity.method_10997().field_9236) {
            throw new NetworkException("Server handle cannot be obtained on the client");
        }
        return this.serverHandle(PlayerLookup.tracking((class_2586)entity));
    }

    public ServerHandle serverHandle(class_3218 world, class_2338 pos) {
        return this.serverHandle(PlayerLookup.tracking((class_3218)world, (class_2338)pos));
    }

    private ServerHandle getServerHandle() {
        if (this.serverHandle == null) {
            this.serverHandle = new ServerHandle();
        }
        return this.serverHandle;
    }

    private <R extends Record> void createSerializer(Class<R> messageClass, int handlerIndex, EnvType target) {
        if (FROZEN) {
            throw new NetworkException("Network handlers may only be registered during mod initialization");
        }
        IndexedSerializer<?> serializer = this.serializersByClass.get(messageClass);
        if (serializer == null) {
            IndexedSerializer<R> indexedSerializer = IndexedSerializer.create(RecordSerializer.create(messageClass), handlerIndex, target);
            this.serializersByClass.put(messageClass, indexedSerializer);
            this.serializersByIndex.put(target == EnvType.CLIENT ? -handlerIndex : handlerIndex, indexedSerializer);
        } else if (serializer.handlerIndex(target) == -1) {
            serializer.setHandlerIndex(handlerIndex, target);
            this.serializersByIndex.put(target == EnvType.CLIENT ? -handlerIndex : handlerIndex, serializer);
        } else {
            throw new IllegalStateException("Message class '" + messageClass.getName() + "' is already registered for target environment " + target);
        }
    }

    private <R extends Record> class_2540 encode(R message, EnvType target) {
        class_2540 buffer = PacketByteBufs.create();
        Class<?> messageClass = message.getClass();
        if (!this.serializersByClass.containsKey(messageClass)) {
            throw new NetworkException("Message class '" + messageClass + "' is not registered");
        }
        IndexedSerializer<?> serializer = this.serializersByClass.get(messageClass);
        if (serializer.handlerIndex(target) == -1) {
            throw new NetworkException("Message class '" + messageClass + "' has not handler registered for target environment " + target);
        }
        buffer.method_10804(serializer.handlerIndex(target));
        serializer.serializer.write(buffer, message);
        return buffer;
    }

    @Deprecated
    @ApiStatus.Internal
    public static void freezeAllChannels() {
        FROZEN = true;
        if (!Owo.DEBUG) {
            return;
        }
        Owo.LOGGER.info("Channels frozen by '" + ReflectionUtils.getCallingClassName(2) + "'");
    }

    static {
        OwoHandshake.enable();
    }

    public class ClientHandle {
        public <R extends Record> void send(R message) {
            ClientPlayNetworking.send((class_2960)OwoNetChannel.this.packetId, (class_2540)OwoNetChannel.this.encode(message, EnvType.SERVER));
        }

        @SafeVarargs
        public final <R extends Record> void send(R ... messages) {
            for (R message : messages) {
                this.send(message);
            }
        }
    }

    public class ServerHandle {
        private Collection<class_3222> targets = Collections.emptySet();

        public <R extends Record> void send(R message) {
            this.targets.forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_2960)OwoNetChannel.this.packetId, (class_2540)OwoNetChannel.this.encode(message, EnvType.CLIENT)));
            this.targets = null;
        }

        @SafeVarargs
        public final <R extends Record> void send(R ... messages) {
            this.targets.forEach(player -> {
                for (Record message : messages) {
                    ServerPlayNetworking.send((class_3222)player, (class_2960)OwoNetChannel.this.packetId, (class_2540)OwoNetChannel.this.encode(message, EnvType.CLIENT));
                }
            });
            this.targets = null;
        }
    }

    static final class IndexedSerializer<R extends Record> {
        private int clientHandlerIndex = -1;
        private int serverHandlerIndex = -1;
        final RecordSerializer<R> serializer;

        private IndexedSerializer(RecordSerializer<R> serializer) {
            this.serializer = serializer;
        }

        public static <R extends Record> IndexedSerializer<R> create(RecordSerializer<R> serializer, int index, EnvType target) {
            return new IndexedSerializer<R>(serializer).setHandlerIndex(index, target);
        }

        public IndexedSerializer<R> setHandlerIndex(int index, EnvType target) {
            switch (target) {
                case CLIENT: {
                    this.clientHandlerIndex = index;
                    break;
                }
                case SERVER: {
                    this.serverHandlerIndex = index;
                }
            }
            return this;
        }

        public int handlerIndex(EnvType target) {
            return switch (target) {
                default -> throw new IncompatibleClassChangeError();
                case EnvType.CLIENT -> this.clientHandlerIndex;
                case EnvType.SERVER -> this.serverHandlerIndex;
            };
        }
    }

    public static interface ChannelHandler<R extends Record, E extends EnvironmentAccess<?, ?, ?>> {
        public void handle(R var1, E var2);
    }

    public static interface EnvironmentAccess<P extends class_1657, R, N> {
        public P player();

        public R runtime();

        public N netHandler();
    }
}

