/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.network;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.wispforest.owo.Owo;
import io.wispforest.owo.network.OwoNetChannel;
import io.wispforest.owo.network.serialization.PacketBufSerializer;
import io.wispforest.owo.ops.TextOps;
import io.wispforest.owo.particles.systems.ParticleSystemController;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3248;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_635;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class OwoHandshake {
    private static final PacketBufSerializer<Map<class_2960, Integer>> RESPONSE_SERIALIZER = PacketBufSerializer.createMapSerializer(Map.class, class_2960.class, Integer.class);
    private static final class_5250 PREFIX = TextOps.concat(Owo.PREFIX, class_2561.method_30163((String)"\u00a7chandshake failure\n"));
    public static final class_2960 CHANNEL_ID = new class_2960("owo", "handshake");
    private static final boolean ENABLED = !Boolean.getBoolean("owo.handshake.disable");

    public static void enable() {
    }

    private static void queryStart(class_3248 serverLoginNetworkHandler, MinecraftServer server, PacketSender sender, ServerLoginNetworking.LoginSynchronizer loginSynchronizer) {
        if (!ENABLED) {
            return;
        }
        sender.sendPacket(CHANNEL_ID, PacketByteBufs.create());
        Owo.LOGGER.info("[Handshake] Sending channel query");
    }

    @Environment(value=EnvType.CLIENT)
    private static CompletableFuture<class_2540> syncClient(class_310 client, class_635 clientLoginNetworkHandler, class_2540 buf, Consumer<GenericFutureListener<? extends Future<? super Void>>> genericFutureListenerConsumer) {
        Owo.LOGGER.info("[Handshake] Sending client channels");
        class_2540 response = PacketByteBufs.create();
        OwoHandshake.writeHashes(response, OwoNetChannel.REGISTERED_CHANNELS, OwoHandshake::hashChannel);
        OwoHandshake.writeHashes(response, ParticleSystemController.REGISTERED_CONTROLLERS, OwoHandshake::hashController);
        return CompletableFuture.completedFuture(response);
    }

    private static void syncServer(MinecraftServer server, class_3248 handler, boolean responded, class_2540 buf, ServerLoginNetworking.LoginSynchronizer loginSynchronizer, PacketSender packetSender) {
        Owo.LOGGER.info("[Handshake] Receiving client channels");
        if (!responded) {
            handler.method_14380((class_2561)TextOps.concat((class_2561)PREFIX, class_2561.method_30163((String)"incompatible client")));
            Owo.LOGGER.info("[Handshake] Handshake failed, client did not respond to channel query");
            return;
        }
        Map<class_2960, Integer> clientChannels = RESPONSE_SERIALIZER.deserializer().apply(buf);
        Map<class_2960, Integer> clientParticleControllers = RESPONSE_SERIALIZER.deserializer().apply(buf);
        StringBuilder disconnectMessage = new StringBuilder();
        boolean isAllGood = OwoHandshake.verifyReceivedHashes("channels", clientChannels, OwoNetChannel.REGISTERED_CHANNELS, OwoHandshake::hashChannel, disconnectMessage);
        if (!(isAllGood &= OwoHandshake.verifyReceivedHashes("controllers", clientParticleControllers, ParticleSystemController.REGISTERED_CONTROLLERS, OwoHandshake::hashController, disconnectMessage))) {
            handler.method_14380((class_2561)TextOps.concat((class_2561)PREFIX, class_2561.method_30163((String)disconnectMessage.toString())));
        } else {
            Owo.LOGGER.info("[Handshake] Handshake completed successfully");
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void handleJoinClient(class_634 handler, PacketSender packetSender, class_310 client) {
        if (ClientPlayNetworking.canSend((class_2960)CHANNEL_ID)) {
            return;
        }
        client.execute(() -> handler.method_2872().method_10747((class_2561)TextOps.concat((class_2561)PREFIX, class_2561.method_30163((String)"incompatible server"))));
    }

    private static <T> boolean verifyReceivedHashes(String serviceNamePlural, Map<class_2960, Integer> clientMap, Map<class_2960, T> serverMap, ToIntFunction<T> hashFunction, StringBuilder disconnectMessage) {
        boolean isAllGood = true;
        if (!clientMap.keySet().equals(serverMap.keySet())) {
            isAllGood = false;
            class_3545<Set<class_2960>, Set<class_2960>> leftovers = OwoHandshake.findCollisions(clientMap.keySet(), serverMap.keySet());
            if (!((Set)leftovers.method_15442()).isEmpty()) {
                disconnectMessage.append("server is missing ").append(serviceNamePlural).append(":\n");
                ((Set)leftovers.method_15442()).forEach(identifier -> disconnectMessage.append("\u00a77").append(identifier).append("\u00a7r\n"));
            }
            if (!((Set)leftovers.method_15441()).isEmpty()) {
                disconnectMessage.append("client is missing ").append(serviceNamePlural).append(":\n");
                ((Set)leftovers.method_15441()).forEach(identifier -> disconnectMessage.append("\u00a77").append(identifier).append("\u00a7r\n"));
            }
        }
        boolean hasMismatchedHashes = false;
        for (Map.Entry<class_2960, Integer> entry : clientMap.entrySet()) {
            int localHash;
            T actualServiceObject = serverMap.get(entry.getKey());
            if (actualServiceObject == null || (localHash = hashFunction.applyAsInt(actualServiceObject)) == entry.getValue()) continue;
            if (!hasMismatchedHashes) {
                disconnectMessage.append(serviceNamePlural).append(" with mismatched hashes:\n");
            }
            disconnectMessage.append("\u00a77").append(entry.getKey()).append("\u00a7r\n");
            isAllGood = false;
            hasMismatchedHashes = true;
        }
        return isAllGood;
    }

    private static <T> void writeHashes(class_2540 buffer, Map<class_2960, T> values, ToIntFunction<T> hashFunction) {
        HashMap<class_2960, Integer> hashes = new HashMap<class_2960, Integer>();
        for (Map.Entry<class_2960, T> entry : values.entrySet()) {
            hashes.put(entry.getKey(), hashFunction.applyAsInt(entry.getValue()));
        }
        RESPONSE_SERIALIZER.serializer().accept(buffer, hashes);
    }

    private static class_3545<Set<class_2960>, Set<class_2960>> findCollisions(Set<class_2960> first, Set<class_2960> second) {
        HashSet firstLeftovers = new HashSet();
        HashSet secondLeftovers = new HashSet();
        first.forEach(identifier -> {
            if (!second.contains(identifier)) {
                firstLeftovers.add(identifier);
            }
        });
        second.forEach(identifier -> {
            if (!first.contains(identifier)) {
                secondLeftovers.add(identifier);
            }
        });
        return new class_3545(firstLeftovers, secondLeftovers);
    }

    private static int hashChannel(OwoNetChannel channel) {
        int serializersHash = 0;
        for (Int2ObjectMap.Entry entry : channel.serializersByIndex.int2ObjectEntrySet()) {
            serializersHash += entry.getIntKey() * 31 + ((OwoNetChannel.IndexedSerializer)entry.getValue()).serializer.getRecordClass().getName().hashCode();
        }
        return 31 * channel.packetId.hashCode() + serializersHash;
    }

    private static int hashController(ParticleSystemController controller) {
        int serializersHash = 0;
        for (Int2ObjectMap.Entry entry : controller.systemsByIndex.int2ObjectEntrySet()) {
            serializersHash += entry.getIntKey();
        }
        return 31 * controller.channelId.hashCode() + serializersHash;
    }

    static {
        ServerLoginConnectionEvents.QUERY_START.register(OwoHandshake::queryStart);
        ServerLoginNetworking.registerGlobalReceiver((class_2960)CHANNEL_ID, OwoHandshake::syncServer);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CHANNEL_ID, (server, player, handler, buf, responseSender) -> {});
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientLoginNetworking.registerGlobalReceiver((class_2960)CHANNEL_ID, OwoHandshake::syncClient);
            ClientPlayConnectionEvents.JOIN.register(OwoHandshake::handleJoinClient);
        }
    }
}

