/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.wispforest.owo.Owo;
import io.wispforest.owo.command.EnumArgumentType;
import io.wispforest.owo.ops.TextOps;
import java.lang.reflect.Field;
import java.util.List;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2287;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3039;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4158;
import net.minecraft.class_5250;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.spi.StandardLevel;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class OwoDebugCommands {
    private static final EnumArgumentType<StandardLevel> LEVEL_ARGUMENT_TYPE = EnumArgumentType.create(StandardLevel.class, "'{}' is not a valid logging level");
    private static final SuggestionProvider<class_2168> POI_TYPES = (context, builder) -> class_2172.method_9270((Iterable)class_2378.field_18792.method_10235(), (SuggestionsBuilder)builder);
    private static final SimpleCommandExceptionType NO_POI_TYPE = new SimpleCommandExceptionType((Message)class_2561.method_30163((String)"Invalid POI type"));
    private static final int GENERAL_PURPLE = 12157951;
    private static final int KEY_BLUE = 9745405;
    private static final int VALUE_BLUE = 9755391;

    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"dumpdata").then(class_2170.method_9247((String)"item").executes(context -> {
                class_2168 source = (class_2168)context.getSource();
                class_1799 stack = source.method_9207().method_6047();
                String itemId = class_2378.field_11142.method_10221((Object)stack.method_7909()).toString();
                source.method_9226((class_2561)TextOps.withColor("---[\u00a7 Item Information \u00a7]---", TextOps.color(class_124.field_1080), 12157951, TextOps.color(class_124.field_1080)), false);
                source.method_9226((class_2561)TextOps.withColor("Identifier: \u00a7" + itemId.split(":")[0] + ":\u00a7" + itemId.split(":")[1], TextOps.color(class_124.field_1080), 9745405, 9755391), false);
                if (stack.method_7909().method_7846()) {
                    source.method_9226((class_2561)TextOps.withColor("Durability: \u00a7" + stack.method_7909().method_7841(), TextOps.color(class_124.field_1080), 9745405), false);
                } else {
                    source.method_9226((class_2561)TextOps.withColor("Not damageable", TextOps.color(class_124.field_1080)), false);
                }
                if (((class_2168)context.getSource()).method_9207().method_6047().method_7985()) {
                    source.method_9226((class_2561)TextOps.withColor("Tag: ", TextOps.color(class_124.field_1080)).method_10852(class_2512.method_32270((class_2520)stack.method_7969())), false);
                } else {
                    source.method_9226((class_2561)TextOps.withColor("No tag", TextOps.color(class_124.field_1080)), false);
                }
                source.method_9226(class_2561.method_30163((String)"\u00a77----------------------"), false);
                return 0;
            }))).then(class_2170.method_9247((String)"block").executes(context -> {
                class_2168 source = (class_2168)context.getSource();
                class_3222 player = source.method_9207();
                class_239 target = player.method_5745(5.0, 0.0f, false);
                if (target.method_17783() != class_239.class_240.field_1332) {
                    source.method_9213((class_2561)TextOps.concat(Owo.PREFIX, (class_2561)new class_2585("You're not looking at a block")));
                    return 1;
                }
                class_2338 pos = ((class_3965)target).method_17777();
                String blockState = player.method_14220().method_8320(pos).toString();
                String blockId = blockState.split(Pattern.quote("["))[0];
                blockId = blockId.substring(6, blockId.length() - 1);
                source.method_9226((class_2561)TextOps.withColor("---[\u00a7 Block Information \u00a7]---", TextOps.color(class_124.field_1080), 12157951, TextOps.color(class_124.field_1080)), false);
                source.method_9226((class_2561)TextOps.withColor("Identifier: \u00a7" + blockId.split(":")[0] + ":\u00a7" + blockId.split(":")[1], TextOps.color(class_124.field_1080), 9745405, 9755391), false);
                if (blockState.contains("[")) {
                    String stateString = blockState.split(Pattern.quote("["))[1];
                    stateString = stateString.substring(0, stateString.length() - 1);
                    String[] stateInfo = stateString.replaceAll("=", ": \u00a7").split(",");
                    source.method_9226((class_2561)TextOps.withColor("State properties: ", TextOps.color(class_124.field_1080)), false);
                    for (String property : stateInfo) {
                        source.method_9226((class_2561)TextOps.withColor("    " + property, 9745405, 9755391), false);
                    }
                } else {
                    source.method_9226((class_2561)TextOps.withColor("No state properties", TextOps.color(class_124.field_1080)), false);
                }
                class_2586 blockEntity = player.method_14220().method_8321(pos);
                if (blockEntity != null) {
                    source.method_9226((class_2561)TextOps.withColor("Tag: ", TextOps.color(class_124.field_1080)).method_10852(class_2512.method_32270((class_2520)blockEntity.method_38244())), false);
                } else {
                    source.method_9226((class_2561)TextOps.withColor("No block entity", TextOps.color(class_124.field_1080)), false);
                }
                source.method_9226(class_2561.method_30163((String)"\u00a77-----------------------"), false);
                return 0;
            })));
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"give_loot_container").then(class_2170.method_9244((String)"item", (ArgumentType)class_2287.method_9776()).then(class_2170.method_9244((String)"loot_table", (ArgumentType)class_2232.method_9441()).suggests(class_3039.field_13605).executes(context -> {
                class_1799 targetStack = class_2287.method_9777((CommandContext)context, (String)"item").method_9781(1, false);
                class_2960 table_id = class_2232.method_9443((CommandContext)context, (String)"loot_table");
                targetStack.method_7911("BlockEntityTag").method_10582("LootTable", table_id.toString());
                ((class_2168)context.getSource()).method_9207().method_31548().method_7398(targetStack);
                return 0;
            }))));
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"logger").then(class_2170.method_9244((String)"level", LEVEL_ARGUMENT_TYPE).executes(context -> {
                StandardLevel level = LEVEL_ARGUMENT_TYPE.get(context, "level");
                LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
                ctx.getConfiguration().getLoggerConfig("").setLevel(Level.getLevel((String)level.name()));
                ctx.updateLoggers();
                ((class_2168)context.getSource()).method_9226((class_2561)TextOps.concat(Owo.PREFIX, (class_2561)new class_2585("Global logging level set to: \u00a79" + level)), false);
                return 0;
            })));
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"query_poi").then(class_2170.method_9244((String)"poi_type", (ArgumentType)class_2232.method_9441()).suggests(POI_TYPES).then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
                class_3222 player = ((class_2168)context.getSource()).method_9207();
                class_4158 poiType = (class_4158)class_2378.field_18792.method_17966(class_2232.method_9443((CommandContext)context, (String)"poi_type")).orElseThrow(() -> ((SimpleCommandExceptionType)NO_POI_TYPE).create());
                List entries = ((class_3218)player.field_6002).method_19494().method_19125(type -> type == poiType, player.method_24515(), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius"), class_4153.class_4155.field_18489).toList();
                player.method_7353((class_2561)TextOps.concat(Owo.PREFIX, (class_2561)TextOps.withColor("Found \u00a7" + entries.size() + " \u00a7entr" + (entries.size() == 1 ? "y" : "ies"), TextOps.color(class_124.field_1080), 12157951, TextOps.color(class_124.field_1080))), false);
                for (class_4156 entry : entries) {
                    class_2338 entryPos = entry.method_19141();
                    String blockId = class_2378.field_11146.method_10221((Object)player.field_6002.method_8320(entryPos).method_26204()).toString();
                    String posString = "(" + entryPos.method_10263() + " " + entryPos.method_10264() + " " + entryPos.method_10260() + ")";
                    class_5250 message = TextOps.withColor("-> \u00a7" + blockId + " \u00a7" + posString, TextOps.color(class_124.field_1080), 9745405, 9755391);
                    message.method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, "/tp " + entryPos.method_10263() + " " + entryPos.method_10264() + " " + entryPos.method_10260())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_30163((String)"Click to teleport"))));
                    player.method_7353((class_2561)message, false);
                }
                return entries.size();
            }))));
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"dumpfield").then(class_2170.method_9244((String)"field_name", (ArgumentType)StringArgumentType.string()).executes(context -> {
                String targetField = StringArgumentType.getString((CommandContext)context, (String)"field_name");
                class_2168 source = (class_2168)context.getSource();
                class_3222 player = source.method_9207();
                class_239 target = player.method_5745(5.0, 0.0f, false);
                if (target.method_17783() != class_239.class_240.field_1332) {
                    source.method_9213((class_2561)TextOps.concat(Owo.PREFIX, (class_2561)new class_2585("You're not looking at a block")));
                    return 1;
                }
                class_2338 pos = ((class_3965)target).method_17777();
                class_2586 blockEntity = player.method_14220().method_8321(pos);
                if (blockEntity == null) {
                    source.method_9213((class_2561)TextOps.concat(Owo.PREFIX, (class_2561)new class_2585("No block entity")));
                    return 1;
                }
                Class<?> blockEntityClass = blockEntity.getClass();
                try {
                    Field field = blockEntityClass.getDeclaredField(targetField);
                    if (!field.canAccess(blockEntity)) {
                        field.setAccessible(true);
                    }
                    Object value = field.get(blockEntity);
                    source.method_9226((class_2561)TextOps.concat(Owo.PREFIX, (class_2561)TextOps.withColor("Field value: \u00a7" + value, TextOps.color(class_124.field_1080), 9745405)), false);
                }
                catch (Exception e) {
                    source.method_9213((class_2561)TextOps.concat(Owo.PREFIX, (class_2561)new class_2585("Could not access field - " + e.getClass().getSimpleName() + ": " + e.getMessage())));
                }
                return 0;
            })));
        });
    }
}

