/*
 * Decompiled with CFR 0.152.
 */
package dev.onyxstudios.cca.internal.base;

import com.google.common.collect.Lists;
import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.internal.base.asm.StaticComponentLoadingException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class QualifiedComponentFactory<I> {
    private static final boolean DEV = Boolean.getBoolean("fabric.development");
    private final I factory;
    private final Class<? extends Component> impl;
    private final Set<ComponentKey<?>> dependencies;
    private SortingState sortingState = SortingState.UNSORTED;

    public QualifiedComponentFactory(I factory, Class<? extends Component> impl, Set<ComponentKey<?>> dependencies) {
        this.factory = factory;
        this.impl = impl;
        this.dependencies = dependencies;
    }

    public static <I> void checkNoDependencyCycles(Map<ComponentKey<?>, QualifiedComponentFactory<I>> factories) {
        if (DEV) {
            QualifiedComponentFactory.sort(factories);
        }
    }

    public static <I> Map<ComponentKey<?>, QualifiedComponentFactory<I>> sort(Map<ComponentKey<?>, QualifiedComponentFactory<I>> factories) {
        factories.values().forEach(f -> {
            f.sortingState = SortingState.UNSORTED;
        });
        List in = Lists.reverse(new ArrayList(factories.entrySet()));
        ArrayDeque out = new ArrayDeque();
        while (!in.isEmpty()) {
            QualifiedComponentFactory.visitComponentNode(in, (Map.Entry)in.get(0), out);
        }
        return out.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (c1, c2) -> c1, LinkedHashMap::new));
    }

    public static <I> void checkDependenciesSatisfied(Map<ComponentKey<?>, QualifiedComponentFactory<I>> factories) {
        StaticComponentLoadingException ex = null;
        for (Map.Entry<ComponentKey<?>, QualifiedComponentFactory<I>> checked : factories.entrySet()) {
            for (ComponentKey<?> dependency : checked.getValue().dependencies()) {
                if (factories.containsKey(dependency)) continue;
                StaticComponentLoadingException ex1 = new StaticComponentLoadingException("Unsatisfied dependency for " + checked.getKey() + ": " + dependency);
                if (ex == null) {
                    ex = ex1;
                    continue;
                }
                ex.addSuppressed(ex1);
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    private static <I> void visitComponentNode(List<Map.Entry<ComponentKey<?>, QualifiedComponentFactory<I>>> factories, Map.Entry<ComponentKey<?>, QualifiedComponentFactory<I>> node, Deque<Map.Entry<ComponentKey<?>, QualifiedComponentFactory<I>>> out) {
        switch (node.getValue().sortingState) {
            case SORTED: {
                break;
            }
            case SORTING: {
                throw new StaticComponentLoadingException("Circular dependency detected: " + node.getKey());
            }
            case UNSORTED: {
                node.getValue().sortingState = SortingState.SORTING;
                try {
                    for (Map.Entry dependant : factories.stream().filter(entry -> ((QualifiedComponentFactory)entry.getValue()).dependencies().contains(node.getKey())).toList()) {
                        QualifiedComponentFactory.visitComponentNode(factories, dependant, out);
                    }
                }
                catch (StaticComponentLoadingException e) {
                    throw new StaticComponentLoadingException(e.getMessage() + " <- " + node.getKey());
                }
                factories.remove(node);
                node.getValue().sortingState = SortingState.SORTED;
                out.addFirst(node);
            }
        }
    }

    public I factory() {
        return this.factory;
    }

    public Class<? extends Component> impl() {
        return this.impl;
    }

    public Set<ComponentKey<?>> dependencies() {
        return this.dependencies;
    }

    public String toString() {
        return "QualifiedComponentFactory[factory=" + this.factory + ", impl=" + this.impl + ", dependencies=" + this.dependencies + "]";
    }

    static enum SortingState {
        UNSORTED,
        SORTING,
        SORTED;

    }
}

