/*
 * Decompiled with CFR 0.152.
 */
package dev.onyxstudios.cca.internal.base;

import dev.onyxstudios.cca.api.v3.component.ComponentContainer;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistry;
import dev.onyxstudios.cca.api.v3.component.CopyableComponent;
import dev.onyxstudios.cca.internal.base.ComponentsInternals;
import java.util.Iterator;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public abstract class AbstractComponentContainer
implements ComponentContainer {
    public static final String NBT_KEY = "cardinal_components";

    @Override
    public void copyFrom(ComponentContainer other) {
        for (ComponentKey<?> key : this.keys()) {
            Object theirs = key.getInternal(other);
            Object ours = key.getInternal(this);
            assert (ours != null);
            if (theirs == null || ours.equals(theirs)) continue;
            if (ours instanceof CopyableComponent) {
                CopyableComponent copyable = (CopyableComponent)ours;
                copyable.copyFrom(theirs);
                continue;
            }
            class_2487 tag = new class_2487();
            theirs.writeToNbt(tag);
            ours.readFromNbt(tag);
        }
    }

    @Override
    public void fromTag(class_2487 tag) {
        block5: {
            block4: {
                if (!tag.method_10573(NBT_KEY, 9)) break block4;
                class_2499 componentList = tag.method_10554(NBT_KEY, 10);
                for (int i = 0; i < componentList.size(); ++i) {
                    Object component;
                    class_2487 nbt = componentList.method_10602(i);
                    ComponentKey<?> type = ComponentRegistry.get(new class_2960(nbt.method_10558("componentId")));
                    if (type == null || (component = type.getInternal(this)) == null) continue;
                    component.readFromNbt(nbt);
                }
                break block5;
            }
            if (!tag.method_10573(NBT_KEY, 10)) break block5;
            class_2487 componentMap = tag.method_10562(NBT_KEY);
            for (ComponentKey<?> key : this.keys()) {
                String keyId = key.getId().toString();
                if (!componentMap.method_10573(keyId, 10)) continue;
                Object component = key.getInternal(this);
                assert (component != null);
                component.readFromNbt(componentMap.method_10562(keyId));
                componentMap.method_10551(keyId);
            }
            for (String missedKeyId : componentMap.method_10541()) {
                class_2960 id = class_2960.method_12829((String)missedKeyId);
                String cause = id == null ? "invalid identifier" : (ComponentRegistry.get(id) == null ? "unregistered key" : "provider does not have ");
                ComponentsInternals.LOGGER.warn("Failed to deserialize component: {} {}", (Object)cause, (Object)missedKeyId);
            }
        }
    }

    @Override
    public class_2487 toTag(class_2487 tag) {
        if (this.hasComponents()) {
            class_2487 componentMap = null;
            class_2487 componentTag = new class_2487();
            for (ComponentKey<?> type : this.keys()) {
                Object component = type.getFromContainer(this);
                component.writeToNbt(componentTag);
                if (componentTag.method_33133()) continue;
                if (componentMap == null) {
                    componentMap = new class_2487();
                    tag.method_10566(NBT_KEY, (class_2520)componentMap);
                }
                componentMap.method_10566(type.getId().toString(), (class_2520)componentTag);
                componentTag = new class_2487();
            }
        }
        return tag;
    }

    public String toString() {
        Iterator<ComponentKey<?>> i = this.keys().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            ComponentKey<?> key = i.next();
            Object value = key.getInternal(this);
            sb.append(key);
            sb.append('=');
            sb.append(value);
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }
}

