/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.confabricate.typeserializers;

import ca.stellardrift.confabricate.typeserializers.ConfabricateTag;
import ca.stellardrift.confabricate.typeserializers.IdentifierSerializer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.tag.TagRegistry;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_5414;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

final class TagSerializer<V>
implements TypeSerializer<class_3494<V>> {
    private final class_2378<V> registry;
    private final Supplier<class_5414<V>> tags;
    private static final String TAG_PREFIX = "#";
    private static final String ID = "id";
    private static final String REQUIRED = "required";

    TagSerializer(class_2378<V> registry, Supplier<class_5414<V>> tags) {
        this.registry = registry;
        this.tags = tags;
    }

    public class_3494<V> deserialize(@NonNull Type type, @NonNull ConfigurationNode value) throws SerializationException {
        if (value.isList()) {
            ImmutableList.Builder entries = ImmutableList.builder();
            for (ConfigurationNode child : value.childrenList()) {
                entries.add((Object)this.entryFromNode(child));
            }
            return new ConfabricateTag((List<class_3494.class_3496>)entries.build(), () -> this.registry, this.tags);
        }
        if (!value.isMap()) {
            String id = value.getString();
            return TagRegistry.create((class_2960)IdentifierSerializer.createIdentifier(id), this.tags);
        }
        String id = value.node(new Object[]{ID}).getString();
        boolean required = value.node(new Object[]{REQUIRED}).getBoolean();
        if (id == null) {
            throw new SerializationException("An ID is required");
        }
        if (required && id.startsWith(TAG_PREFIX)) {
            return TagRegistry.create((class_2960)IdentifierSerializer.createIdentifier(id.substring(1)), this.tags);
        }
        return new ConfabricateTag((List<class_3494.class_3496>)ImmutableList.of((Object)this.entryFromNode(value)), () -> this.registry, this.tags);
    }

    public void serialize(@NonNull Type type, @Nullable class_3494<V> obj, @NonNull ConfigurationNode value) throws SerializationException {
        if (obj == null) {
            value.set(null);
            return;
        }
        if (obj instanceof class_3494.class_5123) {
            value.set((Object)(TAG_PREFIX + ((class_3494.class_5123)obj).method_26791().toString()));
        } else if (obj instanceof ConfabricateTag) {
            ConfabricateTag tag = (ConfabricateTag)obj;
            if (value.childrenList().size() == tag.serializedForm().size()) {
                for (int i = 0; i < tag.serializedForm().size(); ++i) {
                    ConfigurationNode child = value.node(new Object[]{i});
                    try {
                        this.entryToNode(tag.serializedForm().get(i), child);
                        continue;
                    }
                    catch (SerializationException ex) {
                        ex.initPath(() -> ((ConfigurationNode)child).path());
                        throw ex;
                    }
                }
            } else {
                value.raw(null);
                for (class_3494.class_3496 entry : tag.serializedForm()) {
                    this.entryToNode(entry, value.appendListNode());
                }
            }
        } else {
            value.raw(null);
            for (Object element : obj.method_15138()) {
                IdentifierSerializer.toNode(this.registry.method_10221(element), value.appendListNode());
            }
        }
    }

    private class_3494.class_3496 entryFromNode(ConfigurationNode value) throws SerializationException {
        boolean required;
        String id;
        if (value.isMap()) {
            id = value.node(new Object[]{ID}).getString();
            required = value.node(new Object[]{REQUIRED}).getBoolean();
        } else {
            id = value.getString();
            required = true;
        }
        if (id == null) {
            throw new SerializationException("a tag id field is required to deserialize");
        }
        if (id.startsWith(TAG_PREFIX)) {
            class_2960 ident = new class_2960(id.substring(1));
            return required ? new class_3494.class_3497(ident) : new class_3494.class_5480(ident);
        }
        class_2960 ident = new class_2960(id);
        return required ? new class_3494.class_5122(ident) : new class_3494.class_5479(ident);
    }

    private void entryToNode(class_3494.class_3496 entry, ConfigurationNode target) throws SerializationException {
        if (entry instanceof class_3494.class_5122) {
            entry.method_26790(id -> null, id -> {
                target.raw((Object)id.toString());
                return null;
            }, val -> {});
        } else if (entry instanceof class_3494.class_5479) {
            entry.method_26790(id -> null, id -> {
                target.node(new Object[]{ID}).raw((Object)id.toString());
                target.node(new Object[]{REQUIRED}).raw((Object)false);
                return null;
            }, val -> {});
        } else if (entry instanceof class_3494.class_3497) {
            entry.method_26790(id -> {
                target.raw((Object)(TAG_PREFIX + id.toString()));
                return null;
            }, id -> null, val -> {});
        } else if (entry instanceof class_3494.class_5480) {
            entry.method_26790(id -> {
                target.node(new Object[]{ID}).raw((Object)(TAG_PREFIX + id.toString()));
                target.node(new Object[]{REQUIRED}).raw((Object)false);
                return null;
            }, id -> null, val -> {});
        }
        throw new SerializationException("Unknown tag entry type " + entry);
    }

    public class_3494<V> emptyValue(Type specificType, ConfigurationOptions options) {
        return class_3494.method_26777((Set)ImmutableSet.of());
    }
}

