/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.confabricate.typeserializers;

import ca.stellardrift.confabricate.mixin.FluidTagsAccessor;
import ca.stellardrift.confabricate.typeserializers.IdentifierSerializer;
import ca.stellardrift.confabricate.typeserializers.RegistrySerializer;
import ca.stellardrift.confabricate.typeserializers.TagSerializer;
import ca.stellardrift.confabricate.typeserializers.TextSerializer;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeFactory;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_3483;
import net.minecraft.class_3489;
import net.minecraft.class_3494;
import net.minecraft.class_3611;
import net.minecraft.class_5414;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.extra.dfu.v4.ConfigurateOps;
import org.spongepowered.configurate.extra.dfu.v4.DfuSerializers;
import org.spongepowered.configurate.gson.GsonConfigurationLoader;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;

public final class MinecraftSerializers {
    private static final ImmutableSet<class_2378<?>> SPECIAL_REGISTRIES = ImmutableSet.of((Object)class_2378.field_11158, (Object)class_2378.field_11154, (Object)class_2378.field_11146, (Object)class_2378.field_11142, (Object)class_2378.field_11145);
    @LazyInit
    private static Set<Map.Entry<Type, TypeSerializer<?>>> KNOWN_REGISTRIES;
    private static final TypeToken<class_2378<?>> TYPE_REGISTRY_GENERIC;
    private static final Logger LOGGER;
    @LazyInit
    private static TypeSerializerCollection MINECRAFT_COLLECTION;
    @LazyInit
    private static ConfigurateOps DEFAULT_OPS;

    private MinecraftSerializers() {
    }

    static DynamicOps<ConfigurationNode> opsFor(ConfigurationNode node) {
        if (node.options().serializers().equals((Object)MINECRAFT_COLLECTION)) {
            @Nullable ConfigurateOps ops = DEFAULT_OPS;
            if (ops == null) {
                DEFAULT_OPS = ConfigurateOps.builder().factoryFromSerializers(MinecraftSerializers.collection()).readWriteProtection(ConfigurateOps.Protection.NONE).build();
                return DEFAULT_OPS;
            }
            return DEFAULT_OPS;
        }
        return ConfigurateOps.builder().factoryFromNode(node).readWriteProtection(ConfigurateOps.Protection.NONE).build();
    }

    public static <V> TypeSerializer<V> serializer(Codec<V> codec) {
        return DfuSerializers.serializer(codec);
    }

    public static <S> @Nullable Codec<S> codec(TypeToken<S> type) {
        return MinecraftSerializers.codec(type, MinecraftSerializers.collection());
    }

    public static <V> @Nullable Codec<V> codec(TypeToken<V> type, TypeSerializerCollection collection) {
        return DfuSerializers.codec(type, (TypeSerializerCollection)collection);
    }

    public static <T> TypeSerializer<T> forRegistry(class_2378<T> registry) {
        return new RegistrySerializer<T>(registry);
    }

    public static TypeSerializerCollection collection() {
        TypeSerializerCollection collection = MINECRAFT_COLLECTION;
        if (collection == null) {
            collection = MINECRAFT_COLLECTION = MinecraftSerializers.populate(TypeSerializerCollection.defaults().childBuilder()).build();
        }
        return collection;
    }

    public static boolean isCommonCollection(TypeSerializerCollection collection) {
        return Objects.requireNonNull(collection, "collection").equals((Object)MINECRAFT_COLLECTION);
    }

    private static boolean shouldRegister(class_2378<?> registry) {
        return !SPECIAL_REGISTRIES.contains(registry);
    }

    public static TypeSerializerCollection.Builder populate(TypeSerializerCollection.Builder collection) {
        collection.registerExact(class_2960.class, (TypeSerializer)IdentifierSerializer.INSTANCE).register(class_2561.class, TextSerializer.INSTANCE);
        for (Map.Entry<Type, TypeSerializer<?>> registry : MinecraftSerializers.knownRegistries()) {
            MinecraftSerializers.registerRegistry(collection, registry.getKey(), registry.getValue());
        }
        collection.register(class_1799.class, MinecraftSerializers.serializer(class_1799.field_24671));
        collection.register(class_2487.class, MinecraftSerializers.serializer(class_2487.field_25128));
        MinecraftSerializers.populateTaggedRegistry(collection, TypeToken.get(class_3611.class), class_2378.field_11154, () -> FluidTagsAccessor.getRequiredTags().method_26770());
        MinecraftSerializers.populateTaggedRegistry(collection, TypeToken.get(class_2248.class), class_2378.field_11146, class_3481::method_15073);
        MinecraftSerializers.populateTaggedRegistry(collection, new TypeToken<class_1299<?>>(){}, class_2378.field_11145, class_3483::method_15082);
        MinecraftSerializers.populateTaggedRegistry(collection, TypeToken.get(class_1792.class), class_2378.field_11142, class_3489::method_15106);
        collection.registerAll(GsonConfigurationLoader.gsonSerializers());
        return collection;
    }

    private static TypeSerializerCollection.Builder populateServer(MinecraftServer server, TypeSerializerCollection.Builder collection) {
        MinecraftSerializers.registerRegistry(collection, class_2874.class, MinecraftSerializers.forRegistry(server.method_30611().method_33309(class_2378.field_25095)));
        return collection;
    }

    @Environment(value=EnvType.CLIENT)
    private static TypeSerializerCollection.Builder populateClient(class_310 client, TypeSerializerCollection.Builder collection) {
        return collection;
    }

    private static Set<Map.Entry<Type, TypeSerializer<?>>> knownRegistries() {
        ImmutableSet registries = KNOWN_REGISTRIES;
        if (registries == null) {
            ImmutableSet.Builder accumulator = ImmutableSet.builder();
            for (Field registryField : class_2378.class.getFields()) {
                if ((registryField.getModifiers() & 9) != 9) continue;
                Type fieldType = registryField.getGenericType();
                if (!GenericTypeReflector.isSuperType((Type)TYPE_REGISTRY_GENERIC.getType(), (Type)fieldType)) continue;
                Type elementType = ((ParameterizedType)fieldType).getActualTypeArguments()[0];
                try {
                    class_2378 registry = (class_2378)registryField.get(null);
                    if (!MinecraftSerializers.shouldRegister(registry)) continue;
                    accumulator.add(new AbstractMap.SimpleImmutableEntry(elementType, MinecraftSerializers.forRegistry(registry)));
                    LOGGER.debug("Created serializer for Minecraft registry {} with element type {}", (Object)registry, (Object)elementType);
                }
                catch (IllegalAccessException e) {
                    LOGGER.error("Unable to create serializer for registry of type {} due to access error", (Object)elementType, (Object)e);
                }
            }
            registries = KNOWN_REGISTRIES = accumulator.build();
        }
        return registries;
    }

    private static void registerRegistry(TypeSerializerCollection.Builder collection, Type type, TypeSerializer<?> registry) {
        collection.registerExact(TypeToken.get((Type)type), registry);
    }

    private static <T> void populateTaggedRegistry(TypeSerializerCollection.Builder collection, TypeToken<T> token, class_2378<T> registry, Supplier<class_5414<T>> tagRegistry) {
        Type tagType = TypeFactory.parameterizedClass(class_3494.class, (Type[])new Type[]{token.getType()});
        collection.registerExact(TypeToken.get((Type)tagType), new TagSerializer<T>(registry, tagRegistry));
        collection.registerExact(token, new RegistrySerializer<T>(registry));
    }

    static {
        TYPE_REGISTRY_GENERIC = new TypeToken<class_2378<?>>(){};
        LOGGER = LogManager.getLogger();
    }
}

