/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.confabricate;

import ca.stellardrift.confabricate.typeserializers.MinecraftSerializers;
import com.google.errorprone.annotations.RestrictedApi;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Dynamic;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_155;
import net.minecraft.class_2960;
import net.minecraft.class_3551;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.extra.dfu.v4.ConfigurateOps;
import org.spongepowered.configurate.extra.dfu.v4.DataFixerTransformation;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.loader.ConfigurationLoader;
import org.spongepowered.configurate.reference.ConfigurationReference;
import org.spongepowered.configurate.reference.WatchServiceListener;
import org.spongepowered.configurate.transformation.ConfigurationTransformation;
import org.spongepowered.configurate.transformation.TransformAction;

public class Confabricate
implements ModInitializer {
    static final String MOD_ID = "confabricate";
    static final Logger LOGGER = LogManager.getLogger();
    private static WatchServiceListener listener;

    @RestrictedApi(explanation="confabricate namespace is not open to others", link="", allowedOnPath=".*/ca/stellardrift/confabricate/.*")
    public static class_2960 id(String item) {
        return new class_2960(MOD_ID, item);
    }

    public void onInitialize() {
        MinecraftSerializers.collection();
    }

    public static ConfigurationOptions confabricateOptions() {
        return ConfigurationOptions.defaults().serializers(MinecraftSerializers.collection());
    }

    public static ConfigurationLoader<CommentedConfigurationNode> loaderFor(ModContainer mod) {
        return Confabricate.loaderFor(mod, true);
    }

    public static ConfigurationLoader<CommentedConfigurationNode> loaderFor(ModContainer mod, boolean ownDirectory) {
        return Confabricate.loaderFor(mod, ownDirectory, Confabricate.confabricateOptions());
    }

    public static ConfigurationLoader<CommentedConfigurationNode> loaderFor(ModContainer mod, boolean ownDirectory, ConfigurationOptions options) {
        return ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(Confabricate.configurationFile(mod, ownDirectory))).defaultOptions(options)).build();
    }

    public static ConfigurationReference<CommentedConfigurationNode> configurationFor(ModContainer mod) throws ConfigurateException {
        return Confabricate.configurationFor(mod, true);
    }

    public static ConfigurationReference<CommentedConfigurationNode> configurationFor(ModContainer mod, boolean ownDirectory) throws ConfigurateException {
        return Confabricate.configurationFor(mod, ownDirectory, Confabricate.confabricateOptions());
    }

    public static ConfigurationReference<CommentedConfigurationNode> configurationFor(ModContainer mod, boolean ownDirectory, ConfigurationOptions options) throws ConfigurateException {
        return Confabricate.fileWatcher().listenToConfiguration(path -> ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(path)).defaultOptions(options)).build(), Confabricate.configurationFile(mod, ownDirectory));
    }

    public static Path configurationFile(ModContainer mod, boolean ownDirectory) {
        Path configRoot = FabricLoader.getInstance().getConfigDir();
        if (ownDirectory) {
            configRoot = configRoot.resolve(mod.getMetadata().getId());
        }
        try {
            Files.createDirectories(configRoot, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return configRoot.resolve(mod.getMetadata().getId() + ".conf");
    }

    public static ConfigurationTransformation createTransformation(DataFixer fixer, DSL.TypeReference reference, int targetVersion, Object ... versionKey) {
        return ConfigurationTransformation.builder().addAction(NodePath.path(), Confabricate.createTransformAction(fixer, reference, targetVersion, versionKey)).build();
    }

    public static TransformAction createTransformAction(DataFixer fixer, DSL.TypeReference reference, int targetVersion, Object ... versionKey) {
        return (inputPath, valueAtPath) -> {
            int currentVersion = valueAtPath.node(versionKey).getInt(-1);
            Dynamic dyn = ConfigurateOps.wrap((ConfigurationNode)valueAtPath);
            valueAtPath.set(fixer.update(reference, dyn, currentVersion, targetVersion).getValue());
            return null;
        };
    }

    public static WatchServiceListener fileWatcher() {
        WatchServiceListener ret = listener;
        if (ret == null) {
            throw new IllegalStateException("Configurate file watcher failed to initialize, check log for earlier errors");
        }
        return ret;
    }

    public static DataFixerTransformation.Builder minecraftDfuBuilder() {
        return DataFixerTransformation.dfuBuilder().versionKey(new Object[]{"minecraft-data-version"}).dataFixer(class_3551.method_15450()).targetVersion(class_155.method_16673().getWorldVersion());
    }

    static {
        try {
            listener = WatchServiceListener.create();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    listener.close();
                }
                catch (IOException e) {
                    LOGGER.catching((Throwable)e);
                }
            }, "Confabricate shutdown thread"));
        }
        catch (IOException e) {
            LOGGER.error("Could not initialize file listener", (Throwable)e);
        }
    }
}

