/*
 * Decompiled with CFR 0.152.
 */
package com.eliotlash.molang.expressions;

import com.eliotlash.mclib.math.Constant;
import com.eliotlash.mclib.math.IValue;
import com.eliotlash.mclib.math.Operation;
import com.eliotlash.molang.MolangParser;
import com.eliotlash.molang.expressions.MolangValue;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;

public abstract class MolangExpression
implements IValue {
    public MolangParser context;

    public static boolean isZero(MolangExpression expression) {
        return MolangExpression.isConstant(expression, 0.0);
    }

    public static boolean isOne(MolangExpression expression) {
        return MolangExpression.isConstant(expression, 1.0);
    }

    public static boolean isConstant(MolangExpression expression, double x) {
        if (expression instanceof MolangValue) {
            MolangValue value = (MolangValue)expression;
            return value.value instanceof Constant && Operation.equals((double)value.value.get(), (double)x);
        }
        return false;
    }

    public static boolean isExpressionConstant(MolangExpression expression) {
        if (expression instanceof MolangValue) {
            MolangValue value = (MolangValue)expression;
            return value.value instanceof Constant;
        }
        return false;
    }

    public MolangExpression(MolangParser context) {
        this.context = context;
    }

    public JsonElement toJson() {
        return new JsonPrimitive(this.toString());
    }
}

