/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts.entity;

import com.yahoo.chirpycricket.mythicmounts.ActionResultHelper;
import com.yahoo.chirpycricket.mythicmounts.config.Settings;
import com.yahoo.chirpycricket.mythicmounts.entity.MountData;
import com.yahoo.chirpycricket.mythicmounts.entity.ai.MountAnimationManager;
import com.yahoo.chirpycricket.mythicmounts.entity.ai.MountGoals;
import com.yahoo.chirpycricket.mythicmounts.items.SummoningStaff;
import com.yahoo.chirpycricket.mythicmounts.registery.Entities;
import com.yahoo.chirpycricket.mythicmounts.registery.Sounds;
import com.yahoo.chirpycricket.mythicmounts.screen.MountScreenHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1366;
import net.minecraft.class_1374;
import net.minecraft.class_1387;
import net.minecraft.class_1429;
import net.minecraft.class_1496;
import net.minecraft.class_1498;
import net.minecraft.class_1548;
import net.minecraft.class_1571;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3908;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class MountEntity
extends class_1498
implements IAnimatable,
ExtendedScreenHandlerFactory,
class_1263 {
    public Entities.EntityKey mountKey;
    protected Settings.EntitySettings settings;
    protected class_1792[] breedingItems = new class_1792[]{class_1802.field_8071};
    protected class_1792[] foodItems = new class_1792[0];
    protected class_1792[] tamingItems = new class_1792[0];
    public class_2248[] seekingBlocks = new class_2248[0];
    protected boolean canFly = false;
    public boolean shouldSwim = true;
    public boolean shouldSwimInLava = true;
    public boolean canWalkOnPowderedSnow = false;
    protected int inventoryColumns = 3;
    protected int maxInventoryColumns = 9;
    public float childScale = 0.5f;
    public float childHeadScale = 1.25f;
    public float leashYOffset = 0.5f;
    public float sittingLeashYOffset = 0.25f;
    public float leashZOffset = 0.4f;
    public float childLeashZOffset = 1.0f;
    public float tamingChance = 0.33f;
    protected Predicate<class_1309> PREY_PREDICATE;
    protected Predicate<class_1309> PLAYER_PREDICATE;
    protected Predicate<class_1309> ATTACKER_PREDICATE;
    int clickTimer = 0;
    int flapTimer = 0;
    int tickCount = 0;
    boolean playerLastRidingState = false;
    int walkCounter = 0;
    int maxWalkTime = (int)(500.0 + Math.random() * 5000.0);
    int sitCounter = 0;
    int maxSitTime = (int)(100.0 + Math.random() * 1000.0);
    int sleepCounter = 0;
    int maxSleepTime = (int)(100.0 + Math.random() * 1000.0);
    boolean wakeUp = false;
    public MountAnimationManager mountAnimationManager;
    public final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public float soundVolume = 1.0f;
    private static final class_2940<Boolean> IS_ATTACKING = class_2945.method_12791(MountEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_SITTING = class_2945.method_12791(MountEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> OWNER_TOLD_TO_SIT = class_2945.method_12791(MountEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_SLEEPING = class_2945.method_12791(MountEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_FLYING = class_2945.method_12791(MountEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_CLIMBING = class_2945.method_12791(MountEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> CHEST;
    private static final class_2940<Boolean> SHOULDFOLLOW;
    private static final class_2940<Boolean> HAS_TRACKED_POS;
    private static final class_2940<String> TEXTURE_VARIANT;
    private static final class_2940<Integer> TRACKED_POS_X;
    private static final class_2940<Integer> TRACKED_POS_Y;
    private static final class_2940<Integer> TRACKED_POS_Z;
    protected String armorTextureBaseStr = "";
    public ArrayList<String> textures = new ArrayList();

    public MountEntity(class_1299<? extends class_1498> type, class_1937 worldIn, Entities.EntityKey mountKey) {
        super(type, worldIn);
        this.init(mountKey, true, true);
    }

    public MountEntity(class_1299<? extends class_1498> type, class_1937 worldIn, Entities.EntityKey mountKey, boolean shouldSwim) {
        super(type, worldIn);
        this.init(mountKey, shouldSwim, true);
    }

    public MountEntity(class_1299<? extends class_1498> type, class_1937 worldIn, Entities.EntityKey mountKey, boolean shouldSwim, boolean shouldSwimInLava) {
        super(type, worldIn);
        this.init(mountKey, shouldSwim, shouldSwimInLava);
    }

    private void init(Entities.EntityKey mountKey, boolean shouldSwim, boolean shouldSwimInLava) {
        this.setHasChest(false);
        this.method_6721();
        this.mountKey = mountKey;
        this.settings = Settings.settings.get((Object)mountKey);
        this.mountAnimationManager = new MountAnimationManager(this);
        this.shouldSwim = shouldSwim;
        this.shouldSwimInLava = shouldSwimInLava;
        this.inventoryColumns = this.settings.inventorySize;
        this.breedingItems = this.settings.breedingItems;
        this.foodItems = this.settings.foodItems;
        this.tamingItems = this.settings.tamingItems;
        this.tamingChance = (float)this.settings.tamingChance / 100.0f;
        this.seekingBlocks = new class_2248[this.settings.seekingBlocks.length];
        for (int i = 0; i < this.seekingBlocks.length; ++i) {
            this.seekingBlocks[i] = (class_2248)class_2378.field_11146.method_10223(class_2960.method_12829((String)this.settings.seekingBlocks[i]));
        }
        this.soundVolume = (float)(this.settings.volume / 100.0);
        this.method_5834(this.settings.spawnDebug || Settings.globalSettings.debug);
        this.initConfigurableGoals();
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1387((class_1496)this, 1.2));
        this.field_6201.method_6277(2, (class_1352)new MountGoals.MountSitGoal(this));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.0));
        this.field_6201.method_6277(2, (class_1352)new MountGoals.MountAnimalMateGoal((class_1429)this, 1.0, MountEntity.class));
        this.field_6201.method_6277(5, (class_1352)new class_1366((class_1314)this, 2.0, true));
        this.field_6201.method_6277(7, (class_1352)new MountGoals.MountWanderAroundGoal(this, 1.0, 500));
        this.field_6201.method_6277(14, (class_1352)new MountGoals.MountLookAtEntityGoal(this, class_1657.class, 20.0f));
        this.field_6201.method_6277(15, (class_1352)new MountGoals.MountLookAtEntityGoal(this, class_1309.class, 20.0f));
        this.field_6201.method_6277(16, (class_1352)new MountGoals.MountLookAroundGoal(this));
        this.field_6185.method_6277(9, (class_1352)new MountGoals.MountFollowOwnerGoal(this, 1.0, 10.0f, 2.0f, false));
    }

    public void initConfigurableGoals() {
        this.PREY_PREDICATE = livingEntity -> {
            if (this.method_6727()) {
                return false;
            }
            for (class_1299 c : this.settings.mobHostile) {
                if (!c.equals(livingEntity.method_5864())) continue;
                return true;
            }
            return false;
        };
        this.PLAYER_PREDICATE = livingEntity -> {
            if (this.method_6727()) {
                return false;
            }
            return livingEntity instanceof class_1657;
        };
        this.ATTACKER_PREDICATE = livingEntity -> {
            if (this.method_6727() && livingEntity == this.getOwner()) {
                return false;
            }
            return livingEntity == this.method_6065();
        };
        if (this.shouldSwim) {
            this.field_6201.method_6277(0, (class_1352)new MountGoals.MountSwimGoal(this));
        }
        if (this.settings.battleWithOwner) {
            this.field_6185.method_6277(2, (class_1352)new MountGoals.MountTrackOwnerAttackerGoal(this));
            this.field_6185.method_6277(2, (class_1352)new MountGoals.MountAttackWithOwnerGoal(this));
        }
        if (this.settings.playerHostile) {
            this.field_6185.method_6277(4, new MountGoals.MountFollowTargetIfTamedGoal<class_1657>(this, class_1657.class, true, this.PLAYER_PREDICATE));
        }
        if (this.settings.fleeFromPlayer) {
            this.field_6201.method_6277(5, new MountGoals.MountFleeGoal<class_1657>(this, class_1657.class, 16.0f, 2.0 * Settings.settings.get((Object)((Object)this.mountKey)).speed, 4.0 * Settings.settings.get((Object)((Object)this.mountKey)).speed));
        }
        if (this.settings.mobHostile.length > 0) {
            this.field_6185.method_6277(5, new MountGoals.MountFollowTargetIfTamedGoal<class_1309>(this, class_1309.class, false, this.PREY_PREDICATE));
        }
        if (this.settings.playerHostile || this.settings.mobHostile.length > 0 || this.settings.battleWithOwner) {
            this.field_6185.method_6277(3, new MountGoals.MountFollowTargetIfTamedGoal<class_1309>(this, class_1309.class, true, this.ATTACKER_PREDICATE));
            this.field_6185.method_6277(3, (class_1352)new MountGoals.MountRevengeGoal(this, new Class[0]));
        } else {
            this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.25));
        }
        if (this.settings.seekingBlocks.length > 0) {
            this.field_6201.method_6277(7, (class_1352)new MountGoals.MountGoToBlockGoal(this, 1.1, this.seekingBlocks));
            this.field_6201.method_6277(7, (class_1352)new MountGoals.LookAtBlockGoal(this, 5.0f, 0.5f));
        }
    }

    public boolean canAttackWithOwner(class_1309 target, class_1309 owner) {
        if (!(target instanceof class_1548) && !(target instanceof class_1571)) {
            if (target instanceof MountEntity) {
                MountEntity mountEntity = (MountEntity)target;
                return !mountEntity.method_6727() || mountEntity.method_6768() != owner.method_5667();
            }
            if (target instanceof class_1657 && owner instanceof class_1657 && !((class_1657)owner).method_7256((class_1657)target)) {
                return false;
            }
            if (target instanceof class_1496 && ((class_1496)target).method_6727()) {
                return false;
            }
            return !(target instanceof class_1321) || !((class_1321)target).method_6181();
        }
        return false;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (hand.ordinal() == 1) {
            return ActionResultHelper.fail;
        }
        class_1799 itemStack = player.method_5998(hand);
        class_1792 item = itemStack.method_7909();
        if (this.field_6002.field_9236) {
            boolean bl = this.isOwner((class_1309)player) || this.method_6727() || this.isTamingItem(itemStack) && !this.method_6727();
            return bl ? ActionResultHelper.consume : ActionResultHelper.pass;
        }
        this.setIsSleeping(false);
        if (this.method_6727()) {
            if (this.canEatFood(item) && this.method_6032() < this.method_6063() || this.method_6481(itemStack) && !this.method_6479() || this.isTamingItem(itemStack) && !this.method_6727()) {
                if (!player.method_7337()) {
                    itemStack.method_7934(1);
                }
                if (item.method_19264() != null) {
                    this.method_6025(item.method_19264().method_19230());
                } else {
                    this.method_6025(class_1802.field_8279.method_19264().method_19230());
                }
                this.field_6002.method_8421((class_1297)this, (byte)7);
                this.method_5783(class_3417.field_20614, this.method_6107(), 1.0f);
                if (this.method_6481(itemStack) && !this.method_6479()) {
                    this.method_6480(player);
                }
                return ActionResultHelper.success;
            }
            if (item == class_1802.field_8106 && !this.hasChest()) {
                if (!player.method_7337()) {
                    itemStack.method_7934(1);
                }
                this.setHasChest(true);
                this.method_6721();
                this.method_5783(Sounds.CHEST_EQUIPS, this.method_6107(), 1.0f);
                return ActionResultHelper.success;
            }
            if (item == class_1802.field_8868 && this.hasChest()) {
                if (!player.method_7337()) {
                    itemStack.method_7934(1);
                }
                this.dropChestInventory();
                this.method_6721();
                return ActionResultHelper.success;
            }
            if (player.method_5715()) {
                if (this.clickTimer == 0) {
                    this.method_5783(this.method_5994(), this.method_6107(), 1.5f);
                    this.field_6002.method_8421((class_1297)this, (byte)7);
                    this.showEmoteParticle(true);
                    this.clickTimer = 10;
                    return ActionResultHelper.success;
                }
                class_2680 state = this.field_6002.method_8320(this.method_24515());
                state.method_26196(this.field_6002, this.method_24515());
                player.method_17355((class_3908)this);
                return ActionResultHelper.success;
            }
            boolean shouldCommand = false;
            if (item instanceof SummoningStaff && itemStack.method_7969() != null) {
                UUID id = itemStack.method_7969().method_25926("Id");
                shouldCommand = this.method_5667().equals(id);
            }
            if ((item == Settings.globalSettings.commandItem || shouldCommand) && !this.getIsFlying()) {
                if (this.isOwner((class_1309)player)) {
                    if (!this.getIsSitting() && !this.getShouldFollow()) {
                        this.setShouldFollow(true);
                        this.resetWanderBehaviorCycle();
                        this.setIsSitting(false);
                        this.setIsSleeping(false);
                        player.method_7353((class_2561)new class_2588("message.mythicmounts.follow"), true);
                    } else if (!this.getIsSitting() && this.getShouldFollow() || this.getIsSitting() && !this.getShouldFollow()) {
                        this.setShouldFollow(false);
                        boolean shouldSit = !this.getOwnerToldToSit();
                        this.setOwnerToldToSit(shouldSit);
                        this.method_18800(0.0, 0.0, 0.0);
                        this.field_6189.method_6340();
                        this.method_5980(null);
                        if (this.getOwnerToldToSit()) {
                            player.method_7353((class_2561)new class_2588("message.mythicmounts.sit"), true);
                        } else {
                            player.method_7353((class_2561)new class_2588("message.mythicmounts.wander"), true);
                        }
                    }
                } else {
                    boolean shouldSit = !this.getOwnerToldToSit();
                    this.setOwnerToldToSit(shouldSit);
                    this.method_18800(0.0, 0.0, 0.0);
                    this.field_6189.method_6340();
                    this.method_5980(null);
                    if (this.getOwnerToldToSit()) {
                        player.method_7353((class_2561)new class_2588("message.mythicmounts.sit"), true);
                    } else {
                        player.method_7353((class_2561)new class_2588("message.mythicmounts.wander"), true);
                    }
                }
                return ActionResultHelper.success;
            }
        }
        if (!this.method_6727()) {
            class_1799 itemStack2 = player.method_5998(hand);
            if (this.isTamingItem(itemStack2) && !this.method_5782()) {
                if (!player.method_7337()) {
                    itemStack2.method_7934(1);
                }
                if (this.method_6755() > 0 && this.field_5974.nextDouble() <= (double)this.tamingChance) {
                    this.method_6749(this.method_6755() + 1);
                    this.method_6752(player);
                    this.method_18800(0.0, 0.0, 0.0);
                    this.showEmoteParticle(true);
                    this.field_6189.method_6340();
                    this.method_5980(null);
                    this.setIsSitting(true);
                } else {
                    this.field_6002.method_8421((class_1297)this, (byte)6);
                    this.showEmoteParticle(false);
                }
                return ActionResultHelper.success;
            }
            if (this.getIsFlying()) {
                return ActionResultHelper.pass;
            }
            if (this.getIsSitting() || this.getIsSleeping()) {
                this.setIsSitting(false);
                this.setIsSleeping(false);
            }
        }
        return super.method_5992(player, hand);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.field_6002.field_9236) {
            ++this.tickCount;
            this.tickCount %= 10000;
            if (this.method_5851() && !this.settings.spawnDebug && !Settings.globalSettings.debug) {
                this.method_5834(false);
            }
            if (this.playerLastRidingState && !this.method_5817()) {
                this.onDismounted();
            } else if (!this.playerLastRidingState && this.method_5817()) {
                this.onMounted();
            }
            this.playerLastRidingState = this.method_5817();
            this.setTrackedAttacking(this.method_6510());
            this.mountAnimationManager.tick();
            if (!this.field_6002.method_8608() && this.tickCount % 30 == 0 && (this.method_5782() || this.method_5765() || this.method_5934())) {
                this.setTrackedPos(this.method_24515());
            }
            if (this.getIsFlying()) {
                ++this.flapTimer;
                this.flapTimer %= 15;
                if (this.flapTimer == 0) {
                    this.playFlapSound();
                }
            }
            if (!this.field_6002.method_8608() && !this.method_5782()) {
                this.updateAnimationState();
            }
            if (this.clickTimer > 0) {
                --this.clickTimer;
            }
            if (this.getIsClimbing() && !this.method_5782()) {
                this.setIsClimbing(false);
            }
        }
    }

    public void resetWanderBehaviorCycle() {
        this.walkCounter = 0;
        this.sitCounter = 0;
        this.sleepCounter = 0;
        this.maxSitTime = (int)(100.0 + Math.random() * 1000.0);
        this.maxSleepTime = (int)(100.0 + Math.random() * 1000.0);
        this.maxWalkTime = (int)(500.0 + Math.random() * 5000.0);
    }

    public void updateAnimationState() {
        if (this.getShouldFollow()) {
            return;
        }
        if (!this.getIsFlying() && !this.method_6510()) {
            if (!this.getIsSitting() && !this.getIsSleeping()) {
                ++this.walkCounter;
                if (this.walkCounter > this.maxWalkTime && !this.method_5799() && !this.method_5771()) {
                    this.resetWanderBehaviorCycle();
                    this.setIsSitting(true);
                }
            } else if (this.getIsSitting() && !this.getIsSleeping()) {
                ++this.sitCounter;
                if (this.sitCounter > this.maxSitTime) {
                    this.resetWanderBehaviorCycle();
                    if (this.wakeUp) {
                        if (!this.getOwnerToldToSit()) {
                            this.setIsSitting(false);
                        }
                        this.wakeUp = false;
                    } else {
                        this.setIsSleeping(true);
                    }
                }
            } else if (this.getIsSleeping()) {
                ++this.sleepCounter;
                if (this.sleepCounter > this.maxSleepTime) {
                    this.resetWanderBehaviorCycle();
                    this.wakeUp = true;
                    this.setIsSitting(true);
                    this.setIsSleeping(false);
                }
            }
            if (this.method_5799() || this.method_5771() || this.method_6510() && !this.getOwnerToldToSit()) {
                this.resetWanderBehaviorCycle();
                if (this.getIsSitting()) {
                    this.setIsSitting(false);
                    this.setIsSleeping(false);
                }
            }
        }
    }

    public void registerControllers(AnimationData animationData) {
        this.mountAnimationManager.registerControllers(animationData);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public AnimationBuilder getRandomAnimation(String[] animations) {
        return new AnimationBuilder().addAnimation(animations[this.field_5974.nextInt(animations.length)], Boolean.valueOf(true));
    }

    public AnimationBuilder getNoneAnimation() {
        return new AnimationBuilder().addAnimation("animation.mount.none", Boolean.valueOf(true));
    }

    public AnimationBuilder getNeutralAnimation() {
        return new AnimationBuilder().addAnimation("animation.mount.neutral", Boolean.valueOf(true));
    }

    public AnimationBuilder getBlinkAnimation() {
        return new AnimationBuilder().addAnimation("animation.mount.blink", Boolean.valueOf(true));
    }

    public AnimationBuilder getWalkAnimation() {
        return new AnimationBuilder().addAnimation("animation.mount.walk", Boolean.valueOf(true));
    }

    public AnimationBuilder getSprintAnimation() {
        return new AnimationBuilder().addAnimation("animation.mount.sprint", Boolean.valueOf(true));
    }

    public AnimationBuilder getFlyAnimation() {
        return new AnimationBuilder().addAnimation("animation.mount.fly", Boolean.valueOf(true));
    }

    public AnimationBuilder getClimbAnimation() {
        return new AnimationBuilder().addAnimation("animation.mount.walk", Boolean.valueOf(true));
    }

    public AnimationBuilder getSittingAnimation() {
        return new AnimationBuilder().addAnimation("animation.mount.sit", Boolean.valueOf(true));
    }

    public AnimationBuilder getSleepingAnimation() {
        return new AnimationBuilder().addAnimation("animation.mount.sleep", Boolean.valueOf(true));
    }

    public AnimationBuilder getSitDownAnimation() {
        return new AnimationBuilder().addAnimation("animation.mount.sitdown", Boolean.valueOf(true));
    }

    public AnimationBuilder getStandupAnimation() {
        return new AnimationBuilder().addAnimation("animation.mount.standup", Boolean.valueOf(true));
    }

    public AnimationBuilder getGoToSleepAnimation() {
        return new AnimationBuilder().addAnimation("animation.mount.gotosleep", Boolean.valueOf(true));
    }

    public AnimationBuilder getWakeUpAnimation() {
        return new AnimationBuilder().addAnimation("animation.mount.wakeup", Boolean.valueOf(true));
    }

    public AnimationBuilder getSwimAnimation() {
        return this.getWalkAnimation();
    }

    public AnimationBuilder getIdleAnimation() {
        return this.getNoneAnimation();
    }

    public AnimationBuilder getSittingIdleAnimation() {
        return this.getIdleAnimation();
    }

    public AnimationBuilder getSleepingIdleAnimation() {
        return this.getWalkAnimation();
    }

    public AnimationBuilder getAttackAnimation() {
        return this.getWalkAnimation();
    }

    public class_238 method_5830() {
        return super.method_5830().method_1014(2.0);
    }

    protected float method_6107() {
        return 0.25f * this.soundVolume;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_14894, 0.5f, 1.0f);
    }

    protected void method_6723() {
        if (this.getIsFlying()) {
            this.playFlapSound();
        } else {
            this.playJumpSound2();
        }
    }

    protected void playJumpSound2() {
        this.method_5783(Sounds.JUMP, this.method_6107(), 1.0f);
    }

    protected void playFlapSound() {
        this.method_5783(Sounds.WING_FLAP, this.method_6107(), 1.0f);
    }

    protected void method_6761(class_2498 group) {
        this.method_5783(class_3417.field_14894, group.method_10597() * 0.15f, group.method_10599());
    }

    protected class_3414 method_28368() {
        return class_3417.field_20614;
    }

    protected class_3414 getLandSound() {
        return Sounds.JUMP;
    }

    protected class_3414 method_5994() {
        return class_3417.field_14615;
    }

    protected class_3414 method_6747() {
        return class_3417.field_14575;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14940;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14732;
    }

    public boolean method_6481(class_1799 stack) {
        return Arrays.asList(this.breedingItems).contains(stack.method_7909());
    }

    public boolean isTamingItem(class_1799 stack) {
        return Arrays.asList(this.tamingItems).contains(stack.method_7909());
    }

    public boolean isFoodItem(class_1799 stack) {
        return Arrays.asList(this.foodItems).contains(stack.method_7909());
    }

    protected boolean method_6734() {
        return !this.method_5782() && !this.method_5765() && this.method_6727() && !this.method_6109() && this.method_6032() >= this.method_6063() && this.method_6479();
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        MountEntity childEntity = (MountEntity)entity.method_5864().method_5883((class_1937)world);
        if (childEntity != null) {
            this.method_6743(entity, (class_1496)childEntity);
            childEntity.setVariant(childEntity.getRandomTexture());
        }
        return childEntity;
    }

    public boolean method_6474(class_1429 other) {
        if (other == this) {
            return false;
        }
        if (!(other instanceof MountEntity)) {
            return false;
        }
        if (other.method_5864() != this.method_5864()) {
            return false;
        }
        return this.method_6734() && ((MountEntity)other).method_6734();
    }

    public void method_7217(boolean baby) {
        super.method_7217(baby);
        if (baby) {
            this.method_5857(this.method_18377(this.method_18376()).method_18383(this.childScale).method_30757(this.method_19538()));
        } else {
            this.method_5857(this.method_18377(this.method_18376()).method_30757(this.method_19538()));
        }
    }

    public void method_5619() {
        super.method_5619();
        this.method_5857(this.method_18377(this.method_18376()).method_30757(this.method_19538()));
    }

    public static class_5132.class_5133 createMountAttributes(Entities.EntityKey mountKey) {
        float speed = MountEntity.calcSpeedStat(mountKey);
        return MountEntity.method_26828().method_26868(class_5134.field_23728, 1.0).method_26868(class_5134.field_23719, (double)speed).method_26868(class_5134.field_23720, (double)0.6f).method_26868(class_5134.field_23716, Settings.settings.get((Object)((Object)mountKey)).health).method_26868(class_5134.field_23721, Settings.settings.get((Object)((Object)mountKey)).attack);
    }

    protected void method_6001() {
        super.method_6001();
        Objects.requireNonNull(this.method_5996(class_5134.field_23716)).method_6192(Settings.settings.get((Object)((Object)this.mountKey)).health + (double)this.field_5974.nextInt(6) + (double)this.field_5974.nextInt(6));
        Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192((double)MountEntity.calcSpeedStat(this.mountKey));
        Objects.requireNonNull(this.method_5996(class_5134.field_23728)).method_6192(this.method_6774() * 1.25);
    }

    protected static float calcSpeedStat(Entities.EntityKey mountKey) {
        double minFactor;
        double min;
        double res = (Settings.settings.get((Object)((Object)mountKey)).speed + Math.random() * 0.3 + Math.random() * 0.3 + Math.random() * 0.3) * 0.25;
        if (res < (min = (Settings.settings.get((Object)((Object)mountKey)).speed + (minFactor = 0.5) * 0.3 + minFactor * 0.3 + minFactor * 0.3) * 0.25)) {
            res = min;
        }
        return (float)res;
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityTag) {
        if (!(entityData instanceof MountData)) {
            entityData = new MountData(this.getVariant(), false, false, false, false, false, 0, 0, 0);
        }
        MountData data = (MountData)((Object)entityData);
        data.read(this);
        if (this.getIsFlying()) {
            this.setOwnerToldToSit(false);
            this.setIsSitting(false);
            this.setIsSleeping(false);
        }
        return super.method_5943(world, difficulty, spawnReason, entityData, entityTag);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(IS_ATTACKING, (Object)false);
        this.field_6011.method_12784(IS_SITTING, (Object)false);
        this.field_6011.method_12784(OWNER_TOLD_TO_SIT, (Object)false);
        this.field_6011.method_12784(IS_SLEEPING, (Object)false);
        this.field_6011.method_12784(IS_FLYING, (Object)false);
        this.field_6011.method_12784(IS_CLIMBING, (Object)false);
        this.field_6011.method_12784(TEXTURE_VARIANT, (Object)"");
        this.field_6011.method_12784(HAS_TRACKED_POS, (Object)false);
        this.field_6011.method_12784(TRACKED_POS_X, (Object)0);
        this.field_6011.method_12784(TRACKED_POS_Y, (Object)0);
        this.field_6011.method_12784(TRACKED_POS_Z, (Object)0);
        this.field_6011.method_12784(CHEST, (Object)true);
        this.field_6011.method_12784(SHOULDFOLLOW, (Object)false);
    }

    public boolean getTrackedAttacking() {
        return (Boolean)this.field_6011.method_12789(IS_ATTACKING);
    }

    public void setTrackedAttacking(boolean attacking) {
        this.field_6011.method_12778(IS_ATTACKING, (Object)attacking);
    }

    public boolean getIsSitting() {
        return (Boolean)this.field_6011.method_12789(IS_SITTING);
    }

    public void setIsSitting(boolean setSitting) {
        this.field_6011.method_12778(IS_SITTING, (Object)setSitting);
    }

    public boolean getOwnerToldToSit() {
        return (Boolean)this.field_6011.method_12789(OWNER_TOLD_TO_SIT);
    }

    public void setOwnerToldToSit(boolean setSitting) {
        this.field_6011.method_12778(OWNER_TOLD_TO_SIT, (Object)setSitting);
        this.setIsSitting(setSitting);
    }

    public boolean getIsSleeping() {
        return (Boolean)this.field_6011.method_12789(IS_SLEEPING);
    }

    public void setIsSleeping(boolean setAsleep) {
        this.field_6011.method_12778(IS_SLEEPING, (Object)setAsleep);
        if (setAsleep && !this.getIsSitting()) {
            this.setIsSitting(true);
        }
    }

    public boolean method_6034() {
        return !this.method_6113() && !this.field_6002.method_8608() && !this.method_5987();
    }

    public boolean shouldMove() {
        return !this.getIsSitting();
    }

    public void printMovementStates() {
        System.out.println("Can Move: " + this.shouldMove() + "; Sitting: " + this.getIsSitting() + "; Sleeping: " + this.getIsSleeping() + "; Flying: " + this.getIsFlying());
    }

    public boolean getIsFlying() {
        return (Boolean)this.field_6011.method_12789(IS_FLYING);
    }

    public void setIsFlying(boolean flying) {
        this.field_6011.method_12778(IS_FLYING, (Object)flying);
    }

    public boolean getIsClimbing() {
        return (Boolean)this.field_6011.method_12789(IS_CLIMBING);
    }

    public void setIsClimbing(boolean setSitting) {
        this.field_6011.method_12778(IS_CLIMBING, (Object)setSitting);
    }

    public boolean getShouldFollow() {
        return (Boolean)this.field_6011.method_12789(SHOULDFOLLOW);
    }

    public void setShouldFollow(boolean shouldFollow) {
        this.field_6011.method_12778(SHOULDFOLLOW, (Object)shouldFollow);
    }

    public boolean hasChest() {
        return (Boolean)this.field_6011.method_12789(CHEST);
    }

    public void setHasChest(boolean hasChest) {
        this.field_6011.method_12778(CHEST, (Object)hasChest);
    }

    public String getTextureFile() {
        return this.getVariant();
    }

    public String getDefaultTexture() {
        return "direwolf_mount.png";
    }

    public String getArmorTextureFile() {
        Object texture = this.armorTextureBaseStr;
        if (this.method_6753()) {
            class_1792 equippedArmor = this.method_6786().method_7909();
            texture = equippedArmor.equals(class_1802.field_18138) || equippedArmor.equals(class_1802.field_8577) ? (String)texture + "_leather.png" : (equippedArmor.equals(class_1802.field_8578) || equippedArmor.equals(class_1802.field_8523) ? (String)texture + "_iron.png" : (equippedArmor.equals(class_1802.field_8560) || equippedArmor.equals(class_1802.field_8678) ? (String)texture + "_gold.png" : (equippedArmor.equals(class_1802.field_8807) || equippedArmor.equals(class_1802.field_8058) ? (String)texture + "_diamond.png" : (String)texture + "_other.png")));
        }
        return texture;
    }

    protected String getRandomTexture() {
        return this.textures.get(this.field_5974.nextInt(this.textures.size()));
    }

    public void setVariant(String variant) {
        this.field_6011.method_12778(TEXTURE_VARIANT, (Object)variant);
    }

    public String getVariant() {
        String res = (String)this.field_6011.method_12789(TEXTURE_VARIANT);
        if (res.length() <= 0 && !this.field_6002.method_8608()) {
            res = this.getRandomTexture();
            this.setVariant(res);
        }
        return res;
    }

    public Boolean getHasTrackedPos() {
        return (Boolean)this.field_6011.method_12789(HAS_TRACKED_POS);
    }

    public void setHasTrackedPos(boolean hasPos) {
        this.field_6011.method_12778(HAS_TRACKED_POS, (Object)hasPos);
    }

    public class_2382 getTrackedPos() {
        Integer posX = (Integer)this.field_6011.method_12789(TRACKED_POS_X);
        Integer posY = (Integer)this.field_6011.method_12789(TRACKED_POS_Y);
        Integer posZ = (Integer)this.field_6011.method_12789(TRACKED_POS_Z);
        return new class_2382(posX.intValue(), posY.intValue(), posZ.intValue());
    }

    protected void setTrackedPos(int x, int y, int z) {
        this.field_6011.method_12778(TRACKED_POS_X, (Object)x);
        this.field_6011.method_12778(TRACKED_POS_Y, (Object)y);
        this.field_6011.method_12778(TRACKED_POS_Z, (Object)z);
    }

    protected void setTrackedPos(class_2338 pos) {
        this.field_6011.method_12778(TRACKED_POS_X, (Object)pos.method_10263());
        this.field_6011.method_12778(TRACKED_POS_Y, (Object)pos.method_10264());
        this.field_6011.method_12778(TRACKED_POS_Z, (Object)pos.method_10260());
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10582("Variant", this.getVariant());
        tag.method_10556("HasTrackedPos", this.getHasTrackedPos().booleanValue());
        tag.method_10556("IsFlying", this.getIsFlying());
        tag.method_10556("ShouldFollow", this.getShouldFollow());
        tag.method_10556("IsClimbing", this.getIsClimbing());
        tag.method_10556("IsSitting", this.getIsSitting());
        tag.method_10556("OwnerToldToSit", this.getOwnerToldToSit());
        class_2382 trackedPos = this.getTrackedPos();
        tag.method_10569("TrackedPosX", trackedPos.method_10263());
        tag.method_10569("TrackedPosY", trackedPos.method_10264());
        tag.method_10569("TrackedPosZ", trackedPos.method_10260());
        tag.method_10556("ChestedHorse", this.hasChest());
        if (this.hasChest()) {
            class_2499 NbtList = new class_2499();
            for (int i = 2; i < this.field_6962.method_5439(); ++i) {
                class_1799 itemStack = this.field_6962.method_5438(i);
                if (itemStack.method_7960()) continue;
                class_2487 NbtCompound = new class_2487();
                NbtCompound.method_10567("Slot", (byte)i);
                itemStack.method_7953(NbtCompound);
                NbtList.add((Object)NbtCompound);
            }
            tag.method_10566("Items", (class_2520)NbtList);
        }
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setVariant(tag.method_10558("Variant"));
        this.setIsFlying(tag.method_10577("IsFlying"));
        this.setIsClimbing(tag.method_10577("IsClimbing"));
        this.setIsSitting(tag.method_10577("IsSitting"));
        this.setShouldFollow(tag.method_10577("ShouldFollow"));
        this.setOwnerToldToSit(tag.method_10577("OwnerToldToSit"));
        this.setHasTrackedPos(tag.method_10577("HasTrackedPos"));
        int x = tag.method_10550("TrackedPosX");
        int y = tag.method_10550("TrackedPosY");
        int z = tag.method_10550("TrackedPosZ");
        this.setTrackedPos(x, y, z);
        this.setHasChest(tag.method_10577("ChestedHorse"));
        if (this.hasChest()) {
            class_2499 NbtList = tag.method_10554("Items", 10);
            this.method_6721();
            for (int i = 0; i < NbtList.size(); ++i) {
                class_2487 NbtCompound = NbtList.method_10602(i);
                int j = NbtCompound.method_10571("Slot") & 0xFF;
                if (j < 2 || j >= this.field_6962.method_5439()) continue;
                this.field_6962.method_5447(j, class_1799.method_7915((class_2487)NbtCompound));
            }
        }
        this.method_6731();
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        this.setIsSleeping(false);
        this.setIsSitting(false);
        return super.method_5643(source, amount);
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        int i;
        if (fallDistance > 1.0f) {
            this.method_5783(this.getLandSound(), this.method_6107(), 1.0f);
        }
        if ((i = this.method_23329(fallDistance, damageMultiplier)) <= 0) {
            return false;
        }
        this.method_5643(class_1282.field_5868, i);
        if (this.method_5782()) {
            for (class_1297 entity : this.method_5736()) {
                entity.method_5643(class_1282.field_5868, (float)i);
            }
        }
        this.method_23328();
        return !this.canFly;
    }

    public void method_6091(class_243 movementInput) {
        if (this.getIsSitting()) {
            super.method_6091(class_243.field_1353);
        }
        super.method_6091(movementInput);
    }

    public boolean isBeingRidden() {
        return this.method_5782() && this.method_6727() && this.method_6725();
    }

    public boolean method_5624() {
        if (this.method_5642() != null) {
            return this.method_5642().method_5624();
        }
        return super.method_5624();
    }

    public boolean isOwner(class_1309 entity) {
        return entity.method_5667().equals(this.method_6768());
    }

    public class_1657 getOwner() {
        return this.method_6768() == null ? null : this.method_5770().method_18470(this.method_6768());
    }

    public boolean method_6752(class_1657 player) {
        super.method_6752(player);
        this.method_5980(null);
        this.setTrackedPos(this.method_24515());
        return true;
    }

    public boolean method_5979(class_1936 world, class_3730 spawnReason) {
        return true;
    }

    public boolean method_5957(class_4538 world) {
        return true;
    }

    protected int method_6750() {
        return 6 * this.maxInventoryColumns + 2;
    }

    public int getInventoryColumns() {
        return this.inventoryColumns;
    }

    public class_1277 getItemInventory() {
        return this.field_6962;
    }

    public void method_6722(class_1657 player) {
        if (!this.field_6002.field_9236 && (!this.method_5782() || this.method_5626((class_1297)player)) && this.method_6727()) {
            class_2680 state = this.field_6002.method_8320(this.method_24515());
            state.method_26196(this.field_6002, this.method_24515());
            player.method_17355((class_3908)this);
        }
    }

    protected void dropChestInventory() {
        if (this.field_6962 != null) {
            int a = 0;
            if (this.method_6753()) {
                ++a;
            }
            if (this.method_6725()) {
                ++a;
            }
            for (int i = a; i < this.field_6962.method_5439(); ++i) {
                class_1799 itemStack = this.field_6962.method_5438(i);
                if (!itemStack.method_7960() && !class_1890.method_8221((class_1799)itemStack)) {
                    this.method_5775(itemStack);
                }
                this.field_6962.method_5447(i, class_1799.field_8037);
            }
        }
        if (this.hasChest()) {
            this.method_5699(new class_1799((class_1935)class_1802.field_8106, 1), 1.0f);
            this.method_5783(Sounds.CHEST_EQUIPS, this.method_6107(), 1.0f);
        }
        this.setHasChest(false);
    }

    protected void method_6721() {
        class_1277 simpleInventory = this.field_6962;
        this.field_6962 = new class_1277(this.method_6750());
        if (simpleInventory != null) {
            simpleInventory.method_5488((class_1265)this);
            int i = Math.min(simpleInventory.method_5439(), this.field_6962.method_5439());
            for (int j = 0; j < i; ++j) {
                class_1799 itemStack = simpleInventory.method_5438(j);
                if (itemStack.method_7960()) continue;
                this.field_6962.method_5447(j, itemStack.method_7972());
            }
        }
        this.field_6962.method_5489((class_1265)this);
        this.method_6731();
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.writeInt(this.method_5628());
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new MountScreenHandler(syncId, playerInventory, this, this);
    }

    public int method_5439() {
        return this.field_6962.method_5439();
    }

    public boolean method_5442() {
        return this.field_6962.method_5442();
    }

    public class_1799 method_5438(int slot) {
        return this.field_6962.method_5438(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return this.field_6962.method_5434(slot, amount);
    }

    public class_1799 method_5441(int slot) {
        return this.field_6962.method_5441(slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.field_6962.method_5447(slot, stack);
    }

    public void method_5431() {
        this.field_6962.method_5431();
    }

    public boolean method_5443(class_1657 player) {
        return this.field_6962.method_5443(player);
    }

    public void method_5448() {
        this.field_6962.method_5448();
    }

    protected boolean canEatFood(class_1792 item) {
        return this.isTamingItem(item.method_7854()) || this.isFoodItem(item.method_7854()) || this.method_6481(item.method_7854());
    }

    protected void showEmoteParticle(boolean positive) {
        class_2400 particleEffect = class_2398.field_11201;
        if (!positive) {
            particleEffect = class_2398.field_11251;
        }
        for (int i = 0; i < 7; ++i) {
            double d = this.field_5974.nextGaussian() * 0.02;
            double e = this.field_5974.nextGaussian() * 0.02;
            double f = this.field_5974.nextGaussian() * 0.02;
            if (this.field_6002.method_8608()) continue;
            ((class_3218)this.field_6002).method_14199((class_2394)particleEffect, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), 1, d, e, f, 0.005);
        }
    }

    public void onDismounted() {
        class_2338 pos = this.method_24515();
        this.setTrackedPos(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public void onMounted() {
        this.setIsSitting(false);
        this.setIsSleeping(false);
        class_2338 pos = this.method_24515();
        this.setTrackedPos(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public void method_5865(class_1297 passenger) {
        if (!this.getIsClimbing()) {
            super.method_5865(passenger);
        } else {
            super.method_5865(passenger);
            float mobEntity = class_3532.method_15374((float)(this.field_6283 * ((float)Math.PI / 180)));
            float f = class_3532.method_15362((float)(this.field_6283 * ((float)Math.PI / 180)));
            passenger.method_5814(this.method_23317() + (double)(1.2f * mobEntity), this.method_23318() + this.method_5621() + passenger.method_5678() + (double)0.15f, this.method_23321() - (double)(1.2f * f));
            if (passenger instanceof class_1309) {
                ((class_1309)passenger).field_6283 = this.field_6283;
            }
        }
    }

    public class_243 getLeashAttachPoint() {
        class_243 attachPoint = new class_243(0.0, (double)this.method_5751() * (double)this.leashYOffset, (double)(this.method_17681() * this.leashZOffset));
        if (this.method_6109()) {
            attachPoint = new class_243(0.0, (double)this.method_5751() * (double)this.leashYOffset, (double)(this.method_17681() * this.leashZOffset * this.childLeashZOffset));
        }
        if (this.getIsSitting()) {
            attachPoint = new class_243(attachPoint.method_10216(), attachPoint.method_10214() * (double)this.sittingLeashYOffset, attachPoint.method_10215());
        }
        return attachPoint;
    }

    static {
        TEXTURE_VARIANT = class_2945.method_12791(MountEntity.class, (class_2941)class_2943.field_13326);
        HAS_TRACKED_POS = class_2945.method_12791(MountEntity.class, (class_2941)class_2943.field_13323);
        TRACKED_POS_X = class_2945.method_12791(MountEntity.class, (class_2941)class_2943.field_13327);
        TRACKED_POS_Y = class_2945.method_12791(MountEntity.class, (class_2941)class_2943.field_13327);
        TRACKED_POS_Z = class_2945.method_12791(MountEntity.class, (class_2941)class_2943.field_13327);
        CHEST = class_2945.method_12791(MountEntity.class, (class_2941)class_2943.field_13323);
        SHOULDFOLLOW = class_2945.method_12791(MountEntity.class, (class_2941)class_2943.field_13323);
    }
}

