/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts.client.renderer.entity;

import com.mojang.blaze3d.systems.RenderSystem;
import com.yahoo.chirpycricket.mythicmounts.client.renderer.entity.LeashRenderer;
import com.yahoo.chirpycricket.mythicmounts.client.renderer.model.AnimatedLivingEntityModel;
import com.yahoo.chirpycricket.mythicmounts.entity.MountEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1768;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_757;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoEntityRenderer;
import software.bernie.geckolib3.renderers.geo.GeoLayerRenderer;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;

public class MountRenderer
extends GeoEntityRenderer<MountEntity> {
    LeashRenderer leashRender;
    boolean glowing = false;

    public MountRenderer(class_5617.class_5618 renderManager, AnimatedGeoModel<MountEntity> modelProvider, float shadowRadius) {
        super(renderManager, modelProvider);
        this.field_4673 = shadowRadius;
        this.leashRender = new LeashRenderer(this);
        this.addLayer(new ArmorOverlayFeatureRenderer((IGeoRenderer<MountEntity>)this, new ArmorOverlayEntityRenderer(renderManager, modelProvider)));
    }

    public MountRenderer(class_5617.class_5618 renderManager, AnimatedGeoModel<MountEntity> modelProvider, float shadowRadius, boolean glow) {
        super(renderManager, modelProvider);
        this.field_4673 = shadowRadius;
        this.leashRender = new LeashRenderer(this);
        this.glowing = glow;
        this.addLayer(new ArmorOverlayFeatureRenderer((IGeoRenderer<MountEntity>)this, new ArmorOverlayEntityRenderer(renderManager, modelProvider)));
    }

    public void render(MountEntity entity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light) {
        if (this.glowing) {
            super.render((class_1309)entity, yaw, tickDelta, matrices, vertexConsumers, 255);
        } else {
            super.render((class_1309)entity, yaw, tickDelta, matrices, vertexConsumers, light);
        }
        class_1297 leashHolder = entity.method_5933();
        if (leashHolder != null) {
            this.leashRender.renderLeash(entity, tickDelta, matrices, vertexConsumers, leashHolder);
        }
    }

    public class_2960 getTexture(MountEntity entity) {
        String filename = entity.getTextureFile() != null && !entity.getTextureFile().equals("") ? "textures/model/entity/" + entity.getTextureFile() : "textures/model/entity/" + entity.getDefaultTexture();
        return new class_2960("mythicmounts", filename);
    }

    public int getBlockLight2(MountEntity mobEntity, class_2338 blockPos) {
        return this.method_24087((class_1297)mobEntity, blockPos);
    }

    public class ArmorOverlayFeatureRenderer
    extends GeoLayerRenderer<MountEntity> {
        private final ArmorOverlayEntityRenderer armorOverlayEntityRenderer;
        class_2960 armorTextureLocation;

        public ArmorOverlayFeatureRenderer(IGeoRenderer<MountEntity> entityRendererIn, ArmorOverlayEntityRenderer armorOverlayEntityRenderer) {
            super(entityRendererIn);
            this.armorTextureLocation = null;
            this.armorOverlayEntityRenderer = armorOverlayEntityRenderer;
        }

        public void render(class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn, MountEntity mountEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (mountEntity.method_6753()) {
                this.armorTextureLocation = new class_2960("mythicmounts", mountEntity.getArmorTextureFile());
                class_1792 equippedArmor = mountEntity.method_6786().method_7909();
                float a = 1.0f;
                float r = 1.0f;
                float g = 1.0f;
                float b = 1.0f;
                if (equippedArmor instanceof class_1768) {
                    class_1768 c = (class_1768)equippedArmor;
                    int m = c.method_7800(mountEntity.method_6786());
                    r = (float)(m >> 16 & 0xFF) / 255.0f;
                    g = (float)(m >> 8 & 0xFF) / 255.0f;
                    b = (float)(m & 0xFF) / 255.0f;
                }
                RenderSystem.setShader(class_757::method_34540);
                this.armorOverlayEntityRenderer.render(this.getEntityModel().getModel(new class_2960("mythicmounts", ((AnimatedLivingEntityModel)MountRenderer.this.getGeoModelProvider()).geoFile)), (Object)mountEntity, partialTicks, class_1921.method_23576((class_2960)this.armorTextureLocation), matrixStackIn, bufferIn, bufferIn.getBuffer(class_1921.method_23576((class_2960)this.armorTextureLocation)), packedLightIn, class_4608.field_21444, r, g, b, a);
            }
        }
    }

    public class ArmorOverlayEntityRenderer
    extends GeoEntityRenderer<MountEntity> {
        protected ArmorOverlayEntityRenderer(class_5617.class_5618 ctx, AnimatedGeoModel<MountEntity> modelProvider) {
            super(ctx, modelProvider);
        }
    }
}

