/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.registry;

import com.google.common.collect.Multimap;
import com.mojang.brigadier.CommandDispatcher;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.item.ICreativeTabBuilder;
import net.darkhax.bookshelf.api.registry.IRegistryEntries;
import net.darkhax.bookshelf.api.registry.RegistryHelper;
import net.darkhax.bookshelf.impl.item.CreativeTabBuilderFabric;
import net.darkhax.bookshelf.impl.resources.WrappedReloadListener;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_2168;
import net.minecraft.class_2314;
import net.minecraft.class_2316;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_3545;
import net.minecraft.class_3852;
import net.minecraft.class_3853;

public class RegistryHelperFabric
extends RegistryHelper {
    public RegistryHelperFabric(String ownerId) {
        super(ownerId);
    }

    @Override
    public ICreativeTabBuilder<?> createTabBuilder(String tabId) {
        return new CreativeTabBuilderFabric(new class_2960(this.ownerId, tabId));
    }

    @Override
    public void init() {
        this.consumeVanillaRegistry(this.blocks, (class_2378)class_2378.field_11146);
        this.consumeVanillaRegistry(this.items, (class_2378)class_2378.field_11142);
        this.consumeVanillaRegistry(this.enchantments, class_2378.field_11160);
        this.consumeVanillaRegistry(this.paintings, (class_2378)class_2378.field_11150);
        this.consumeVanillaRegistry(this.mobEffects, class_2378.field_11159);
        this.consumeVanillaRegistry(this.attributes, class_2378.field_23781);
        this.consumeVanillaRegistry(this.villagerProfessions, (class_2378)class_2378.field_17167);
        this.serverReloadListeners.getEntries().forEach((k, v) -> ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new WrappedReloadListener((class_2960)k, (class_3302)v)));
        if (Services.PLATFORM.isPhysicalClient()) {
            this.clientReloadListeners.getEntries().forEach((k, v) -> ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new WrappedReloadListener((class_2960)k, (class_3302)v)));
        }
        CommandRegistrationCallback.EVENT.register(this::buildCommands);
        this.registerTradeData();
        this.registerWanderingTrades();
        this.registerCommandArguments();
    }

    private void registerCommandArguments() {
        for (Map.Entry entry : this.commandArguments.getEntries().entrySet()) {
            class_2316.method_10017((String)entry.getKey().toString(), (Class)((Class)((class_3545)entry.getValue()).method_15442()), (class_2314)((class_2314)((class_3545)entry.getValue()).method_15441()));
        }
    }

    private void registerTradeData() {
        for (Map.Entry<class_3852, Multimap<Integer, class_3853.class_1652>> professionData : this.trades.getVillagerTrades().entrySet()) {
            Int2ObjectMap professionTrades = class_3853.field_17067.computeIfAbsent(professionData.getKey(), profession -> new Int2ObjectOpenHashMap());
            Iterator iterator = professionData.getValue().keySet().iterator();
            while (iterator.hasNext()) {
                int merchantTier = (Integer)iterator.next();
                ArrayList<class_3853.class_1652> tradesForTier = new ArrayList<class_3853.class_1652>(Arrays.asList((class_3853.class_1652[])professionTrades.getOrDefault(merchantTier, (Object)new class_3853.class_1652[0])));
                tradesForTier.addAll(professionData.getValue().get((Object)merchantTier));
                professionTrades.put(merchantTier, (Object)tradesForTier.toArray(new class_3853.class_1652[0]));
            }
        }
    }

    private void registerWanderingTrades() {
        ArrayList<class_3853.class_1652> tradeData;
        if (!this.trades.getCommonWanderingTrades().isEmpty()) {
            tradeData = new ArrayList<class_3853.class_1652>(Arrays.asList((class_3853.class_1652[])class_3853.field_17724.get(1)));
            tradeData.addAll(this.trades.getCommonWanderingTrades());
            class_3853.field_17724.put(1, (Object)tradeData.toArray(new class_3853.class_1652[0]));
        }
        if (!this.trades.getRareWanderingTrades().isEmpty()) {
            tradeData = new ArrayList<class_3853.class_1652>(Arrays.asList((class_3853.class_1652[])class_3853.field_17724.get(2)));
            tradeData.addAll(this.trades.getRareWanderingTrades());
            class_3853.field_17724.put(2, (Object)tradeData.toArray(new class_3853.class_1652[0]));
        }
    }

    private void buildCommands(CommandDispatcher<class_2168> dispatcher, boolean isDedicated) {
        this.commands.forEach(builder -> builder.build(dispatcher, isDedicated));
    }

    private <T> void consumeVanillaRegistry(IRegistryEntries<T> toRegister, class_2378<T> registry) {
        toRegister.getEntries().forEach((id, value) -> class_2378.method_10230((class_2378)registry, (class_2960)id, (Object)value));
    }
}

