/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.serialization.NBTParseException;
import net.darkhax.bookshelf.api.util.JSONHelper;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public interface ISerializer<T> {
    public T fromJSON(JsonElement var1);

    default public T fromJSON(JsonObject json, String memberName) {
        return this.fromJSON(json.get(memberName));
    }

    default public T fromJSON(JsonObject json, String memberName, T fallback) {
        return json.has(memberName) ? this.fromJSON(json, memberName) : fallback;
    }

    default public T fromJSON(JsonObject json, String memberName, Supplier<T> fallback) {
        return json.has(memberName) ? this.fromJSON(json, memberName) : fallback.get();
    }

    default public void toJSON(JsonObject json, String name, T toWrite) {
        json.add(name, this.toJSON(toWrite));
    }

    public JsonElement toJSON(T var1);

    public T fromByteBuf(class_2540 var1);

    public void toByteBuf(class_2540 var1, T var2);

    public class_2520 toNBT(T var1);

    public T fromNBT(class_2520 var1);

    default public T fromNBT(class_2487 tag, String name) {
        if (tag.method_10545(name)) {
            return this.fromNBT(tag.method_10580(name));
        }
        throw new NBTParseException("Required tag " + name + " was not present.");
    }

    default public T fromNBT(@Nullable class_2487 tag, String name, T fallback) {
        return tag != null && tag.method_10545(name) ? this.fromNBT(tag.method_10580(name)) : fallback;
    }

    default public void toNBT(class_2487 tag, String name, T toWrite) {
        tag.method_10566(name, this.toNBT(toWrite));
    }

    default public List<T> fromJSONList(JsonElement json) {
        ArrayList<T> list = new ArrayList<T>();
        if (json.isJsonArray()) {
            for (JsonElement element : json.getAsJsonArray()) {
                list.add(this.fromJSON(element));
            }
        } else {
            list.add(this.fromJSON(json));
        }
        return list;
    }

    default public List<T> fromJSONList(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return this.fromJSONList(json.get(memberName));
        }
        throw new JsonParseException("Expected member " + memberName + " was not found.");
    }

    default public List<T> fromJSONList(JsonObject json, String memberName, List<T> fallback) {
        return json.has(memberName) ? this.fromJSONList(json, memberName) : fallback;
    }

    default public List<T> fromJSONList(JsonObject json, String memberName, Supplier<List<T>> fallback) {
        return json.has(memberName) ? this.fromJSONList(json, memberName) : fallback.get();
    }

    default public JsonElement toJSONList(List<T> toWrite) {
        JsonArray json = new JsonArray();
        toWrite.forEach(t -> json.add(this.toJSON(t)));
        return json;
    }

    default public List<T> fromByteBufList(class_2540 buffer) {
        int size = buffer.readInt();
        ArrayList<T> list = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.fromByteBuf(buffer));
        }
        return list;
    }

    default public void toByteBufList(class_2540 buffer, List<T> toWrite) {
        buffer.writeInt(toWrite.size());
        toWrite.forEach(t -> this.toByteBuf(buffer, t));
    }

    default public Set<T> fromJSONSet(JsonElement json) {
        HashSet<T> set = new HashSet<T>();
        if (json.isJsonArray()) {
            for (JsonElement element : json.getAsJsonArray()) {
                set.add(this.fromJSON(element));
            }
        } else {
            set.add(this.fromJSON(json));
        }
        return set;
    }

    default public Set<T> fromJSONSet(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return this.fromJSONSet(json.get(memberName));
        }
        throw new JsonParseException("Expected member " + memberName + " was not found.");
    }

    default public Set<T> fromJSONSet(JsonObject json, String memberName, Set<T> fallback) {
        return json.has(memberName) ? this.fromJSONSet(json, memberName) : fallback;
    }

    default public Set<T> fromJSONSet(JsonObject json, String memberName, Supplier<Set<T>> fallback) {
        return json.has(memberName) ? this.fromJSONSet(json, memberName) : fallback.get();
    }

    default public JsonElement toJSONSet(Set<T> toWrite) {
        JsonArray json = new JsonArray();
        toWrite.forEach(t -> json.add(this.toJSON(t)));
        return json;
    }

    default public Set<T> readByteBufSet(class_2540 buffer) {
        int size = buffer.readInt();
        HashSet<T> set = new HashSet<T>(size);
        for (int i = 0; i < size; ++i) {
            set.add(this.fromByteBuf(buffer));
        }
        return set;
    }

    default public void writeByteBufSet(class_2540 buffer, Set<T> toWrite) {
        buffer.writeInt(toWrite.size());
        toWrite.forEach(t -> this.toByteBuf(buffer, t));
    }

    default public JsonElement fromJSONOptional(Optional<T> value) {
        return value.map(this::toJSON).orElse(null);
    }

    default public Optional<T> fromJSONOptional(JsonObject json, String memberName) {
        return json.has(memberName) ? Optional.of(this.fromJSON(json.get(memberName))) : Optional.empty();
    }

    default public void toJSONOptional(JsonObject json, String memberName, Optional<T> value) {
        value.ifPresent(v -> json.add(memberName, this.toJSON(v)));
    }

    default public Optional<T> fromByteBufOptional(class_2540 buffer) {
        return buffer.readBoolean() ? Optional.of(this.fromByteBuf(buffer)) : Optional.empty();
    }

    default public void toByteBufOptional(class_2540 buffer, Optional<T> optional) {
        boolean isPresent = optional.isPresent();
        buffer.writeBoolean(isPresent);
        if (isPresent) {
            this.toByteBuf(buffer, optional.get());
        }
    }

    default public String toJSONString(T toWrite) {
        return this.toJSON(toWrite).toString();
    }

    default public T fromJSONString(String jsonString) {
        return this.fromJSON(JSONHelper.getAsElement(jsonString));
    }
}

