/*
 * Decompiled with CFR 0.152.
 */
package net.barribob.maelstrom.static_utilities;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.barribob.maelstrom.MaelstromMod;
import net.barribob.maelstrom.general.event.TimedEvent;
import net.barribob.maelstrom.render.RenderData;
import net.barribob.maelstrom.static_utilities.PacketUtilsKt;
import net.barribob.maelstrom.static_utilities.RenderUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J*\u0010\u0014\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J.\u0010\u0015\u001a \u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00060\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0007\u00a8\u0006\u0017"}, d2={"Lnet/barribob/maelstrom/static_utilities/DebugPointsNetworkHandler;", "", "()V", "drawDebugPoints", "", "points", "", "Lnet/minecraft/util/math/Vec3d;", "time", "", "watchPoint", "world", "Lnet/minecraft/server/world/ServerWorld;", "color", "", "drawDebugPointsClient", "client", "Lnet/minecraft/client/MinecraftClient;", "packetData", "Lnet/minecraft/network/PacketByteBuf;", "packDrawDebugPoints", "unpackDrawDebugPoints", "Lkotlin/Triple;", "maelstrom-library"})
public final class DebugPointsNetworkHandler {
    public final void drawDebugPoints(@NotNull List<? extends class_243> points, int time, @NotNull class_243 watchPoint, @NotNull class_3218 world, @NotNull List<Float> color) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        Intrinsics.checkNotNullParameter((Object)watchPoint, (String)"watchPoint");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter(color, (String)"color");
        class_2540 packetData = this.packDrawDebugPoints(time, color, points);
        Collection collection = PlayerLookup.around((class_3218)world, (class_243)watchPoint, (double)100.0);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"around(world, watchPoint, 100.0)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_3222 it = (class_3222)element$iv;
            boolean bl = false;
            ServerPlayNetworking.send((class_3222)it, (class_2960)MaelstromMod.INSTANCE.getDRAW_POINTS_PACKET_ID(), (class_2540)packetData);
        }
    }

    public static /* synthetic */ void drawDebugPoints$default(DebugPointsNetworkHandler debugPointsNetworkHandler, List list, int n, class_243 class_2432, class_3218 class_32182, List list2, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            Object[] objectArray = new Float[]{Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)};
            list2 = CollectionsKt.listOf((Object[])objectArray);
        }
        debugPointsNetworkHandler.drawDebugPoints(list, n, class_2432, class_32182, list2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final class_2540 packDrawDebugPoints(int time, @NotNull List<Float> color, @NotNull List<? extends class_243> points) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Intrinsics.checkNotNullParameter(color, (String)"color");
        Intrinsics.checkNotNullParameter(points, (String)"points");
        if (color.size() != 4) {
            throw new IllegalArgumentException("Color needs to be defined with 4 floats");
        }
        class_2540 packetData = new class_2540(Unpooled.buffer());
        packetData.writeInt(time);
        packetData.writeInt(points.size());
        PacketUtilsKt.writeFloatList(packetData, color);
        Iterable iterable = points;
        class_2540 class_25402 = packetData;
        boolean $i$f$flatMap = false;
        void var7_8 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            class_243 it = (class_243)element$iv$iv;
            boolean bl = false;
            Object[] objectArray = new Double[]{it.field_1352, it.field_1351, it.field_1350};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            double list$iv$iv = ((Number)item$iv$iv).doubleValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Float.valueOf((float)p0));
        }
        PacketUtilsKt.writeFloatList(class_25402, (List)destination$iv$iv);
        return packetData;
    }

    @Environment(value=EnvType.CLIENT)
    @NotNull
    public final Triple<Integer, List<Float>, List<Float>> unpackDrawDebugPoints(@NotNull class_2540 packetData) {
        Intrinsics.checkNotNullParameter((Object)packetData, (String)"packetData");
        int delay = packetData.readInt();
        int numPoints = packetData.readInt();
        List<Float> colorArray = PacketUtilsKt.readFloatList(packetData, 4);
        List<Float> pointArray = PacketUtilsKt.readFloatList(packetData, numPoints * 3);
        return new Triple((Object)delay, colorArray, pointArray);
    }

    @Environment(value=EnvType.CLIENT)
    public final void drawDebugPointsClient(@NotNull class_310 client, @NotNull class_2540 packetData) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)packetData, (String)"packetData");
        Triple<Integer, List<Float>, List<Float>> triple = this.unpackDrawDebugPoints(packetData);
        int delay = ((Number)triple.component1()).intValue();
        List colorArray = (List)triple.component2();
        List pointArray = (List)triple.component3();
        client.execute(() -> DebugPointsNetworkHandler.drawDebugPointsClient$lambda-2(delay, colorArray, pointArray));
    }

    private static final void drawDebugPointsClient$lambda-2(int $delay, List $colorArray, List $pointArray) {
        Intrinsics.checkNotNullParameter((Object)$colorArray, (String)"$colorArray");
        Intrinsics.checkNotNullParameter((Object)$pointArray, (String)"$pointArray");
        Function1 renderer2 = (Function1)new Function1<RenderData, Unit>((List<Float>)$colorArray, (List<Float>)$pointArray){
            final /* synthetic */ List<Float> $colorArray;
            final /* synthetic */ List<Float> $pointArray;
            {
                this.$colorArray = $colorArray;
                this.$pointArray = $pointArray;
                super(1);
            }

            public final void invoke(@NotNull RenderData renderData) {
                Intrinsics.checkNotNullParameter((Object)renderData, (String)"renderData");
                RenderUtils.INSTANCE.renderPoints(renderData, this.$colorArray, this.$pointArray);
            }
        };
        Function0 removeEvent2 = (Function0)new Function0<Unit>((Function1<? super RenderData, Unit>)renderer2){
            final /* synthetic */ Function1<RenderData, Unit> $renderer;
            {
                this.$renderer = $renderer;
                super(0);
            }

            public final void invoke() {
                MaelstromMod.INSTANCE.getRenderMap().getRenderMap().remove(this.$renderer);
            }
        };
        MaelstromMod.INSTANCE.getRenderMap().getRenderMap().add((Function1<RenderData, Unit>)renderer2);
        MaelstromMod.INSTANCE.getClientEventScheduler().addEvent(new TimedEvent(removeEvent2, $delay, 0, null, 12, null));
    }
}

