/*
 * Decompiled with CFR 0.152.
 */
package net.barribob.maelstrom.general.random;

import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J!\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\rJ \u0010\u000e\u001a\u00020\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u00120\u0011J\u000e\u0010\u0013\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u0014R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lnet/barribob/maelstrom/general/random/WeightedRandom;", "E", "", "random", "Ljava/util/Random;", "(Ljava/util/Random;)V", "map", "Ljava/util/NavigableMap;", "", "total", "add", "weight", "result", "(DLjava/lang/Object;)Lnet/barribob/maelstrom/general/random/WeightedRandom;", "addAll", "", "collection", "", "Lkotlin/Pair;", "next", "()Ljava/lang/Object;", "maelstrom-library"})
public final class WeightedRandom<E> {
    @NotNull
    private final Random random;
    @NotNull
    private final NavigableMap<Double, E> map;
    private double total;

    public WeightedRandom(@NotNull Random random) {
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        this.random = random;
        this.map = new TreeMap();
    }

    public /* synthetic */ WeightedRandom(Random random, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            random = new Random();
        }
        this(random);
    }

    @NotNull
    public final WeightedRandom<E> add(double weight, E result) {
        if (weight <= 0.0) {
            return this;
        }
        if (!(!Double.isNaN(weight) && !Double.isInfinite(weight))) {
            boolean bl = false;
            String string = Intrinsics.stringPlus((String)"The weight for random collection is invalid: ", (Object)weight);
            throw new IllegalArgumentException(string.toString());
        }
        this.total += weight;
        Map map = this.map;
        Double d = this.total;
        map.put(d, result);
        return this;
    }

    public final void addAll(@NotNull Collection<? extends Pair<Double, ? extends E>> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        for (Pair<Double, E> pair : collection) {
            this.add(((Number)pair.getFirst()).doubleValue(), pair.getSecond());
        }
    }

    public final E next() {
        double value = this.random.nextDouble() * this.total;
        return this.map.higherEntry(value).getValue();
    }

    public WeightedRandom() {
        this(null, 1, null);
    }
}

