/*
 * Decompiled with CFR 0.152.
 */
package net.barribob.maelstrom.general.event;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import net.barribob.maelstrom.general.event.IEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\u0005\u001a\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lnet/barribob/maelstrom/general/event/EventSeries;", "Lnet/barribob/maelstrom/general/event/IEvent;", "events", "", "([Lnet/barribob/maelstrom/general/event/IEvent;)V", "currentEvent", "getCurrentEvent", "()Lnet/barribob/maelstrom/general/event/IEvent;", "setCurrentEvent", "(Lnet/barribob/maelstrom/general/event/IEvent;)V", "iterator", "", "getIterator", "()Ljava/util/Iterator;", "doEvent", "", "shouldDoEvent", "", "shouldRemoveEvent", "tickSize", "", "maelstrom-library"})
public final class EventSeries
implements IEvent {
    @NotNull
    private final Iterator<IEvent> iterator;
    @NotNull
    private IEvent currentEvent;

    public EventSeries(IEvent ... events) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        this.iterator = ArrayIteratorKt.iterator((Object[])events);
        if (!this.iterator.hasNext()) {
            throw new IllegalArgumentException("Must have at least one event");
        }
        this.currentEvent = this.iterator.next();
    }

    @NotNull
    public final Iterator<IEvent> getIterator() {
        return this.iterator;
    }

    @NotNull
    public final IEvent getCurrentEvent() {
        return this.currentEvent;
    }

    public final void setCurrentEvent(@NotNull IEvent iEvent) {
        Intrinsics.checkNotNullParameter((Object)iEvent, (String)"<set-?>");
        this.currentEvent = iEvent;
    }

    @Override
    public boolean shouldDoEvent() {
        return this.currentEvent.shouldDoEvent();
    }

    @Override
    public void doEvent() {
        this.currentEvent.doEvent();
    }

    @Override
    public boolean shouldRemoveEvent() {
        while (this.currentEvent.shouldRemoveEvent()) {
            if (this.iterator.hasNext()) {
                this.currentEvent = this.iterator.next();
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public int tickSize() {
        return this.currentEvent.tickSize();
    }
}

