/*
 * Decompiled with CFR 0.152.
 */
package net.barribob.maelstrom.general.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.barribob.maelstrom.general.event.EventScheduler;
import net.barribob.maelstrom.general.event.IEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u0006\u0010\r\u001a\u00020\u000bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lnet/barribob/maelstrom/general/event/EventScheduler;", "", "()V", "eventQueue", "", "Lnet/barribob/maelstrom/general/event/IEvent;", "eventsToAdd", "", "ticks", "", "addEvent", "", "event", "updateEvents", "maelstrom-library"})
public final class EventScheduler {
    private int ticks;
    @NotNull
    private final List<IEvent> eventQueue = new ArrayList();
    @NotNull
    private final Set<IEvent> eventsToAdd = new LinkedHashSet();

    public final void updateEvents() {
        this.eventQueue.addAll((Collection<IEvent>)this.eventsToAdd);
        this.eventsToAdd.clear();
        for (IEvent iEvent : this.eventQueue) {
            if (this.ticks % iEvent.tickSize() != 0 || !iEvent.shouldDoEvent()) continue;
            iEvent.doEvent();
        }
        CollectionsKt.removeAll(this.eventQueue, (Function1)updateEvents.1.INSTANCE);
        int n = this.ticks;
        this.ticks = n + 1;
    }

    public final void addEvent(@NotNull IEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.eventsToAdd.add(event);
    }
}

